/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.helper;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

public class MessageBox {
    private XFrame xFrame;
    private XToolkit xToolkit;

    public MessageBox(XComponentContext xContext) {
        this(xContext, null);
    }

    public MessageBox(XComponentContext xContext, XFrame xFrame) {
        try {
            Object toolkit = xContext.getServiceManager().createInstanceWithContext("com.sun.star.awt.Toolkit", xContext);
            this.xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)toolkit);
            if (xFrame == null) {
                Object desktop = xContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
                XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
                xFrame = xDesktop.getCurrentFrame();
            }
            this.xFrame = xFrame;
        }
        catch (Exception e) {
            this.xToolkit = null;
            xFrame = null;
        }
    }

    public void showMessage(String sTitle, String sMessage) {
        if (this.xToolkit == null || this.xFrame == null) {
            return;
        }
        try {
            XMessageBox xMessageBox;
            WindowDescriptor descriptor = new WindowDescriptor();
            descriptor.Type = WindowClass.MODALTOP;
            descriptor.WindowServiceName = "infobox";
            descriptor.ParentIndex = (short)-1;
            descriptor.Parent = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getContainerWindow());
            descriptor.Bounds = new Rectangle(0, 0, 300, 200);
            descriptor.WindowAttributes = 208;
            XWindowPeer xPeer = this.xToolkit.createWindow(descriptor);
            if (xPeer != null && (xMessageBox = (XMessageBox)UnoRuntime.queryInterface(XMessageBox.class, (Object)xPeer)) != null) {
                xMessageBox.setCaptionText(sTitle);
                xMessageBox.setMessageText(sMessage);
                xMessageBox.execute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

