/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl;

import com.jogamp.common.os.Platform;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLException;

public class ShaderProgram {
    protected boolean programLinked = false;
    protected boolean programInUse = false;
    protected int shaderProgram = 0;
    protected HashSet<ShaderCode> allShaderCode = new HashSet();
    protected HashSet<ShaderCode> attachedShaderCode = new HashSet();
    protected int id = ShaderProgram.getNextID();
    protected static int nextID = 1;

    public boolean linked() {
        return this.programLinked;
    }

    public boolean inUse() {
        return this.programInUse;
    }

    public int program() {
        return this.shaderProgram;
    }

    public int id() {
        return this.id;
    }

    public synchronized void destroy(GL2ES2 gL2ES2) {
        this.release(gL2ES2, true);
    }

    public synchronized void release(GL2ES2 gL2ES2) {
        this.release(gL2ES2, false);
    }

    public synchronized void release(GL2ES2 gL2ES2, boolean bl) {
        if (this.programLinked) {
            this.useProgram(gL2ES2, false);
        }
        for (ShaderCode shaderCode : this.allShaderCode) {
            if (this.attachedShaderCode.remove(shaderCode)) {
                ShaderUtil.detachShader(gL2ES2, this.shaderProgram, shaderCode.shader());
            }
            if (!bl) continue;
            shaderCode.destroy(gL2ES2);
        }
        this.allShaderCode.clear();
        this.attachedShaderCode.clear();
        if (0 != this.shaderProgram) {
            gL2ES2.glDeleteProgram(this.shaderProgram);
            this.shaderProgram = 0;
        }
    }

    public synchronized void add(ShaderCode shaderCode) throws GLException {
        this.allShaderCode.add(shaderCode);
    }

    public synchronized boolean contains(ShaderCode shaderCode) {
        return this.allShaderCode.contains(shaderCode);
    }

    public synchronized ShaderCode getShader(int n) {
        for (ShaderCode shaderCode : this.allShaderCode) {
            if (shaderCode.id() != n) continue;
            return shaderCode;
        }
        return null;
    }

    public final synchronized boolean init(GL2ES2 gL2ES2) {
        if (0 == this.shaderProgram) {
            this.shaderProgram = gL2ES2.glCreateProgram();
        }
        return 0 != this.shaderProgram;
    }

    public synchronized boolean add(GL2ES2 gL2ES2, ShaderCode shaderCode, PrintStream printStream) {
        if (!this.init(gL2ES2)) {
            return false;
        }
        if (this.allShaderCode.add(shaderCode)) {
            if (!shaderCode.compile(gL2ES2, printStream)) {
                return false;
            }
            if (this.attachedShaderCode.add(shaderCode)) {
                ShaderUtil.attachShader(gL2ES2, this.shaderProgram, shaderCode.shader());
            }
        }
        return true;
    }

    public synchronized boolean replaceShader(GL2ES2 gL2ES2, ShaderCode shaderCode, ShaderCode shaderCode2, PrintStream printStream) {
        if (!this.init(gL2ES2) || !shaderCode2.compile(gL2ES2, printStream)) {
            return false;
        }
        boolean bl = this.inUse();
        if (bl) {
            this.useProgram(gL2ES2, false);
        }
        if (null != shaderCode && this.allShaderCode.remove(shaderCode) && this.attachedShaderCode.remove(shaderCode)) {
            ShaderUtil.detachShader(gL2ES2, this.shaderProgram, shaderCode.shader());
        }
        this.add(shaderCode2);
        if (this.attachedShaderCode.add(shaderCode2)) {
            ShaderUtil.attachShader(gL2ES2, this.shaderProgram, shaderCode2.shader());
        }
        gL2ES2.glLinkProgram(this.shaderProgram);
        this.programLinked = ShaderUtil.isProgramLinkStatusValid(gL2ES2, this.shaderProgram, printStream);
        if (this.programLinked && bl) {
            this.useProgram(gL2ES2, true);
        }
        return this.programLinked;
    }

    public synchronized boolean link(GL2ES2 gL2ES2, PrintStream printStream) {
        if (!this.init(gL2ES2)) {
            this.programLinked = false;
            return false;
        }
        for (ShaderCode shaderCode : this.allShaderCode) {
            if (!shaderCode.compile(gL2ES2, printStream)) {
                this.programLinked = false;
                return false;
            }
            if (!this.attachedShaderCode.add(shaderCode)) continue;
            ShaderUtil.attachShader(gL2ES2, this.shaderProgram, shaderCode.shader());
        }
        gL2ES2.glLinkProgram(this.shaderProgram);
        this.programLinked = ShaderUtil.isProgramLinkStatusValid(gL2ES2, this.shaderProgram, printStream);
        return this.programLinked;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ShaderProgram) {
            return this.id() == ((ShaderProgram)object).id();
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("ShaderProgram[id=").append(this.id);
        stringBuilder.append(", linked=" + this.programLinked + ", inUse=" + this.programInUse + ", program: " + this.shaderProgram + ",");
        Iterator<ShaderCode> iterator = this.allShaderCode.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(Platform.getNewline()).append("   ").append(iterator.next());
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    public synchronized boolean validateProgram(GL2ES2 gL2ES2, PrintStream printStream) {
        return ShaderUtil.isProgramExecStatusValid(gL2ES2, this.shaderProgram, printStream);
    }

    public synchronized void useProgram(GL2ES2 gL2ES2, boolean bl) {
        if (!this.programLinked) {
            throw new GLException("Program is not linked");
        }
        if (this.programInUse == bl) {
            return;
        }
        if (0 == this.shaderProgram) {
            bl = false;
        }
        gL2ES2.glUseProgram(bl ? this.shaderProgram : 0);
        this.programInUse = bl;
    }

    private static synchronized int getNextID() {
        return nextID++;
    }
}

