/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import java.nio.IntBuffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;

public class EGLDisplayUtil {
    private static final boolean DEBUG = Debug.debug("EGLDisplayUtil");
    private static boolean useSingletonEGLDisplay = false;
    private static EGLDisplayRef singletonEGLDisplay = null;
    private static final LongObjectHashMap openEGLDisplays = new LongObjectHashMap();
    private static final EGLGraphicsDevice.EGLDisplayLifecycleCallback eglLifecycleCallback;

    public static int shutdown(boolean bl) {
        if (DEBUG || bl || openEGLDisplays.size() > 0) {
            System.err.println("EGLDisplayUtil.EGLDisplays: Shutdown (open: " + openEGLDisplays.size() + ")");
            if (DEBUG) {
                Thread.dumpStack();
            }
            if (openEGLDisplays.size() > 0) {
                EGLDisplayUtil.dumpOpenDisplayConnections();
            }
        }
        return openEGLDisplays.size();
    }

    public static void dumpOpenDisplayConnections() {
        System.err.println("EGLDisplayUtil: Open EGL Display Connections: " + openEGLDisplays.size());
        int n = 0;
        for (LongObjectHashMap.Entry entry : openEGLDisplays) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)entry.value;
            System.err.println("EGLDisplayUtil: Open[" + n + "]: 0x" + Long.toHexString(entry.key) + ": " + eGLDisplayRef);
            if (null != eGLDisplayRef.createdStack) {
                eGLDisplayRef.createdStack.printStackTrace();
            }
            ++n;
        }
    }

    static synchronized void setSingletonEGLDisplayOnly(boolean bl) {
        useSingletonEGLDisplay = bl;
    }

    private static synchronized long eglGetDisplay(long l) {
        if (useSingletonEGLDisplay && null != singletonEGLDisplay) {
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetDisplay.s: eglDisplay(" + EGLContext.toHexString(l) + "): " + EGLContext.toHexString(EGLDisplayUtil.singletonEGLDisplay.eglDisplay) + ", " + (0L != EGLDisplayUtil.singletonEGLDisplay.eglDisplay ? "OK" : "Failed") + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
            }
            return EGLDisplayUtil.singletonEGLDisplay.eglDisplay;
        }
        long l2 = EGL.eglGetDisplay(l);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglGetDisplay.X: eglDisplay(" + EGLContext.toHexString(l) + "): " + EGLContext.toHexString(l2) + ", " + (0L != l2 ? "OK" : "Failed") + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return l2;
    }

    private static synchronized boolean eglInitialize(long l, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (0L == l) {
            return false;
        }
        EGLDisplayRef eGLDisplayRef = EGLDisplayRef.getOrCreateOpened(l, intBuffer, intBuffer2);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglInitialize(" + EGLContext.toHexString(l) + " ...): " + eGLDisplayRef + " = " + (null != eGLDisplayRef) + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return null != eGLDisplayRef;
    }

    private static synchronized int eglGetDisplayAndInitialize(long l, long[] lArray, int[] nArray, IntBuffer intBuffer, IntBuffer intBuffer2) {
        lArray[0] = 0L;
        long l2 = EGLDisplayUtil.eglGetDisplay(l);
        if (0L == l2) {
            nArray[0] = EGL.eglGetError();
            return 12296;
        }
        if (!EGLDisplayUtil.eglInitialize(l2, intBuffer, intBuffer2)) {
            nArray[0] = EGL.eglGetError();
            return 12289;
        }
        lArray[0] = l2;
        return 12288;
    }

    private static synchronized long eglGetDisplayAndInitialize(long[] lArray) {
        long[] lArray2 = new long[1];
        int[] nArray = new int[1];
        int n = EGLDisplayUtil.eglGetDisplayAndInitialize(lArray[0], lArray2, nArray, null, null);
        if (12288 == n) {
            return lArray2[0];
        }
        if (0L != lArray[0]) {
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetAndInitDisplay failed with native " + EGLContext.toHexString(lArray[0]) + ", error " + EGLContext.toHexString(n) + "/" + EGLContext.toHexString(nArray[0]) + " - fallback!");
            }
            if (12288 == (n = EGLDisplayUtil.eglGetDisplayAndInitialize(0L, lArray2, nArray, null, null))) {
                lArray[0] = 0L;
                return lArray2[0];
            }
        }
        throw new GLException("Failed to created/initialize EGL display incl. fallback default: native " + EGLContext.toHexString(lArray[0]) + ", error " + EGLContext.toHexString(n) + "/" + EGLContext.toHexString(nArray[0]));
    }

    private static synchronized boolean eglTerminate(long l) {
        if (0L == l) {
            return false;
        }
        boolean[] blArray = new boolean[1];
        EGLDisplayRef eGLDisplayRef = EGLDisplayRef.closeOpened(l, blArray);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglTerminate.X(" + EGLContext.toHexString(l) + " ...): " + eGLDisplayRef + " = " + blArray[0] + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return blArray[0];
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(long l, String string, int n) {
        return new EGLGraphicsDevice(l, 0L, string, n, eglLifecycleCallback);
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(NativeSurface nativeSurface) {
        long l = NativeWindowFactory.TYPE_WINDOWS == NativeWindowFactory.getNativeWindowType(false) ? nativeSurface.getSurfaceHandle() : nativeSurface.getDisplayHandle();
        AbstractGraphicsDevice abstractGraphicsDevice = nativeSurface.getGraphicsConfiguration().getScreen().getDevice();
        return new EGLGraphicsDevice(l, 0L, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), eglLifecycleCallback);
    }

    static {
        openEGLDisplays.setKeyNotFoundValue(null);
        eglLifecycleCallback = new EGLGraphicsDevice.EGLDisplayLifecycleCallback(){

            @Override
            public long eglGetAndInitDisplay(long[] lArray) {
                return EGLDisplayUtil.eglGetDisplayAndInitialize(lArray);
            }

            @Override
            public void eglTerminate(long l) {
                EGLDisplayUtil.eglTerminate(l);
            }
        };
    }

    private static class EGLDisplayRef {
        final long eglDisplay;
        final Throwable createdStack;
        int initRefCount;

        static EGLDisplayRef getOrCreateOpened(long l, IntBuffer intBuffer, IntBuffer intBuffer2) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)openEGLDisplays.get(l);
            if (null == eGLDisplayRef) {
                if (EGL.eglInitialize(l, intBuffer, intBuffer2)) {
                    EGLDisplayRef eGLDisplayRef2 = new EGLDisplayRef(l);
                    openEGLDisplays.put(l, (Object)eGLDisplayRef2);
                    ++eGLDisplayRef2.initRefCount;
                    if (null == singletonEGLDisplay) {
                        singletonEGLDisplay = eGLDisplayRef2;
                    }
                    return eGLDisplayRef2;
                }
                return null;
            }
            ++eGLDisplayRef.initRefCount;
            return eGLDisplayRef;
        }

        static EGLDisplayRef closeOpened(long l, boolean[] blArray) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)openEGLDisplays.get(l);
            blArray[0] = true;
            if (null != eGLDisplayRef) {
                if (0 < eGLDisplayRef.initRefCount) {
                    --eGLDisplayRef.initRefCount;
                    if (0 == eGLDisplayRef.initRefCount) {
                        blArray[0] = EGL.eglTerminate(l);
                        if (eGLDisplayRef == singletonEGLDisplay) {
                            singletonEGLDisplay = null;
                        }
                    }
                }
                if (0 >= eGLDisplayRef.initRefCount) {
                    openEGLDisplays.remove(l);
                }
            }
            return eGLDisplayRef;
        }

        private EGLDisplayRef(long l) {
            this.eglDisplay = l;
            this.initRefCount = 0;
            this.createdStack = DEBUG ? new Throwable() : null;
        }

        public String toString() {
            return "EGLDisplayRef[0x" + Long.toHexString(this.eglDisplay) + ": refCnt " + this.initRefCount + "]";
        }
    }
}

