/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

class Atom {
    private static Applet applet;
    private static byte[] data;
    private static final int R = 40;
    private static final int hx = 15;
    private static final int hy = 15;
    private static final int bgGrey = 192;
    private static final int nBalls = 16;
    private static int maxr;
    private int Rl;
    private int Gl;
    private int Bl;
    private Image[] balls;

    static void setApplet(Applet app) {
        applet = app;
    }

    Atom(int Rl, int Gl, int Bl) {
        this.Rl = Rl;
        this.Gl = Gl;
        this.Bl = Bl;
    }

    private int blend(int fg, int bg, float fgfactor) {
        return (int)((float)bg + (float)(fg - bg) * fgfactor);
    }

    private void Setup() {
        this.balls = new Image[16];
        byte[] red = new byte[256];
        red[0] = -64;
        byte[] green = new byte[256];
        green[0] = -64;
        byte[] blue = new byte[256];
        blue[0] = -64;
        for (int r = 0; r < 16; ++r) {
            float b = (float)(r + 1) / 16.0f;
            for (int i = maxr; i >= 1; --i) {
                float d = (float)i / (float)maxr;
                red[i] = (byte)this.blend(this.blend(this.Rl, 255, d), 192, b);
                green[i] = (byte)this.blend(this.blend(this.Gl, 255, d), 192, b);
                blue[i] = (byte)this.blend(this.blend(this.Bl, 255, d), 192, b);
            }
            IndexColorModel model = new IndexColorModel(8, maxr + 1, red, green, blue, 0);
            this.balls[r] = applet.createImage(new MemoryImageSource(80, 80, (ColorModel)model, data, 0, 80));
        }
    }

    void paint(Graphics gc, int x, int y, int r) {
        Image[] ba = this.balls;
        if (ba == null) {
            this.Setup();
            ba = this.balls;
        }
        Image i = ba[r];
        int size = 10 + r;
        gc.drawImage(i, x - (size >> 1), y - (size >> 1), size, size, applet);
    }

    static {
        data = new byte[6400];
        int mr = 0;
        int Y = 80;
        while (--Y >= 0) {
            int x0 = (int)(Math.sqrt(1600 - (Y - 40) * (Y - 40)) + 0.5);
            int p = Y * 80 + 40 - x0;
            for (int X = -x0; X < x0; ++X) {
                int x = X + 15;
                int y = Y - 40 + 15;
                int r = (int)(Math.sqrt(x * x + y * y) + 0.5);
                if (r > mr) {
                    mr = r;
                }
                Atom.data[p++] = r <= 0 ? (byte)1 : (byte)r;
            }
        }
        maxr = mr;
    }
}

