/* libdazzle-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Dzl", gir_namespace = "Dazzle", gir_version = "1.0", lower_case_cprefix = "dzl_")]
namespace Dazzle {
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_animation_get_type ()")]
	public class Animation : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		protected Animation ();
		public void add_property (GLib.ParamSpec pspec, GLib.Value value);
		public static uint calculate_duration (Gdk.Monitor monitor, double from_value, double to_value);
		public void start ();
		public void stop ();
		public uint duration { construct; }
		public Gdk.FrameClock frame_clock { construct; }
		public Dazzle.AnimationMode mode { construct; }
		public GLib.Object target { construct; }
		public signal void tick ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_application_get_type ()")]
	public class Application : Gtk.Application, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected Application ();
		public virtual void add_resources (string resource_path);
		public unowned GLib.Menu get_menu_by_id (string menu_id);
		public unowned Dazzle.MenuManager get_menu_manager ();
		public unowned Dazzle.ShortcutManager get_shortcut_manager ();
		public unowned Dazzle.ThemeManager get_theme_manager ();
		public virtual void remove_resources (string resource_path);
		public Dazzle.MenuManager menu_manager { get; }
		public Dazzle.ShortcutManager shortcut_manager { get; }
		public Dazzle.ThemeManager theme_manager { get; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_application_window_get_type ()")]
	public class ApplicationWindow : Gtk.ApplicationWindow, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected ApplicationWindow ();
		[Version (since = "3.26")]
		public virtual bool get_fullscreen ();
		[Version (since = "3.26")]
		public unowned Gtk.Widget get_titlebar ();
		[Version (since = "3.26")]
		public virtual void set_fullscreen (bool fullscreen);
		[Version (since = "3.26")]
		public void set_titlebar (Gtk.Widget titlebar);
		public bool fullscreen { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_bin_get_type ()")]
	public class Bin : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Bin ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_binding_group_get_type ()")]
	public class BindingGroup : GLib.Object {
		[CCode (has_construct_function = false)]
		public BindingGroup ();
		public void bind (string source_property, GLib.Object target, string target_property, GLib.BindingFlags flags);
		public void bind_full (string source_property, GLib.Object target, string target_property, GLib.BindingFlags flags, GLib.BindingTransformFunc? transform_to, owned GLib.BindingTransformFunc? transform_from);
		public void bind_with_closures (string source_property, GLib.Object target, string target_property, GLib.BindingFlags flags, GLib.Closure? transform_to, GLib.Closure? transform_from);
		public unowned GLib.Object? get_source ();
		public void set_source (GLib.Object? source);
		public GLib.Object source { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_bolding_label_get_type ()")]
	public class BoldingLabel : Gtk.Label, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected BoldingLabel ();
		public void set_bold (bool bold);
		public void set_weight (Pango.Weight weight);
		public bool bold { set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_box_get_type ()")]
	public class Box : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Box ();
		public int get_max_width_request ();
		public unowned Gtk.Widget? get_nth_child (uint nth);
		public void set_max_width_request (int max_width_request);
		public int max_width_request { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_box_theatric_get_type ()")]
	public class BoxTheatric : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BoxTheatric ();
		[NoAccessorMethod]
		public double alpha { get; set; }
		[NoAccessorMethod]
		public string background { owned get; set; }
		[NoAccessorMethod]
		public int height { get; set; }
		[NoAccessorMethod]
		public GLib.Icon icon { owned get; set; }
		public void* surface { construct; }
		[NoAccessorMethod]
		public Gtk.Widget target { owned get; construct; }
		[NoAccessorMethod]
		public int width { get; set; }
		[NoAccessorMethod]
		public int x { get; set; }
		[NoAccessorMethod]
		public int y { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_centering_bin_get_type ()")]
	public class CenteringBin : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public CenteringBin ();
		[NoAccessorMethod]
		public int max_width_request { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_child_property_action_get_type ()")]
	public class ChildPropertyAction : GLib.Object, GLib.Action {
		[CCode (has_construct_function = false)]
		protected ChildPropertyAction ();
		public static GLib.Action @new (string name, Gtk.Container container, Gtk.Widget child, string child_property_name);
		[NoAccessorMethod]
		public Gtk.Widget child { owned get; }
		[NoAccessorMethod]
		public string child_property_name { owned get; }
		[NoAccessorMethod]
		public Gtk.Container container { owned get; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_column_layout_get_type ()")]
	public class ColumnLayout : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ColumnLayout ();
		public int get_column_spacing ();
		public int get_column_width ();
		public uint get_max_columns ();
		public int get_row_spacing ();
		public void set_column_spacing (int column_spacing);
		public void set_column_width (int column_width);
		public void set_max_columns (uint max_columns);
		public void set_row_spacing (int row_spacing);
		public int column_spacing { get; set; }
		public int column_width { get; set; }
		public uint max_columns { get; set; }
		public int row_spacing { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", ref_function = "dzl_counter_arena_ref", type_id = "dzl_counter_arena_get_type ()", unref_function = "dzl_counter_arena_unref")]
	[Compact]
	public class CounterArena {
		[CCode (has_construct_function = false)]
		public CounterArena.for_pid (GLib.Pid pid);
		public void @foreach (Dazzle.CounterForeachFunc func);
		[CCode (cheader_filename = "dazzle.h")]
		public static Dazzle.CounterArena get_default ();
		public Dazzle.CounterArena @ref ();
		public void register (Dazzle.Counter counter);
		public void unref ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_counters_window_get_type ()")]
	public class CountersWindow : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public CountersWindow ();
		public unowned Dazzle.CounterArena? get_arena ();
		public void set_arena (Dazzle.CounterArena arena);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_cpu_graph_get_type ()")]
	public class CpuGraph : Dazzle.GraphView, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public CpuGraph ();
		[NoAccessorMethod]
		public uint max_samples { get; construct; }
		[NoAccessorMethod]
		public int64 timespan { get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_cpu_model_get_type ()")]
	public class CpuModel : Dazzle.GraphModel {
		[CCode (has_construct_function = false, type = "DzlGraphModel*")]
		public CpuModel ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_css_provider_get_type ()")]
	public class CssProvider : Gtk.CssProvider, Gtk.StyleProvider {
		[CCode (has_construct_function = false, type = "GtkCssProvider*")]
		public CssProvider (string base_path);
		[NoAccessorMethod]
		public string base_path { owned get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_directory_model_get_type ()")]
	public class DirectoryModel : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected DirectoryModel ();
		public unowned GLib.File get_directory ();
		public static GLib.ListModel @new (GLib.File directory);
		public void set_directory (GLib.File directory);
		public void set_visible_func (owned Dazzle.DirectoryModelVisibleFunc visible_func);
		public GLib.File directory { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_directory_reaper_get_type ()")]
	public class DirectoryReaper : GLib.Object {
		[CCode (has_construct_function = false)]
		public DirectoryReaper ();
		public void add_directory (GLib.File directory, GLib.TimeSpan min_age);
		public void add_file (GLib.File file, GLib.TimeSpan min_age);
		public void add_glob (GLib.File directory, string glob, GLib.TimeSpan min_age);
		public bool execute (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool execute_async (GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_bin_get_type ()")]
	public class DockBin : Gtk.Container, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public DockBin ();
		public unowned Gtk.Widget get_bottom_edge ();
		public unowned Gtk.Widget? get_center_widget ();
		public unowned Gtk.Widget get_left_edge ();
		public unowned Gtk.Widget get_right_edge ();
		public unowned Gtk.Widget get_top_edge ();
		[NoAccessorMethod]
		public bool bottom_visible { get; set; }
		[NoAccessorMethod]
		public bool left_visible { get; set; }
		[NoAccessorMethod]
		public bool right_visible { get; set; }
		[NoAccessorMethod]
		public bool top_visible { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_bin_edge_get_type ()")]
	public class DockBinEdge : Dazzle.DockRevealer, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected DockBinEdge ();
		public Gtk.PositionType get_edge ();
		[NoAccessorMethod]
		public Gtk.PositionType edge { get; set; }
		public virtual signal void move_to_bin_child ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_manager_get_type ()")]
	public class DockManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public DockManager ();
		[Version (since = "3.26")]
		public void pause_grabs ();
		[Version (since = "3.26")]
		public void unpause_grabs ();
		[HasEmitter]
		public virtual signal void register_dock (Dazzle.Dock dock);
		[HasEmitter]
		public virtual signal void unregister_dock (Dazzle.Dock dock);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_overlay_get_type ()")]
	public class DockOverlay : Gtk.EventBox, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public DockOverlay ();
		public unowned Dazzle.DockOverlayEdge get_edge (Gtk.PositionType position);
		public unowned Gtk.Adjustment get_edge_adjustment (Gtk.PositionType position);
		public virtual signal void hide_edges ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_overlay_edge_get_type ()")]
	public class DockOverlayEdge : Dazzle.Bin, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected DockOverlayEdge ();
		public Gtk.PositionType get_edge ();
		public int get_position ();
		public void set_edge (Gtk.PositionType edge);
		public void set_position (int position);
		public Gtk.PositionType edge { get; set; }
		public int position { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_paned_get_type ()")]
	public class DockPaned : Dazzle.MultiPaned, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public DockPaned ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_revealer_get_type ()")]
	public class DockRevealer : Dazzle.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public DockRevealer ();
		public void animate_to_position (int position, uint transition_duration);
		public bool get_child_revealed ();
		public int get_position ();
		public bool get_position_set ();
		public bool get_reveal_child ();
		public uint get_transition_duration ();
		public Dazzle.DockRevealerTransitionType get_transition_type ();
		public bool is_animating ();
		public void set_position (int position);
		public void set_position_set (bool position_set);
		public void set_reveal_child (bool reveal_child);
		public void set_transition_duration (uint transition_duration);
		public void set_transition_type (Dazzle.DockRevealerTransitionType transition_type);
		public bool child_revealed { get; }
		public int position { get; set; }
		public bool position_set { get; set; }
		public bool reveal_child { get; set; }
		public uint transition_duration { get; set; }
		public Dazzle.DockRevealerTransitionType transition_type { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_stack_get_type ()")]
	public class DockStack : Gtk.Box, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public DockStack ();
		public Gtk.PositionType get_edge ();
		public bool get_show_pinned_button ();
		public Dazzle.TabStyle get_style ();
		public void set_edge (Gtk.PositionType edge);
		public void set_show_pinned_button (bool show_pinned_button);
		public void set_style (Dazzle.TabStyle style);
		public Gtk.PositionType edge { get; set; }
		public bool show_pinned_button { get; set; }
		public Dazzle.TabStyle style { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_transient_grab_get_type ()")]
	public class DockTransientGrab : GLib.Object {
		[CCode (has_construct_function = false)]
		public DockTransientGrab ();
		public void acquire ();
		public void add_item (Dazzle.DockItem item);
		public bool contains (Dazzle.DockItem item);
		public uint get_timeout ();
		public bool is_descendant (Gtk.Widget widget);
		public void release ();
		public void remove_item (Dazzle.DockItem item);
		public void set_timeout (uint timeout);
		public void steal_common_ancestors (Dazzle.DockTransientGrab other);
		public uint timeout { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_widget_get_type ()")]
	public class DockWidget : Dazzle.Bin, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public DockWidget ();
		public void set_icon_name (string icon_name);
		public void set_title (string title);
		[NoAccessorMethod]
		public bool can_close { get; set; }
		[NoAccessorMethod]
		public string icon_name { owned get; set; }
		[NoAccessorMethod]
		public Dazzle.DockManager manager { owned get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_dock_window_get_type ()")]
	public class DockWindow : Gtk.Window, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public DockWindow ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_elastic_bin_get_type ()")]
	public class ElasticBin : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ElasticBin ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_empty_state_get_type ()")]
	public class EmptyState : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public EmptyState ();
		public unowned string get_icon_name ();
		public unowned string get_subtitle ();
		public unowned string get_title ();
		public void set_icon_name (string icon_name);
		public void set_resource (string resource);
		public void set_subtitle (string title);
		public void set_title (string title);
		public string icon_name { get; set; }
		[NoAccessorMethod]
		public int pixel_size { get; set; }
		public string resource { set; }
		public string subtitle { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_entry_box_get_type ()")]
	public class EntryBox : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public EntryBox ();
		[NoAccessorMethod]
		public int max_width_chars { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_file_chooser_entry_get_type ()")]
	public class FileChooserEntry : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public FileChooserEntry (string title, Gtk.FileChooserAction action);
		public GLib.File? get_file ();
		public void set_file (GLib.File file);
		[NoAccessorMethod]
		public Gtk.FileChooserAction action { get; set; }
		[NoAccessorMethod]
		public bool create_folders { get; set; }
		[NoAccessorMethod]
		public bool do_overwrite_confirmation { get; set; }
		public GLib.File file { owned get; set; }
		[NoAccessorMethod]
		public Gtk.FileFilter filter { owned get; set; }
		[NoAccessorMethod]
		public bool local_only { get; set; }
		[NoAccessorMethod]
		public int max_width_chars { get; set; }
		[NoAccessorMethod]
		public bool show_hidden { get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_fuzzy_index_get_type ()")]
	public class FuzzyIndex : GLib.Object {
		[CCode (has_construct_function = false)]
		public FuzzyIndex ();
		public GLib.Variant? get_metadata (string key);
		public unowned string get_metadata_string (string key);
		public uint32 get_metadata_uint32 (string key);
		public uint64 get_metadata_uint64 (string key);
		public bool load_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool load_file_async (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async GLib.ListModel query_async (string query, uint max_matches, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_fuzzy_index_builder_get_type ()")]
	public class FuzzyIndexBuilder : GLib.Object {
		[CCode (has_construct_function = false)]
		public FuzzyIndexBuilder ();
		public bool get_case_sensitive ();
		public unowned GLib.Variant get_document (uint64 document_id);
		public uint64 insert (string key, GLib.Variant document, uint priority);
		public void set_case_sensitive (bool case_sensitive);
		public void set_metadata (string key, GLib.Variant value);
		public void set_metadata_string (string key, string value);
		public void set_metadata_uint32 (string key, uint32 value);
		public void set_metadata_uint64 (string key, uint64 value);
		public bool write (GLib.File file, int io_priority = GLib.Priority.LOW, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool write_async (GLib.File file, int io_priority = GLib.Priority.LOW, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool case_sensitive { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_fuzzy_index_cursor_get_type ()")]
	public class FuzzyIndexCursor : GLib.Object, GLib.AsyncInitable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected FuzzyIndexCursor ();
		public unowned Dazzle.FuzzyIndex get_index ();
		[NoAccessorMethod]
		public bool case_sensitive { get; construct; }
		public Dazzle.FuzzyIndex index { construct; }
		[NoAccessorMethod]
		public uint max_matches { get; construct; }
		[NoAccessorMethod]
		public string query { owned get; construct; }
		public GLib.VariantDict tables { construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_fuzzy_index_match_get_type ()")]
	public class FuzzyIndexMatch : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FuzzyIndexMatch ();
		public unowned GLib.Variant get_document ();
		public unowned string get_key ();
		public uint get_priority ();
		public float get_score ();
		public GLib.Variant document { get; construct; }
		public string key { get; construct; }
		public uint priority { get; construct; }
		public float score { get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", ref_function = "dzl_fuzzy_mutable_index_ref", type_id = "dzl_fuzzy_mutable_index_get_type ()", unref_function = "dzl_fuzzy_mutable_index_unref")]
	[Compact]
	public class FuzzyMutableIndex {
		[CCode (has_construct_function = false)]
		public FuzzyMutableIndex (bool case_sensitive);
		public void begin_bulk_insert ();
		public bool contains (string key);
		public void end_bulk_insert ();
		public void insert (string key, void* value);
		public GLib.Array<Dazzle.FuzzyMutableIndexMatch> match (string needle, size_t max_matches);
		public Dazzle.FuzzyMutableIndex @ref ();
		public void remove (string key);
		public void set_free_func (GLib.DestroyNotify free_func);
		public void unref ();
		[CCode (has_construct_function = false)]
		public FuzzyMutableIndex.with_free_func (bool case_sensitive, GLib.DestroyNotify free_func);
	}
	[CCode (cheader_filename = "dazzle.h", lower_case_csuffix = "graph_view_column", type_id = "dzl_graph_view_column_get_type ()")]
	public class GraphColumn : GLib.Object {
		[CCode (has_construct_function = false)]
		public GraphColumn (string name, GLib.Type value_type);
		public unowned string get_name ();
		public void set_name (string name);
		public string name { get; set; }
		[NoAccessorMethod]
		public GLib.Type value_type { get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", lower_case_csuffix = "graph_view_line_renderer", type_id = "dzl_graph_view_line_renderer_get_type ()")]
	public class GraphLineRenderer : GLib.Object, Dazzle.GraphRenderer {
		[CCode (has_construct_function = false)]
		public GraphLineRenderer ();
		public unowned Gdk.RGBA? get_stroke_color_rgba ();
		public void set_stroke_color (string stroke_color);
		public void set_stroke_color_rgba (Gdk.RGBA stroke_color_rgba);
		[NoAccessorMethod]
		public uint column { get; set; }
		[NoAccessorMethod]
		public double line_width { get; set; }
		[NoAccessorMethod]
		public string stroke_color { owned get; set; }
		public Gdk.RGBA stroke_color_rgba { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", lower_case_csuffix = "graph_view_model", type_id = "dzl_graph_view_model_get_type ()")]
	public class GraphModel : GLib.Object {
		[CCode (has_construct_function = false)]
		public GraphModel ();
		public uint add_column (Dazzle.GraphColumn column);
		public int64 get_end_time ();
		public bool get_iter_first (Dazzle.GraphModelIter iter);
		public bool get_iter_last (Dazzle.GraphModelIter iter);
		public uint get_max_samples ();
		public GLib.TimeSpan get_timespan ();
		public static int64 iter_get_timestamp (Dazzle.GraphModelIter iter);
		public static void iter_get_value (Dazzle.GraphModelIter iter, uint column, GLib.Value value);
		public static bool iter_next (Dazzle.GraphModelIter iter);
		public void push (out Dazzle.GraphModelIter iter, int64 timestamp);
		public void set_max_samples (uint n_rows);
		public void set_timespan (GLib.TimeSpan timespan);
		public uint max_samples { get; set construct; }
		public int64 timespan { get; set construct; }
		[NoAccessorMethod]
		public double value_max { get; set; }
		[NoAccessorMethod]
		public double value_min { get; set; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_graph_view_get_type ()")]
	public class GraphView : Gtk.DrawingArea, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public GraphView ();
		public void add_renderer (Dazzle.GraphRenderer renderer);
		public unowned Dazzle.GraphModel? get_model ();
		public void set_model (Dazzle.GraphModel model);
		public Dazzle.GraphModel model { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", ref_function = "dzl_heap_ref", type_id = "dzl_heap_get_type ()", unref_function = "dzl_heap_unref")]
	[Compact]
	public class Heap {
		public weak string data;
		public size_t len;
		[CCode (has_construct_function = false)]
		public Heap (uint element_size, [CCode (scope = "async")] GLib.CompareFunc compare_func);
		public bool extract (void* result);
		public bool extract_index (size_t index_, void* result);
		public void insert_vals (void* data, uint len);
		public Dazzle.Heap @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_joined_menu_get_type ()")]
	public class JoinedMenu : GLib.MenuModel {
		[CCode (has_construct_function = false)]
		public JoinedMenu ();
		public void append_menu (GLib.MenuModel model);
		public uint get_n_joined ();
		public void prepend_menu (GLib.MenuModel model);
		public void remove_index (uint index);
		public void remove_menu (GLib.MenuModel model);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_list_box_get_type ()")]
	public class ListBox : Gtk.ListBox, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public ListBox (GLib.Type row_type, string property_name);
		public unowned GLib.ListModel? get_model ();
		public unowned string get_property_name ();
		public GLib.Type get_row_type ();
		public void set_model (GLib.ListModel model);
		public string property_name { get; construct; }
		public GLib.Type row_type { get; construct; }
		public string row_type_name { construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_list_box_row_get_type ()")]
	public abstract class ListBoxRow : Gtk.ListBoxRow, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ListBoxRow ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_list_store_adapter_get_type ()")]
	public class ListStoreAdapter : GLib.Object, Gtk.TreeModel {
		[CCode (has_construct_function = false)]
		public ListStoreAdapter (GLib.ListModel model);
		[Version (since = "3.26")]
		public unowned GLib.ListModel get_model ();
		public void set_model (GLib.ListModel model);
		public GLib.ListModel model { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_menu_button_get_type ()")]
	public class MenuButton : Gtk.MenuButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected MenuButton ();
		[Version (since = "3.26")]
		public unowned GLib.MenuModel? get_model ();
		public bool get_show_accels ();
		public bool get_show_arrow ();
		public bool get_show_icons ();
		public void set_model (GLib.MenuModel model);
		[Version (since = "3.26")]
		public void set_show_accels (bool show_accels);
		[Version (since = "3.26")]
		public void set_show_arrow (bool show_arrow);
		[Version (since = "3.26")]
		public void set_show_icons (bool show_icons);
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public MenuButton.with_model (string icon_name, GLib.MenuModel? model);
		[NoAccessorMethod]
		public string icon_name { set; }
		[NoAccessorMethod]
		[Version (since = "3.26")]
		public string menu_id { set; }
		public GLib.MenuModel model { get; set; }
		public bool show_accels { get; set; }
		public bool show_arrow { get; set; }
		public bool show_icons { get; set; }
		[NoAccessorMethod]
		public bool transitions_enabled { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_menu_manager_get_type ()")]
	public class MenuManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public MenuManager ();
		public uint add_filename (string filename) throws GLib.Error;
		public uint add_resource (string resource) throws GLib.Error;
		public unowned GLib.Menu get_menu_by_id (string menu_id);
		public uint merge (string menu_id, GLib.MenuModel model);
		[Version (since = "3.26")]
		public void remove (uint merge_id);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_multi_paned_get_type ()")]
	public class MultiPaned : Gtk.Container, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public MultiPaned ();
		public uint get_n_children ();
		public unowned Gtk.Widget get_nth_child (uint nth);
		[NoAccessorMethod]
		public Gtk.Orientation orientation { get; set; }
		public virtual signal void resize_drag_begin (Gtk.Widget child);
		public virtual signal void resize_drag_end (Gtk.Widget child);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_path_get_type ()")]
	public class Path : GLib.Object {
		[CCode (has_construct_function = false)]
		public Path ();
		public void append (Dazzle.PathElement element);
		public unowned Dazzle.PathElement? get_element (uint index);
		public unowned GLib.List<Dazzle.PathElement> get_elements ();
		public uint get_length ();
		public bool has_prefix (Dazzle.Path prefix);
		public bool is_empty ();
		public void prepend (Dazzle.PathElement element);
		public string printf ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_path_bar_get_type ()")]
	public class PathBar : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PathBar ();
		public unowned Dazzle.Path get_path ();
		public void set_path (Dazzle.Path path);
		public void set_selected_index (uint index);
		public Dazzle.Path path { get; set; }
		public signal void element_selected (Dazzle.Path object, Dazzle.PathElement p0);
		public signal void populate_menu (Dazzle.Path object, Dazzle.PathElement p0, GLib.Menu p1);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_path_element_get_type ()")]
	public class PathElement : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.26")]
		public PathElement (string? id, string? icon_name, string title);
		[Version (since = "3.26")]
		public unowned string? get_icon_name ();
		[Version (since = "3.26")]
		public unowned string get_id ();
		[Version (since = "3.26")]
		public unowned string? get_title ();
		[Version (since = "3.26")]
		public string icon_name { get; construct; }
		[Version (since = "3.26")]
		public string id { get; construct; }
		[Version (since = "3.26")]
		public string title { get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", ref_function = "dzl_pattern_spec_ref", type_id = "dzl_pattern_spec_get_type ()", unref_function = "dzl_pattern_spec_unref")]
	[Compact]
	public class PatternSpec {
		[CCode (has_construct_function = false)]
		public PatternSpec (string keywords);
		public unowned string get_text ();
		public bool match (string haystack);
		public Dazzle.PatternSpec @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_pill_box_get_type ()")]
	public class PillBox : Gtk.EventBox, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PillBox (string label);
		public unowned string get_label ();
		public void set_label (string label);
		public string label { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_bin_get_type ()")]
	public class PreferencesBin : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesBin ();
		[NoWrapper]
		public virtual void connect (GLib.Settings settings);
		[NoWrapper]
		public virtual void disconnect (GLib.Settings settings);
		[NoWrapper]
		public virtual bool matches (Dazzle.PatternSpec spec);
		[NoAccessorMethod]
		public string keywords { owned get; construct; }
		[NoAccessorMethod]
		public string path { owned get; construct; }
		[NoAccessorMethod]
		public int priority { get; construct; }
		[NoAccessorMethod]
		public string schema_id { owned get; construct; }
		public signal void preference_activated ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_entry_get_type ()")]
	public class PreferencesEntry : Dazzle.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesEntry ();
		public unowned Gtk.Widget get_entry_widget ();
		public unowned Gtk.Widget get_title_widget ();
		[NoAccessorMethod]
		public string text { owned get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		public signal void activate ();
		public signal void changed (string object);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_file_chooser_button_get_type ()")]
	public class PreferencesFileChooserButton : Dazzle.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesFileChooserButton ();
		[NoAccessorMethod]
		public Gtk.FileChooserAction action { get; construct; }
		[NoAccessorMethod]
		public string key { owned get; construct; }
		[NoAccessorMethod]
		public string subtitle { owned get; construct; }
		[NoAccessorMethod]
		public string title { owned get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_flow_box_get_type ()")]
	public class PreferencesFlowBox : Dazzle.ColumnLayout, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PreferencesFlowBox ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_font_button_get_type ()")]
	public class PreferencesFontButton : Dazzle.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesFontButton ();
		[NoAccessorMethod]
		public string key { owned get; construct; }
		[NoAccessorMethod]
		public string title { owned get; construct; }
		public signal void activate ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_group_get_type ()")]
	public class PreferencesGroup : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesGroup ();
		public void add (Gtk.Widget widget);
		public int get_priority ();
		public unowned string get_title ();
		public uint refilter (Dazzle.PatternSpec spec);
		public void set_map (GLib.HashTable<void*,void*> map);
		[NoAccessorMethod]
		public bool is_list { get; construct; }
		[NoAccessorMethod]
		public Gtk.SelectionMode mode { get; set; }
		public int priority { get; construct; }
		public string title { get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_page_get_type ()")]
	public class PreferencesPage : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesPage ();
		public void add_group (Dazzle.PreferencesGroup group);
		public unowned Dazzle.PreferencesGroup? get_group (string group_name);
		public void refilter (Dazzle.PatternSpec spec);
		public void set_map (GLib.HashTable<void*,void*> map);
		[NoAccessorMethod]
		public int priority { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_spin_button_get_type ()")]
	public class PreferencesSpinButton : Dazzle.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesSpinButton ();
		public unowned Gtk.Widget get_spin_button ();
		[NoAccessorMethod]
		public string key { owned get; construct; }
		[NoAccessorMethod]
		public string subtitle { owned get; construct; }
		[NoAccessorMethod]
		public string title { owned get; construct; }
		public signal void activate ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_switch_get_type ()")]
	public class PreferencesSwitch : Dazzle.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesSwitch ();
		[NoAccessorMethod]
		public bool is_radio { get; construct; }
		[NoAccessorMethod]
		public string key { owned get; construct; }
		[NoAccessorMethod]
		public string subtitle { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant target { owned get; construct; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		public signal void activated ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_preferences_view_get_type ()")]
	public class PreferencesView : Gtk.Bin, Atk.Implementor, Dazzle.Preferences, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PreferencesView ();
		public void reapply_filter ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_priority_box_get_type ()")]
	public class PriorityBox : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PriorityBox ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_progress_button_get_type ()")]
	public class ProgressButton : Gtk.Button, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ProgressButton ();
		public uint get_progress ();
		public bool get_show_progress ();
		public void set_progress (uint percentage);
		public void set_show_progress (bool show_progress);
		public uint progress { get; set; }
		public bool show_progress { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_progress_icon_get_type ()")]
	public class ProgressIcon : Gtk.DrawingArea, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ProgressIcon ();
		public double get_progress ();
		public void set_progress (double progress);
		public double progress { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_progress_menu_button_get_type ()")]
	public class ProgressMenuButton : Gtk.MenuButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ProgressMenuButton ();
		public double get_progress ();
		public bool get_show_theatric ();
		public void reset_theatrics ();
		public void set_progress (double progress);
		public void set_show_theatric (bool show_theatic);
		public double progress { get; set; }
		public bool show_theatric { get; set; }
		[NoAccessorMethod]
		public string theatric_icon_name { owned get; set; }
		[NoAccessorMethod]
		public uint transition_duration { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_properties_group_get_type ()")]
	public class PropertiesGroup : GLib.Object, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		[Version (since = "3.26")]
		public PropertiesGroup (GLib.Object object);
		[Version (since = "3.26")]
		public void add_all_properties ();
		[Version (since = "3.26")]
		public void add_property (string name, string property_name);
		[Version (since = "3.26")]
		public void add_property_full (string name, string property_name, Dazzle.PropertiesFlags flags);
		[CCode (has_construct_function = false)]
		public PropertiesGroup.for_type (GLib.Type object_type);
		[Version (since = "3.26")]
		public void remove (string name);
		[NoAccessorMethod]
		public GLib.Object object { owned get; set; }
		[NoAccessorMethod]
		public GLib.Type object_type { get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_radio_box_get_type ()")]
	public class RadioBox : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public RadioBox ();
		public void add_item (string id, string text);
		public unowned string get_active_id ();
		public void set_active_id (string id);
		public string active_id { get; set; }
		[NoAccessorMethod]
		public bool has_more { get; }
		[NoAccessorMethod]
		public bool show_more { get; set; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "dazzle.h", ref_function = "dzl_ring_ref", type_id = "dzl_ring_get_type ()", unref_function = "dzl_ring_unref")]
	[Compact]
	public class Ring {
		public uint8 data;
		public uint len;
		public uint pos;
		public uint append_vals (void* data, uint len);
		public void @foreach (GLib.Func func);
		public Dazzle.Ring @ref ();
		[CCode (cname = "dzl_ring_sized_new", has_construct_function = false)]
		public Ring.sized_new (uint element_size, uint reserved_size, GLib.DestroyNotify element_destroy);
		public void unref ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_scrolled_window_get_type ()")]
	public class ScrolledWindow : Gtk.ScrolledWindow, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected ScrolledWindow ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_search_bar_get_type ()")]
	public class SearchBar : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SearchBar ();
		public unowned Gtk.SearchEntry get_entry ();
		public bool get_search_mode_enabled ();
		public bool get_show_close_button ();
		public void set_search_mode_enabled (bool search_mode_enabled);
		public void set_show_close_button (bool show_close_button);
		public bool search_mode_enabled { get; set; }
		public bool show_close_button { get; set; }
		public signal void activate ();
		public signal void reveal ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_settings_flag_action_get_type ()")]
	public class SettingsFlagAction : GLib.Object, GLib.Action {
		[CCode (has_construct_function = false)]
		protected SettingsFlagAction ();
		public static GLib.Action @new (string schema_id, string schema_key, string flag_nick);
		[NoAccessorMethod]
		public string flag_nick { owned get; construct; }
		[NoAccessorMethod]
		public string schema_id { owned get; construct; }
		[NoAccessorMethod]
		public string schema_key { owned get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_settings_sandwich_get_type ()")]
	public class SettingsSandwich : GLib.Object {
		[CCode (has_construct_function = false)]
		public SettingsSandwich (string schema_id, string path);
		public void append (GLib.Settings settings);
		public void bind (string key, void* object, string property, GLib.SettingsBindFlags flags);
		public void bind_with_mapping (string key, void* object, string property, GLib.SettingsBindFlags flags, [CCode (delegate_target_pos = 6.1, destroy_notify_pos = 6.2)] owned GLib.SettingsBindGetMapping get_mapping, owned GLib.SettingsBindSetMapping set_mapping);
		public bool get_boolean (string key);
		public GLib.Variant get_default_value (string key);
		public double get_double (string key);
		public int get_int (string key);
		public string get_string (string key);
		public uint get_uint (string key);
		public GLib.Variant get_user_value (string key);
		public GLib.Variant get_value (string key);
		public void set_boolean (string key, bool val);
		public void set_double (string key, double val);
		public void set_int (string key, int val);
		public void set_string (string key, string val);
		public void set_uint (string key, uint val);
		public void set_value (string key, GLib.Variant value);
		public void unbind (string property);
		[NoAccessorMethod]
		public string path { owned get; construct; }
		[NoAccessorMethod]
		public string schema_id { owned get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_accel_dialog_get_type ()")]
	public class ShortcutAccelDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ShortcutAccelDialog ();
		public string get_accelerator ();
		public unowned Dazzle.ShortcutChord get_chord ();
		public unowned string get_shortcut_title ();
		public void set_accelerator (string accelerator);
		public void set_shortcut_title (string title);
		public string accelerator { owned get; set; }
		public string shortcut_title { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "dzl_shortcut_chord_get_type ()")]
	[Compact]
	public class ShortcutChord {
		public bool append_event (Gdk.EventKey event);
		public Dazzle.ShortcutChord copy ();
		[CCode (cheader_filename = "dazzle.h")]
		public static bool equal (void* data1, void* data2);
		public void free ();
		[CCode (has_construct_function = false)]
		public ShortcutChord.from_event (Gdk.EventKey event);
		[CCode (has_construct_function = false)]
		public ShortcutChord.from_string (string accelerator);
		public string get_label ();
		public uint get_length ();
		public void get_nth_key (uint nth, uint keyval, Gdk.ModifierType modifier);
		public bool has_modifier ();
		[CCode (cheader_filename = "dazzle.h")]
		public static uint hash (void* data);
		public Dazzle.ShortcutMatch match (Dazzle.ShortcutChord other);
		public string to_string ();
	}
	[CCode (cheader_filename = "dazzle.h", has_type_id = false)]
	[Compact]
	public class ShortcutChordTable {
		public void add (Dazzle.ShortcutChord chord, void* data);
		public void @foreach (Dazzle.ShortcutChordTableForeach foreach_func);
		public void free ();
		[CCode (cheader_filename = "dazzle.h")]
		public static GLib.Type get_type ();
		public Dazzle.ShortcutMatch lookup (Dazzle.ShortcutChord chord, void* data);
		public unowned Dazzle.ShortcutChord lookup_data (void* data);
		public void printf ();
		public bool remove (Dazzle.ShortcutChord chord);
		public bool remove_data (void* data);
		public void set_free_func (GLib.DestroyNotify notify);
		public uint size ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_context_get_type ()")]
	public class ShortcutContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public ShortcutContext (string name);
		public Dazzle.ShortcutMatch activate (Gtk.Widget widget, Dazzle.ShortcutChord chord);
		public void add_action (string accel, string detailed_action_name);
		public void add_command (string accel, string command);
		public void add_signalv (string accel, string signal_name, owned GLib.Array<weak GLib.Value?>? values);
		public unowned string get_name ();
		public bool load_from_data (string data, ssize_t len) throws GLib.Error;
		public bool load_from_resource (string resource_path) throws GLib.Error;
		public bool remove (string accel);
		public string name { get; construct; }
		[NoAccessorMethod]
		public bool use_binding_sets { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_controller_get_type ()")]
	public class ShortcutController : GLib.Object {
		[CCode (has_construct_function = false)]
		public ShortcutController (Gtk.Widget widget);
		public void add_command_action (string command_id, string default_accel, Dazzle.ShortcutPhase phase, string action);
		public void add_command_callback (string command_id, string default_accel, Dazzle.ShortcutPhase phase, owned Gtk.Callback callback);
		public bool execute_command (string command);
		public static unowned Dazzle.ShortcutController find (Gtk.Widget widget);
		[Version (since = "3.26")]
		public unowned Dazzle.ShortcutContext? get_context ();
		[Version (since = "3.26")]
		public unowned Dazzle.ShortcutContext? get_context_for_phase (Dazzle.ShortcutPhase phase);
		public unowned Dazzle.ShortcutChord? get_current_chord ();
		public unowned Dazzle.ShortcutManager get_manager ();
		[Version (since = "3.26")]
		public void set_context_by_name (string? name);
		public void set_manager (Dazzle.ShortcutManager? manager);
		public static unowned Dazzle.ShortcutController? try_find (Gtk.Widget widget);
		public Dazzle.ShortcutContext context { get; }
		public Dazzle.ShortcutChord current_chord { get; }
		public Dazzle.ShortcutManager manager { get; set; }
		[NoAccessorMethod]
		public Gtk.Widget widget { owned get; construct; }
		public signal void reset ();
		public signal void set_context_named (string name);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_label_get_type ()")]
	public class ShortcutLabel : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ShortcutLabel ();
		public string get_accelerator ();
		public unowned Dazzle.ShortcutChord? get_chord ();
		public void set_accelerator (string accelerator);
		public void set_chord (Dazzle.ShortcutChord chord);
		public string accelerator { owned get; set; }
		public Dazzle.ShortcutChord chord { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_manager_get_type ()")]
	public class ShortcutManager : GLib.Object, GLib.Initable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected ShortcutManager ();
		public void add_action (string detailed_action_name, string section, string group, string title, string subtitle);
		public void add_command (string command, string section, string group, string title, string subtitle);
		public void add_shortcut_entries ([CCode (array_length_cname = "n_shortcuts", array_length_pos = 1.5, array_length_type = "guint")] Dazzle.ShortcutEntry[] shortcuts, string? translation_domain);
		public void add_shortcuts_to_window (Dazzle.ShortcutsWindow window);
		public void append_search_path (string directory);
		public static unowned Dazzle.ShortcutManager get_default ();
		public unowned Dazzle.ShortcutTheme get_theme ();
		public unowned Dazzle.ShortcutTheme? get_theme_by_name (string? theme_name);
		public unowned string get_theme_name ();
		public unowned string get_user_dir ();
		public bool handle_event (Gdk.EventKey event, Gtk.Widget toplevel);
		public void prepend_search_path (string directory);
		public void queue_reload ();
		public void reload (GLib.Cancellable? cancellable = null);
		public void remove_search_path (string directory);
		public void set_theme (Dazzle.ShortcutTheme theme);
		public void set_theme_name (string theme_name);
		public void set_user_dir (string user_dir);
		public Dazzle.ShortcutTheme theme { get; set; }
		public string theme_name { get; set; }
		public string user_dir { get; set; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_model_get_type ()")]
	public class ShortcutModel : Gtk.TreeStore, Gtk.Buildable, Gtk.TreeDragDest, Gtk.TreeDragSource, Gtk.TreeModel, Gtk.TreeSortable {
		[CCode (has_construct_function = false)]
		protected ShortcutModel ();
		public unowned Dazzle.ShortcutManager get_manager ();
		public unowned Dazzle.ShortcutTheme get_theme ();
		public static Gtk.TreeModel @new ();
		public void rebuild ();
		public void set_chord (Gtk.TreeIter iter, Dazzle.ShortcutChord chord);
		public void set_manager (Dazzle.ShortcutManager manager);
		public void set_theme (Dazzle.ShortcutTheme theme);
		public Dazzle.ShortcutManager manager { get; set; }
		public Dazzle.ShortcutTheme theme { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_simple_label_get_type ()")]
	public class ShortcutSimpleLabel : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ShortcutSimpleLabel ();
		public unowned string get_accel ();
		public unowned string get_action ();
		public unowned string get_command ();
		public unowned string get_title ();
		public void set_accel (string accel);
		public void set_action (string action);
		public void set_command (string command);
		public void set_title (string title);
		public string accel { get; set; }
		public string action { get; set; }
		public string command { get; set; }
		[NoAccessorMethod]
		public bool show_accel { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_theme_get_type ()")]
	public class ShortcutTheme : GLib.Object {
		[CCode (has_construct_function = false)]
		public ShortcutTheme (string name);
		public void add_command (string accelerator, string command);
		public void add_context (Dazzle.ShortcutContext context);
		public void add_css_resource (string path);
		public unowned Dazzle.ShortcutContext find_context_by_name (string name);
		public unowned Dazzle.ShortcutContext? find_default_context (Gtk.Widget widget);
		public unowned Dazzle.ShortcutChord get_chord_for_action (string detailed_action_name);
		public unowned Dazzle.ShortcutChord get_chord_for_command (string command);
		public unowned string get_name ();
		public unowned Dazzle.ShortcutTheme? get_parent ();
		public unowned string? get_parent_name ();
		public unowned string get_subtitle ();
		public unowned string get_title ();
		public bool load_from_data (string data, ssize_t len) throws GLib.Error;
		public bool load_from_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool load_from_path (string path, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void remove_css_resource (string path);
		public bool save_to_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool save_to_path (string path, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool save_to_stream (GLib.OutputStream stream, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_accel_for_action (string detailed_action_name, string accel, Dazzle.ShortcutPhase phase);
		public void set_accel_for_command (string? command, string? accel, Dazzle.ShortcutPhase phase);
		public void set_chord_for_action (string detailed_action_name, Dazzle.ShortcutChord chord, Dazzle.ShortcutPhase phase);
		public void set_chord_for_command (string? command, Dazzle.ShortcutChord? chord, Dazzle.ShortcutPhase phase);
		public void set_parent_name (string parent_name);
		public string name { get; construct; }
		public string parent_name { get; set; }
		[NoAccessorMethod]
		public string subtitle { owned get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcut_theme_editor_get_type ()")]
	public class ShortcutThemeEditor : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ShortcutThemeEditor ();
		public unowned Dazzle.ShortcutTheme? get_theme ();
		public void set_theme (Dazzle.ShortcutTheme theme);
		public Dazzle.ShortcutTheme theme { get; set; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcuts_group_get_type ()")]
	public class ShortcutsGroup : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected ShortcutsGroup ();
		[NoAccessorMethod]
		public Gtk.SizeGroup accel_size_group { set; }
		[NoAccessorMethod]
		public uint height { get; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		[NoAccessorMethod]
		public Gtk.SizeGroup title_size_group { set; }
		[NoAccessorMethod]
		public string view { owned get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcuts_section_get_type ()")]
	public class ShortcutsSection : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected ShortcutsSection ();
		[NoAccessorMethod]
		public uint max_height { get; set; }
		[NoAccessorMethod]
		public string section_name { owned get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		[NoAccessorMethod]
		public string view_name { owned get; set; }
		public signal bool change_current_page (int object);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcuts_shortcut_get_type ()")]
	public class ShortcutsShortcut : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected ShortcutsShortcut ();
		[NoAccessorMethod]
		public Gtk.SizeGroup accel_size_group { set; }
		[NoAccessorMethod]
		public string accelerator { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "3.22")]
		public string action_name { owned get; set; }
		[NoAccessorMethod]
		public Gtk.TextDirection direction { get; set; }
		[NoAccessorMethod]
		public GLib.Icon icon { owned get; set; }
		[NoAccessorMethod]
		public bool icon_set { get; set; }
		[NoAccessorMethod]
		public Gtk.ShortcutType shortcut_type { get; set; }
		[NoAccessorMethod]
		public string subtitle { owned get; set; }
		[NoAccessorMethod]
		public bool subtitle_set { get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		[NoAccessorMethod]
		public Gtk.SizeGroup title_size_group { set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_shortcuts_window_get_type ()")]
	public class ShortcutsWindow : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected ShortcutsWindow ();
		[NoAccessorMethod]
		public string section_name { owned get; set; }
		[NoAccessorMethod]
		public string view_name { owned get; set; }
		public virtual signal void close ();
		public virtual signal void search ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_signal_group_get_type ()")]
	public class SignalGroup : GLib.Object {
		[CCode (has_construct_function = false)]
		public SignalGroup (GLib.Type target_type);
		public void block ();
		public void connect_data (string detailed_signal, [CCode (delegate_target_pos = 2.33333, destroy_notify_pos = 2.66667)] owned GLib.Callback c_handler, GLib.ConnectFlags flags);
		public void connect_swapped (string detailed_signal, [CCode (scope = "async")] GLib.Callback c_handler);
		public unowned GLib.Object? get_target ();
		public void set_target (GLib.Object? target);
		public void unblock ();
		public GLib.Object target { get; set; }
		[NoAccessorMethod]
		public GLib.Type target_type { get; construct; }
		public signal void bind (GLib.Object instance);
		public signal void unbind ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_simple_label_get_type ()")]
	public class SimpleLabel : Gtk.Widget, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SimpleLabel (string label);
		public unowned string get_label ();
		public int get_width_chars ();
		public float get_xalign ();
		public void set_label (string label);
		public void set_width_chars (int width_chars);
		public void set_xalign (float xalign);
		public string label { get; set; }
		public int width_chars { get; set; }
		public float xalign { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_simple_popover_get_type ()")]
	public class SimplePopover : Gtk.Popover, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SimplePopover ();
		public unowned string get_button_text ();
		public unowned string get_message ();
		public bool get_ready ();
		public unowned string get_text ();
		public unowned string get_title ();
		public void set_button_text (string button_text);
		public void set_message (string message);
		public void set_ready (bool ready);
		public void set_text (string text);
		public void set_title (string title);
		public string button_text { get; set; }
		public string message { get; set; }
		public bool ready { get; set; }
		public string text { get; set; }
		public string title { get; set; }
		public virtual signal void activate (string text);
		public virtual signal void changed ();
		public virtual signal bool insert_text (uint position, string chars, uint n_chars);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_slider_get_type ()")]
	public class Slider : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Slider ();
		public void add_slider (Gtk.Widget widget, Dazzle.SliderPosition position);
		public Dazzle.SliderPosition get_position ();
		public void set_position (Dazzle.SliderPosition position);
		public Dazzle.SliderPosition position { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_stack_list_get_type ()")]
	public class StackList : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public StackList ();
		public void clear ();
		public uint get_depth ();
		public unowned GLib.ListModel get_model ();
		public void pop ();
		public GLib.ListModel model { get; }
		public virtual signal void header_activated (Gtk.ListBoxRow row);
		public virtual signal void row_activated (Gtk.ListBoxRow row);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_state_machine_get_type ()")]
	public class StateMachine : GLib.Object, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public StateMachine ();
		public void add_binding (string state, void* source_object, string source_property, void* target_object, string target_property, GLib.BindingFlags flags);
		public void add_propertyv (string state, void* object, string property, GLib.Value value);
		public void add_style (string state, Gtk.Widget widget, string style);
		public GLib.Action create_action (string name);
		public unowned string get_state ();
		public void set_state (string state);
		public string state { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_suggestion_get_type ()")]
	public class Suggestion : GLib.Object {
		[CCode (has_construct_function = false)]
		public Suggestion ();
		public unowned string get_icon_name ();
		public unowned string get_id ();
		public unowned string get_subtitle ();
		public unowned string get_title ();
		public void set_icon_name (string icon_name);
		public void set_id (string id);
		public void set_subtitle (string subtitle);
		public void set_title (string title);
		public string icon_name { get; set; }
		public string id { get; set; }
		public string subtitle { get; set; }
		public string title { get; set; }
		[HasEmitter]
		public virtual signal string replace_typed_text (string typed_text);
		[HasEmitter]
		public virtual signal string suggest_suffix (string typed_text);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_suggestion_entry_get_type ()")]
	public class SuggestionEntry : Gtk.Entry, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.Editable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SuggestionEntry ();
		public void default_position_func (Gdk.Rectangle area, bool is_absolute, void* user_data);
		public unowned GLib.ListModel? get_model ();
		public unowned Dazzle.Suggestion? get_suggestion ();
		public unowned string get_typed_text ();
		public void set_model (GLib.ListModel model);
		[Version (since = "3.26")]
		public void set_position_func (owned Dazzle.SuggestionPositionFunc? func);
		public void set_suggestion (Dazzle.Suggestion suggestion);
		public void window_position_func (Gdk.Rectangle area, bool is_absolute, void* user_data);
		public GLib.ListModel model { get; set; }
		public string typed_text { get; }
		public signal void activate_suggestion ();
		public virtual signal void hide_suggestions ();
		public virtual signal void move_suggestion (int amount);
		public virtual signal void show_suggestions ();
		public virtual signal void suggestion_activated (Dazzle.Suggestion suggestion);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_suggestion_entry_buffer_get_type ()")]
	public class SuggestionEntryBuffer : Gtk.EntryBuffer {
		[CCode (has_construct_function = false)]
		public SuggestionEntryBuffer ();
		public void commit ();
		public unowned Dazzle.Suggestion? get_suggestion ();
		public uint get_typed_length ();
		public unowned string get_typed_text ();
		public void set_suggestion (Dazzle.Suggestion? suggestion);
		public Dazzle.Suggestion suggestion { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_suggestion_popover_get_type ()")]
	public class SuggestionPopover : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SuggestionPopover ();
		public void activate_selected ();
		public unowned GLib.ListModel? get_model ();
		public unowned Gtk.Widget? get_relative_to ();
		public unowned Dazzle.Suggestion? get_selected ();
		public void move_by (int amount);
		public void popdown ();
		public void popup ();
		public void set_model (GLib.ListModel model);
		public void set_relative_to (Gtk.Widget widget);
		public void set_selected (Dazzle.Suggestion suggestion);
		public Dazzle.Suggestion model { get; set; }
		public Gtk.Widget relative_to { get; set; }
		public Dazzle.Suggestion selected { get; set; }
		public signal void suggestion_activated (Dazzle.Suggestion object);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_suggestion_row_get_type ()")]
	public class SuggestionRow : Dazzle.ListBoxRow, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SuggestionRow ();
		public unowned Dazzle.Suggestion get_suggestion ();
		public void set_suggestion (Dazzle.Suggestion suggestion);
		public Dazzle.Suggestion suggestion { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_tab_get_type ()")]
	public class Tab : Dazzle.Bin, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected Tab ();
		public bool get_active ();
		public bool get_can_close ();
		public Gtk.PositionType get_edge ();
		public unowned string get_icon_name ();
		public Dazzle.TabStyle get_style ();
		public unowned string get_title ();
		public unowned Gtk.Widget? get_widget ();
		public void set_active (bool active);
		public void set_can_close (bool can_close);
		public void set_edge (Gtk.PositionType edge);
		public void set_icon_name (string icon_name);
		public void set_style (Dazzle.TabStyle style);
		public void set_title (string title);
		public void set_widget (Gtk.Widget widget);
		public bool active { get; set; }
		public bool can_close { get; set; }
		public Gtk.PositionType edge { get; set; }
		public Dazzle.TabStyle style { get; set; }
		public string title { get; set; }
		public Gtk.Widget widget { get; set; }
		public signal void clicked ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_tab_strip_get_type ()")]
	public class TabStrip : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public TabStrip ();
		public void add_control (Gtk.Widget widget);
		public Gtk.PositionType get_edge ();
		public unowned Gtk.Stack? get_stack ();
		public Dazzle.TabStyle get_style ();
		public void set_edge (Gtk.PositionType edge);
		public void set_stack (Gtk.Stack stack);
		public void set_style (Dazzle.TabStyle style);
		public Gtk.PositionType edge { get; set; }
		public Gtk.Stack stack { get; set; }
		public Dazzle.TabStyle style { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_task_cache_get_type ()")]
	public class TaskCache : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TaskCache ();
		public bool evict (void* key);
		public void evict_all ();
		public async void* get_async (void* key, bool force_update, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.Object? peek (void* key);
		public void set_name (string name);
		public void* key_copy_func { construct; }
		public void* key_destroy_func { construct; }
		public void* key_equal_func { construct; }
		public void* key_hash_func { construct; }
		public void* populate_callback { construct; }
		public void* populate_callback_data { construct; }
		public void* populate_callback_data_destroy { construct; }
		public int64 time_to_live { construct; }
		public void* value_copy_func { construct; }
		public void* value_destroy_func { construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_theme_manager_get_type ()")]
	public class ThemeManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public ThemeManager ();
		public void add_resources (string resource_path);
		public void remove_resources (string resource_path);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_three_grid_get_type ()")]
	public class ThreeGrid : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ThreeGrid ();
		[NoAccessorMethod]
		public uint column_spacing { get; set; }
		[NoAccessorMethod]
		public uint row_spacing { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_tree_get_type ()")]
	public class Tree : Gtk.TreeView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected Tree ();
		public void add_builder (Dazzle.TreeBuilder builder);
		public void expand_to_node (Dazzle.TreeNode node);
		public unowned Dazzle.TreeNode? find_child_node (Dazzle.TreeNode node, Dazzle.TreeFindFunc find_func);
		public unowned Dazzle.TreeNode? find_custom (GLib.EqualFunc equal_func, void* key);
		public unowned Dazzle.TreeNode? find_item (GLib.Object? item);
		public unowned GLib.MenuModel? get_context_menu ();
		public unowned Dazzle.TreeNode? get_root ();
		public unowned Dazzle.TreeNode get_selected ();
		public bool get_show_icons ();
		public void rebuild ();
		public void remove_builder (Dazzle.TreeBuilder builder);
		public void scroll_to_node (Dazzle.TreeNode node);
		public void set_context_menu (GLib.MenuModel context_menu);
		public void set_filter (owned Dazzle.TreeFilterFunc filter_func);
		public void set_root (Dazzle.TreeNode node);
		public void set_show_icons (bool show_icons);
		public void unselect_all ();
		[NoAccessorMethod]
		public bool always_expand { get; construct; }
		public GLib.MenuModel context_menu { get; set; }
		public Dazzle.TreeNode root { get; set; }
		[NoAccessorMethod]
		public Dazzle.TreeNode selection { owned get; set; }
		public bool show_icons { get; set; }
		public virtual signal void action (string action_group, string action_name, string param);
		public virtual signal void populate_popup (Gtk.Widget widget);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_tree_builder_get_type ()")]
	public class TreeBuilder : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		protected TreeBuilder ();
		public unowned Dazzle.Tree? get_tree ();
		public Dazzle.Tree tree { get; }
		public virtual signal void added (Dazzle.Tree tree);
		public virtual signal void build_node (Dazzle.TreeNode node);
		public virtual signal bool node_activated (Dazzle.TreeNode node);
		public virtual signal void node_popup (Dazzle.TreeNode node, GLib.Menu menu);
		public virtual signal void node_selected (Dazzle.TreeNode node);
		public virtual signal void node_unselected (Dazzle.TreeNode node);
		public virtual signal void removed (Dazzle.Tree tree);
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_tree_node_get_type ()")]
	public class TreeNode : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public TreeNode ();
		public void add_emblem (string emblem_name);
		public void append (Dazzle.TreeNode child);
		public void clear_emblems ();
		public void collapse ();
		public bool expand (bool expand_ancestors);
		public void get_area (Gdk.Rectangle area);
		public bool get_children_possible ();
		public bool get_expanded ();
		public unowned GLib.Icon get_gicon ();
		public unowned string get_icon_name ();
		public unowned GLib.Object get_item ();
		public bool get_iter (Gtk.TreeIter iter);
		public unowned Dazzle.TreeNode get_parent ();
		public Gtk.TreePath? get_path ();
		public unowned string get_text ();
		public unowned Dazzle.Tree get_tree ();
		public bool get_use_dim_label ();
		public bool get_use_markup ();
		public bool has_emblem (string emblem_name);
		public void insert_sorted (Dazzle.TreeNode child, Dazzle.TreeNodeCompareFunc compare_func);
		public void invalidate ();
		public bool is_root ();
		public void prepend (Dazzle.TreeNode child);
		public void remove (Dazzle.TreeNode child);
		public void remove_emblem (string emblem_name);
		public void select ();
		public void set_children_possible (bool children_possible);
		public void set_emblems (string emblems);
		public void set_icon_name (string? icon_name);
		public void set_item (GLib.Object item);
		public void set_text (string? text);
		public void set_use_dim_label (bool use_dim_label);
		public void set_use_markup (bool use_markup);
		public void show_popover (Gtk.Popover popover);
		public bool children_possible { get; set; }
		[NoAccessorMethod]
		public string expanded_icon_name { owned get; set; }
		public GLib.Icon gicon { get; }
		public string icon_name { get; set; }
		public GLib.Object item { get; set; }
		public Dazzle.TreeNode parent { get; }
		public string text { get; set; }
		[NoAccessorMethod]
		public Dazzle.Tree tree { owned get; set; }
		public bool use_dim_label { get; set; }
		public bool use_markup { get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", ref_function = "dzl_trie_ref", type_id = "dzl_trie_get_type ()", unref_function = "dzl_trie_unref")]
	[Compact]
	public class Trie {
		[CCode (has_construct_function = false)]
		public Trie (GLib.DestroyNotify value_destroy);
		public void destroy ();
		public void insert (string key, void* value);
		public void* lookup (string key);
		public Dazzle.Trie @ref ();
		public bool remove (string key);
		public void traverse (string key, GLib.TraverseType order, GLib.TraverseFlags flags, int max_depth, Dazzle.TrieTraverseFunc func);
		public void unref ();
	}
	[CCode (cheader_filename = "dazzle.h", type_id = "dzl_widget_action_group_get_type ()")]
	public class WidgetActionGroup : GLib.Object, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		protected WidgetActionGroup ();
		public static void attach (Gtk.Widget widget, string group_name);
		public static GLib.ActionGroup @new (Gtk.Widget widget);
		public void set_action_enabled (string action_name, bool enabled);
		[NoAccessorMethod]
		public Gtk.Widget widget { owned get; construct; }
	}
	[CCode (cheader_filename = "dazzle.h", type_cname = "DzlDockInterface", type_id = "dzl_dock_get_type ()")]
	public interface Dock : Gtk.Container {
		[NoAccessorMethod]
		public abstract Dazzle.DockManager manager { owned get; set; }
	}
	[CCode (cheader_filename = "dazzle.h", type_cname = "DzlDockItemInterface", type_id = "dzl_dock_item_get_type ()")]
	public interface DockItem : Gtk.Widget {
		public bool adopt (Dazzle.DockItem child);
		public abstract bool close ();
		public abstract bool get_can_close ();
		[CCode (vfunc_name = "can_minimize")]
		public abstract bool get_can_minimize (Dazzle.DockItem descendant);
		public abstract bool get_child_visible (Dazzle.DockItem child);
		public abstract string? get_icon_name ();
		public abstract unowned Dazzle.DockManager? get_manager ();
		public unowned Dazzle.DockItem? get_parent ();
		public abstract string? get_title ();
		public bool has_widgets ();
		public abstract bool minimize (Dazzle.DockItem child, ref Gtk.PositionType position);
		public void present ();
		public abstract void present_child (Dazzle.DockItem child);
		public abstract void release (Dazzle.DockItem child);
		public abstract void set_child_visible (Dazzle.DockItem child, bool child_visible);
		public abstract void set_manager (Dazzle.DockManager? manager);
		public abstract void update_visibility ();
		public virtual signal void manager_set (Dazzle.DockManager old_manager);
	}
	[CCode (cheader_filename = "dazzle.h", lower_case_csuffix = "graph_view_renderer", type_cname = "DzlGraphRendererInterface", type_id = "dzl_graph_view_renderer_get_type ()")]
	public interface GraphRenderer : GLib.Object {
		public abstract void render (Dazzle.GraphModel table, int64 x_begin, int64 x_end, double y_begin, double y_end, Cairo.Context cr, Cairo.RectangleInt area);
	}
	[CCode (cheader_filename = "dazzle.h", type_cname = "DzlPreferencesInterface", type_id = "dzl_preferences_get_type ()")]
	public interface Preferences : GLib.Object {
		public abstract uint add_custom (string page_name, string group_name, Gtk.Widget widget, string? keywords, int priority);
		public abstract uint add_file_chooser (string page_name, string group_name, string schema_id, string key, string path, string title, string subtitle, Gtk.FileChooserAction action, string keywords, int priority);
		public abstract uint add_font_button (string page_name, string group_name, string schema_id, string key, string title, string keywords, int priority);
		public abstract void add_group (string page_name, string group_name, string title, int priority);
		public abstract void add_list_group (string page_name, string group_name, string title, Gtk.SelectionMode mode, int priority);
		public abstract void add_page (string page_name, string title, int priority);
		public abstract uint add_radio (string page_name, string group_name, string schema_id, string key, string? path, string? variant_string, string? title, string? subtitle, string? keywords, int priority);
		public abstract uint add_spin_button (string page_name, string group_name, string schema_id, string key, string path, string title, string subtitle, string keywords, int priority);
		public abstract uint add_switch (string page_name, string group_name, string schema_id, string key, string? path, string? variant_string, string? title, string? subtitle, string? keywords, int priority);
		public abstract unowned Gtk.Widget? get_widget (uint widget_id);
		public abstract bool remove_id (uint widget_id);
		public abstract void set_page (string page_name, GLib.HashTable<void*,void*> map);
	}
	[CCode (cheader_filename = "dazzle.h", has_type_id = false)]
	public struct Counter {
		public Dazzle.CounterValue values;
		public weak string category;
		public weak string name;
		public weak string description;
		public int64 @get ();
		public void reset ();
	}
	[CCode (cheader_filename = "dazzle.h", has_type_id = false)]
	public struct CounterValue {
		public int64 value;
		[CCode (array_length = false)]
		public weak int64 padding[7];
	}
	[CCode (cheader_filename = "dazzle.h", has_type_id = false)]
	public struct FuzzyMutableIndexMatch {
		public weak string key;
		public void* value;
		public float score;
		public uint id;
	}
	[CCode (cheader_filename = "dazzle.h", has_type_id = false)]
	public struct GraphModelIter {
		[CCode (array_length = false)]
		public weak void* data[8];
	}
	[CCode (cheader_filename = "dazzle.h", has_type_id = false)]
	public struct ShortcutEntry {
		public weak string command;
		public Dazzle.ShortcutPhase phase;
		public weak string default_accel;
		public weak string section;
		public weak string group;
		public weak string title;
		public weak string subtitle;
	}
	[CCode (cheader_filename = "dazzle.h", cname = "_DzlGraphColumnClass", has_type_id = false)]
	public struct _GraphColumnClass {
		public weak GLib.ObjectClass parent;
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_ANIMATION_", type_id = "dzl_animation_mode_get_type ()")]
	public enum AnimationMode {
		LINEAR,
		EASE_IN_QUAD,
		EASE_IN_OUT_QUAD,
		EASE_OUT_QUAD,
		EASE_IN_CUBIC,
		EASE_OUT_CUBIC,
		EASE_IN_OUT_CUBIC
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_DOCK_REVEALER_TRANSITION_TYPE_", type_id = "dzl_dock_revealer_transition_type_get_type ()")]
	public enum DockRevealerTransitionType {
		NONE,
		SLIDE_RIGHT,
		SLIDE_LEFT,
		SLIDE_UP,
		SLIDE_DOWN
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_PROPERTIES_FLAGS_", has_type_id = false)]
	[Flags]
	public enum PropertiesFlags {
		NONE,
		STATEFUL_BOOLEANS
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_SHORTCUT_MATCH_", type_id = "dzl_shortcut_match_get_type ()")]
	public enum ShortcutMatch {
		NONE,
		EQUAL,
		PARTIAL
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_SHORTCUT_PHASE_", type_id = "dzl_shortcut_phase_get_type ()")]
	[Flags]
	public enum ShortcutPhase {
		DISPATCH,
		CAPTURE,
		BUBBLE,
		GLOBAL
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_SHORTCUT_", has_type_id = false)]
	[Version (since = "3.20")]
	public enum ShortcutType {
		ACCELERATOR,
		GESTURE_PINCH,
		GESTURE_STRETCH,
		GESTURE_ROTATE_CLOCKWISE,
		GESTURE_ROTATE_COUNTERCLOCKWISE,
		GESTURE_TWO_FINGER_SWIPE_LEFT,
		GESTURE_TWO_FINGER_SWIPE_RIGHT,
		GESTURE
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_SLIDER_", type_id = "dzl_slider_position_get_type ()")]
	public enum SliderPosition {
		NONE,
		TOP,
		RIGHT,
		BOTTOM,
		LEFT
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_TAB_", type_id = "dzl_tab_style_get_type ()")]
	[Flags]
	public enum TabStyle {
		ICONS,
		TEXT,
		BOTH
	}
	[CCode (cheader_filename = "dazzle.h", cprefix = "DZL_THREE_GRID_COLUMN_", type_id = "dzl_three_grid_column_get_type ()")]
	public enum ThreeGridColumn {
		LEFT,
		CENTER,
		RIGHT
	}
	[CCode (cheader_filename = "dazzle.h", instance_pos = 1.9)]
	public delegate void CounterForeachFunc (Dazzle.Counter counter);
	[CCode (cheader_filename = "dazzle.h", instance_pos = 3.9)]
	public delegate bool DirectoryModelVisibleFunc (Dazzle.DirectoryModel self, GLib.File directory, GLib.FileInfo file_info);
	[CCode (cheader_filename = "dazzle.h", instance_pos = 2.9)]
	public delegate void ShortcutChordTableForeach (Dazzle.ShortcutChord chord, void* chord_data);
	[CCode (cheader_filename = "dazzle.h", instance_pos = 3.9)]
	[Version (since = "3.26")]
	public delegate void SuggestionPositionFunc (Dazzle.SuggestionEntry entry, ref Gdk.Rectangle area, ref bool is_absolute);
	[CCode (cheader_filename = "dazzle.h", instance_pos = 3.9)]
	public delegate void TaskCacheCallback (Dazzle.TaskCache self, void* key, GLib.Task task);
	[CCode (cheader_filename = "dazzle.h", instance_pos = 2.9)]
	public delegate bool TreeFilterFunc (Dazzle.Tree tree, Dazzle.TreeNode node);
	[CCode (cheader_filename = "dazzle.h", instance_pos = 3.9)]
	public delegate bool TreeFindFunc (Dazzle.Tree tree, Dazzle.TreeNode node, Dazzle.TreeNode child);
	[CCode (cheader_filename = "dazzle.h", instance_pos = 2.9)]
	public delegate int TreeNodeCompareFunc (Dazzle.TreeNode a, Dazzle.TreeNode b);
	[CCode (cheader_filename = "dazzle.h", instance_pos = 3.9)]
	public delegate bool TrieTraverseFunc (Dazzle.Trie dzl_trie, string key, void* value);
	[CCode (cheader_filename = "dazzle.h", cname = "DZL_COUNTER_REQUIRES_ATOMIC")]
	public const int COUNTER_REQUIRES_ATOMIC;
	[CCode (cheader_filename = "dazzle.h", cname = "DZL_DOCK_BIN_STYLE_CLASS_PINNED")]
	public const string DOCK_BIN_STYLE_CLASS_PINNED;
	[CCode (cheader_filename = "dazzle.h", cname = "DZL_ENABLE_TRACE")]
	public const int ENABLE_TRACE;
	[CCode (cheader_filename = "dazzle.h", cname = "DZL_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "dazzle.h", cname = "DZL_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "dazzle.h", cname = "DZL_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "dazzle.h", cname = "DZL_VERSION_S")]
	public const string VERSION_S;
	[CCode (cheader_filename = "dazzle.h")]
	public static Cairo.Region cairo_region_create_from_clip_extents (Cairo.Context cr);
	[CCode (cheader_filename = "dazzle.h")]
	public static void cairo_rounded_rectangle (Cairo.Context cr, Gdk.Rectangle rect, int x_radius, int y_radius);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "dazzle.h")]
	public static string[] dnd_get_uri_list (Gtk.SelectionData selection_data);
	[CCode (cheader_filename = "dazzle.h")]
	public static bool file_manager_show (GLib.File file) throws GLib.Error;
	[CCode (cheader_filename = "dazzle.h")]
	public static string fuzzy_highlight (string str, string query, bool case_sensitive);
	[CCode (cheader_filename = "dazzle.h")]
	public static string g_date_time_format_for_display (GLib.DateTime self);
	[CCode (cheader_filename = "dazzle.h")]
	public static string g_time_span_to_label (GLib.TimeSpan span);
	[CCode (cheader_filename = "dazzle.h")]
	public static bool g_time_span_to_label_mapping (GLib.Binding binding, GLib.Value from_value, GLib.Value to_value, void* user_data);
	[CCode (cheader_filename = "dazzle.h")]
	public static uint g_variant_hash (void* data);
	[CCode (cheader_filename = "dazzle.h")]
	public static uint get_current_cpu_call ();
	[CCode (cheader_filename = "dazzle.h")]
	[Version (since = "3.26")]
	public static void gtk_list_store_insert_sorted (Gtk.ListStore store, out Gtk.TreeIter iter, void* key, uint compare_column, GLib.CompareDataFunc compare_func);
	[CCode (cheader_filename = "dazzle.h")]
	public static void gtk_text_buffer_remove_tag (Gtk.TextBuffer buffer, Gtk.TextTag tag, Gtk.TextIter start, Gtk.TextIter end, bool minimal_damage);
	[CCode (cheader_filename = "dazzle.h")]
	public static bool gtk_widget_action (Gtk.Widget widget, string group, string name, GLib.Variant param);
	[CCode (cheader_filename = "dazzle.h")]
	public static bool gtk_widget_action_with_string (Gtk.Widget widget, string group, string name, string param);
	[CCode (cheader_filename = "dazzle.h")]
	public static void gtk_widget_add_style_class (Gtk.Widget widget, string class_name);
	[CCode (cheader_filename = "dazzle.h")]
	public static void* gtk_widget_find_child_typed (Gtk.Widget widget, GLib.Type type);
	[CCode (cheader_filename = "dazzle.h")]
	public static unowned Gtk.Widget? gtk_widget_get_relative (Gtk.Widget widget, GLib.Type relative_type);
	[CCode (cheader_filename = "dazzle.h")]
	public static void gtk_widget_hide_with_fade (Gtk.Widget widget);
	[CCode (cheader_filename = "dazzle.h")]
	[Version (since = "3.26")]
	public static bool gtk_widget_is_ancestor_or_relative (Gtk.Widget widget, Gtk.Widget ancestor);
	[CCode (cheader_filename = "dazzle.h")]
	public static void gtk_widget_mux_action_groups (Gtk.Widget widget, Gtk.Widget from_widget, string? mux_key);
	[CCode (cheader_filename = "dazzle.h")]
	public static void gtk_widget_remove_style_class (Gtk.Widget widget, string class_name);
	[CCode (cheader_filename = "dazzle.h")]
	public static void gtk_widget_show_with_fade (Gtk.Widget widget);
	[CCode (cheader_filename = "dazzle.h")]
	public static int levenshtein (string needle, string haystack);
	[CCode (cheader_filename = "dazzle.h")]
	public static void overlay_add_child (Dazzle.DockOverlay self, Gtk.Widget child, string type);
	[CCode (cheader_filename = "dazzle.h")]
	public static string pango_font_description_to_css (Pango.FontDescription font_desc);
	[CCode (cheader_filename = "dazzle.h")]
	public static void rgba_shade (Gdk.RGBA rgba, Gdk.RGBA dst, double k);
}
