/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.network.FileDescriptor;
import com.tigervnc.rdr.EndOfStream;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.FdInStreamBlockCallback;
import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.SystemException;
import com.tigervnc.rdr.TimedOut;

public class FdInStream
extends InStream {
    static final int DEFAULT_BUF_SIZE = 16384;
    static final int minBulkSize = 1024;
    private FileDescriptor fd;
    boolean closeWhenDone;
    protected int timeoutms;
    private FdInStreamBlockCallback blockCallback;
    private int offset;
    private int bufSize;
    protected boolean timing;
    protected long timeWaitedIn100us;
    protected long timedKbits;

    public FdInStream(FileDescriptor fileDescriptor, int n, int n2, boolean bl) {
        this.fd = fileDescriptor;
        this.closeWhenDone = bl;
        this.timeoutms = n;
        this.blockCallback = null;
        this.timing = false;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
        this.bufSize = n2 > 0 ? n2 : 16384;
        this.b = new byte[this.bufSize];
        this.offset = 0;
        this.end = 0;
        this.ptr = 0;
    }

    public FdInStream(FileDescriptor fileDescriptor) {
        this(fileDescriptor, -1, 0, false);
    }

    public FdInStream(FileDescriptor fileDescriptor, FdInStreamBlockCallback fdInStreamBlockCallback, int n) {
        this.fd = fileDescriptor;
        this.timeoutms = 0;
        this.blockCallback = fdInStreamBlockCallback;
        this.timing = false;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
        this.bufSize = n > 0 ? n : 16384;
        this.b = new byte[this.bufSize];
        this.offset = 0;
        this.end = 0;
        this.ptr = 0;
    }

    public FdInStream(FileDescriptor fileDescriptor, FdInStreamBlockCallback fdInStreamBlockCallback) {
        this(fileDescriptor, fdInStreamBlockCallback, 0);
    }

    @Override
    public final void readBytes(byte[] byArray, int n, int n2) {
        if (n2 < 1024) {
            super.readBytes(byArray, n, n2);
            return;
        }
        int n3 = this.end - this.ptr;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(this.b, this.ptr, byArray, n, n3);
        n += n3;
        n2 -= n3;
        this.ptr += n3;
        while (n2 > 0) {
            n3 = this.readWithTimeoutOrCallback(byArray, n, n2);
            n += n3;
            n2 -= n3;
            this.offset += n3;
        }
    }

    public void setTimeout(int n) {
        this.timeoutms = n;
    }

    public void setBlockCallback(FdInStreamBlockCallback fdInStreamBlockCallback) {
        this.blockCallback = fdInStreamBlockCallback;
        this.timeoutms = 0;
    }

    @Override
    public final int pos() {
        return this.offset + this.ptr;
    }

    public final void startTiming() {
        this.timing = true;
        if (this.timeWaitedIn100us > 10000L) {
            this.timedKbits = this.timedKbits * 10000L / this.timeWaitedIn100us;
            this.timeWaitedIn100us = 10000L;
        }
    }

    public final void stopTiming() {
        this.timing = false;
        if (this.timeWaitedIn100us < this.timedKbits / 2L) {
            this.timeWaitedIn100us = this.timedKbits / 2L;
        }
    }

    public final long kbitsPerSecond() {
        return this.timedKbits * 10000L / this.timeWaitedIn100us;
    }

    public final long timeWaited() {
        return this.timeWaitedIn100us;
    }

    @Override
    protected int overrun(int n, int n2, boolean bl) {
        if (n > this.bufSize) {
            throw new Exception("FdInStream overrun: max itemSize exceeded");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.offset += this.ptr;
        this.end -= this.ptr;
        this.ptr = 0;
        while (this.end < n) {
            int n3;
            int n4 = this.bufSize - this.end;
            if (!this.timing) {
                n4 = Math.min(n4, Math.max(n * n2, 8));
            }
            if ((n3 = this.readWithTimeoutOrCallback(this.b, this.end, n4, bl)) == 0) {
                return 0;
            }
            this.end += n3;
        }
        if (n * n2 > this.end - this.ptr) {
            n2 = (this.end - this.ptr) / n;
        }
        return n2;
    }

    protected int readWithTimeoutOrCallback(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        long l = 0L;
        if (this.timing) {
            l = System.nanoTime();
        }
        while (true) {
            Integer n4 = !bl ? new Integer(0) : (this.timeoutms != -1 ? new Integer(this.timeoutms) : null);
            try {
                n3 = this.fd.select(1, n4);
            }
            catch (Exception exception) {
                throw new SystemException("select:" + exception.toString());
            }
            if (n3 < 0) continue;
            if (n3 > 0) break;
            if (!bl) {
                return 0;
            }
            if (this.blockCallback == null) {
                throw new TimedOut();
            }
            this.blockCallback.blockCallback();
        }
        try {
            n3 = this.fd.read(byArray, n, n2);
        }
        catch (Exception exception) {
            throw new SystemException("read:" + exception.toString());
        }
        if (n3 == 0) {
            throw new EndOfStream();
        }
        if (this.timing) {
            int n5;
            long l2 = System.nanoTime();
            long l3 = (l2 - l) / 100000L;
            if (l3 > (long)((n5 = n3 * 8 / 1000) * 1000)) {
                l3 = n5 * 1000;
            } else if (l3 < (long)(n5 / 4)) {
                l3 = n5 / 4;
            }
            this.timeWaitedIn100us += l3;
            this.timedKbits += (long)n5;
        }
        return n3;
    }

    private int readWithTimeoutOrCallback(byte[] byArray, int n, int n2) {
        return this.readWithTimeoutOrCallback(byArray, n, n2, true);
    }

    public FileDescriptor getFd() {
        return this.fd;
    }

    public void setFd(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    public int getBufSize() {
        return this.bufSize;
    }
}

