/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.ClipboardDialog;
import com.tigervnc.vncviewer.Dialog;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.MenuKey;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;

public class F8Menu
extends JPopupMenu
implements ActionListener {
    CConn cc;
    JMenuItem restore;
    JMenuItem move;
    JMenuItem size;
    JMenuItem minimize;
    JMenuItem maximize;
    JMenuItem exit;
    JMenuItem clipboard;
    JMenuItem ctrlAltDel;
    JMenuItem refresh;
    JMenuItem newConn;
    JMenuItem options;
    JMenuItem save;
    JMenuItem info;
    JMenuItem about;
    JMenuItem dismiss;
    static JMenuItem f8;
    JCheckBoxMenuItem fullScreenCheckbox;
    static LogWriter vlog;

    public F8Menu(CConn cConn) {
        super("VNC Menu");
        this.setLightWeightPopupEnabled(false);
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            WindowsLookAndFeel.setMnemonicHidden((boolean)false);
        }
        this.cc = cConn;
        this.restore = this.addMenuItem("Restore", 82);
        this.restore.setEnabled(!Parameters.embed.getValue());
        this.move = this.addMenuItem("Move");
        this.move.setEnabled(false);
        this.size = this.addMenuItem("Size");
        this.size.setEnabled(false);
        this.minimize = this.addMenuItem("Minimize", 78);
        this.minimize.setEnabled(!Parameters.embed.getValue());
        this.maximize = this.addMenuItem("Maximize", 88);
        this.maximize.setEnabled(!Parameters.embed.getValue());
        this.addSeparator();
        this.exit = this.addMenuItem("Close Viewer", 67);
        this.addSeparator();
        this.fullScreenCheckbox = new JCheckBoxMenuItem("Full Screen");
        this.fullScreenCheckbox.setMnemonic(70);
        this.fullScreenCheckbox.setSelected(Parameters.fullScreen.getValue());
        this.fullScreenCheckbox.addActionListener(this);
        this.fullScreenCheckbox.setEnabled(!Parameters.embed.getValue());
        this.add(this.fullScreenCheckbox);
        this.addSeparator();
        this.clipboard = this.addMenuItem("Clipboard...");
        this.addSeparator();
        int n = MenuKey.getMenuKeyCode();
        String string2 = KeyEvent.getKeyText(n);
        f8 = this.addMenuItem("Send " + string2, n);
        this.ctrlAltDel = this.addMenuItem("Send Ctrl-Alt-Del");
        this.addSeparator();
        this.refresh = this.addMenuItem("Refresh Screen", 72);
        this.addSeparator();
        this.newConn = this.addMenuItem("New connection...", 87);
        this.newConn.setEnabled(!Parameters.embed.getValue());
        this.options = this.addMenuItem("Options...", 79);
        this.save = this.addMenuItem("Save connection info as...", 83);
        this.info = this.addMenuItem("Connection info...", 73);
        this.about = this.addMenuItem("About VncViewer...", 65);
        this.addSeparator();
        this.dismiss = this.addMenuItem("Dismiss menu");
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    JMenuItem addMenuItem(String string, int n) {
        JMenuItem jMenuItem = new JMenuItem(string, n);
        jMenuItem.addActionListener(this);
        this.add(jMenuItem);
        return jMenuItem;
    }

    JMenuItem addMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        this.add(jMenuItem);
        return jMenuItem;
    }

    boolean actionMatch(ActionEvent actionEvent, JMenuItem jMenuItem) {
        return actionEvent.getActionCommand().equals(jMenuItem.getActionCommand());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.actionMatch(actionEvent, this.exit)) {
            this.cc.close();
        } else if (this.actionMatch(actionEvent, this.fullScreenCheckbox)) {
            if (this.fullScreenCheckbox.isSelected()) {
                this.cc.desktop.fullscreen_on();
            } else {
                this.cc.desktop.fullscreen_off();
            }
        } else if (this.actionMatch(actionEvent, this.restore)) {
            if (this.cc.desktop.fullscreen_active()) {
                this.cc.desktop.fullscreen_off();
            }
            this.cc.desktop.setExtendedState(0);
        } else if (this.actionMatch(actionEvent, this.minimize)) {
            if (this.cc.desktop.fullscreen_active()) {
                this.cc.desktop.fullscreen_off();
            }
            this.cc.desktop.setExtendedState(1);
        } else if (this.actionMatch(actionEvent, this.maximize)) {
            if (this.cc.desktop.fullscreen_active()) {
                this.cc.desktop.fullscreen_off();
            }
            this.cc.desktop.setExtendedState(6);
        } else if (this.actionMatch(actionEvent, this.clipboard)) {
            ClipboardDialog.showDialog(this.cc.desktop);
        } else if (this.actionMatch(actionEvent, f8)) {
            this.cc.writeKeyEvent(MenuKey.getMenuKeySym(), true);
            this.cc.writeKeyEvent(MenuKey.getMenuKeySym(), false);
        } else if (this.actionMatch(actionEvent, this.ctrlAltDel)) {
            this.cc.writeKeyEvent(65507, true);
            this.cc.writeKeyEvent(65513, true);
            this.cc.writeKeyEvent(65535, true);
            this.cc.writeKeyEvent(65535, false);
            this.cc.writeKeyEvent(65513, false);
            this.cc.writeKeyEvent(65507, false);
        } else if (this.actionMatch(actionEvent, this.refresh)) {
            this.cc.refresh();
        } else if (this.actionMatch(actionEvent, this.newConn)) {
            VncViewer.newViewer();
        } else if (this.actionMatch(actionEvent, this.options)) {
            OptionsDialog.showDialog(this.cc.desktop);
        } else if (this.actionMatch(actionEvent, this.save)) {
            String string = "Save the TigerVNC configuration to file";
            File file = new File(FileUtils.getVncHomeDir().concat("default.tigervnc"));
            if (!file.exists() || !file.isFile()) {
                file = new File(FileUtils.getVncHomeDir());
            }
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("TigerVNC configuration (*.tigervnc)", "tigervnc");
            File file2 = Dialog.showChooser(string, file, this, fileNameExtensionFilter);
            while (file2 != null && file2.exists() && file2.isFile()) {
                String string2 = file2.getAbsolutePath();
                string2 = string2.concat(" already exists. Do you want to overwrite?");
                Object[] objectArray = new Object[]{"Overwrite", "No  \u21b5"};
                JOptionPane jOptionPane = new JOptionPane(string2, 3, 2, null, objectArray, objectArray[1]);
                JDialog jDialog = jOptionPane.createDialog(this, "TigerVNC Viewer");
                jDialog.setIconImage(VncViewer.frameIcon);
                jDialog.setAlwaysOnTop(true);
                jDialog.setVisible(true);
                if (jOptionPane.getValue() == objectArray[0]) break;
                file2 = Dialog.showChooser(string, file2, this, fileNameExtensionFilter);
            }
            if (file2 != null && (!file2.exists() || file2.canWrite())) {
                Parameters.saveViewerParameters(file2.getAbsolutePath(), Parameters.vncServerName.getValue());
            }
        } else if (this.actionMatch(actionEvent, this.info)) {
            this.cc.showInfo();
        } else if (this.actionMatch(actionEvent, this.about)) {
            VncViewer.showAbout(this.cc.desktop);
        } else if (this.actionMatch(actionEvent, this.dismiss)) {
            this.firePopupMenuCanceled();
        }
    }

    @Override
    public void show(Component component, int n, int n2) {
        super.show(component, n, n2);
    }

    static {
        vlog = new LogWriter("F8Menu");
    }
}

