/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.mbox;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class MboxOutputStream
extends FilterOutputStream {
    private static byte KET = (byte)62;
    protected byte[] buf;
    protected int count = 0;

    public MboxOutputStream(OutputStream out) {
        this(out, 4096);
    }

    public MboxOutputStream(OutputStream out, int len) {
        super(out);
        this.buf = new byte[len];
    }

    protected void validateAndFlushBuffer() throws IOException {
        if (this.count > 0) {
            boolean done = false;
            for (int i = 0; i < this.count - 5 && !done; ++i) {
                if (this.buf[i] == 70 && this.buf[i + 1] == 114 && this.buf[i + 2] == 111 && this.buf[i + 3] == 109 && this.buf[i + 4] == 32) {
                    byte[] b2 = new byte[this.buf.length + 1];
                    System.arraycopy(this.buf, 0, b2, 0, this.buf.length);
                    b2[i] = KET;
                    System.arraycopy(this.buf, i, b2, i + 1, this.buf.length - i);
                    this.buf = b2;
                    ++this.count;
                    done = true;
                    continue;
                }
                if (this.buf[i] == KET || this.buf[i] == 10) continue;
                done = true;
            }
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (b == 13) {
            return;
        }
        if (this.count > this.buf.length) {
            this.validateAndFlushBuffer();
        }
        this.buf[this.count++] = (byte)b;
        if (b == 10) {
            this.validateAndFlushBuffer();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int i;
        for (i = off; i < off + len; ++i) {
            if (b[i] != 13) continue;
            byte[] b2 = new byte[b.length - 1];
            System.arraycopy(b, off, b2, off, len - 1);
            System.arraycopy(b, i + 1, b2, i, len - (i - off) - 1);
            b = b2;
            --len;
            --i;
        }
        for (i = off; i < off + len; ++i) {
            if (b[i] != 10 && i - off <= this.buf.length) continue;
            int cl = i - off > this.buf.length ? this.buf.length : i - off;
            System.arraycopy(b, off, this.buf, this.count, cl);
            this.count += cl;
            this.validateAndFlushBuffer();
            byte[] b2 = new byte[b.length];
            System.arraycopy(b, i, b2, off, len -= i - off);
            b = b2;
            i = off;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.validateAndFlushBuffer();
        this.out.flush();
    }
}

