/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class List
extends Component
implements ItemSelectable,
Accessible {
    Vector items = new Vector();
    int rows = 0;
    boolean multipleMode = false;
    int[] selected = new int[0];
    int visibleIndex = -1;
    transient ActionListener actionListener;
    transient ItemListener itemListener;
    private static final String base = "list";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -3304312411574666869L;
    static final int DEFAULT_VISIBLE_ROWS = 4;
    private int listSerializedDataVersion = 1;

    public List() throws HeadlessException {
        this(0, false);
    }

    public List(int rows) throws HeadlessException {
        this(rows, false);
    }

    public List(int rows, boolean multipleMode) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.rows = rows != 0 ? rows : 4;
        this.multipleMode = multipleMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<List> clazz = List.class;
        synchronized (List.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createList(this);
            }
            super.addNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer peer = (ListPeer)this.peer;
            if (peer != null) {
                this.selected = peer.getSelectedIndexes();
            }
            super.removeNotify();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    @Deprecated
    public int countItems() {
        return this.items.size();
    }

    public String getItem(int index) {
        return this.getItemImpl(index);
    }

    final String getItemImpl(int index) {
        return (String)this.items.elementAt(index);
    }

    public synchronized String[] getItems() {
        Object[] itemCopies = new String[this.items.size()];
        this.items.copyInto(itemCopies);
        return itemCopies;
    }

    public void add(String item) {
        this.addItem(item);
    }

    @Deprecated
    public void addItem(String item) {
        this.addItem(item, -1);
    }

    public void add(String item, int index) {
        this.addItem(item, index);
    }

    @Deprecated
    public synchronized void addItem(String item, int index) {
        if (index < -1 || index >= this.items.size()) {
            index = -1;
        }
        if (item == null) {
            item = "";
        }
        if (index == -1) {
            this.items.addElement(item);
        } else {
            this.items.insertElementAt(item, index);
        }
        ListPeer peer = (ListPeer)this.peer;
        if (peer != null) {
            peer.add(item, index);
        }
    }

    public synchronized void replaceItem(String newValue, int index) {
        this.remove(index);
        this.add(newValue, index);
    }

    public void removeAll() {
        this.clear();
    }

    @Deprecated
    public synchronized void clear() {
        ListPeer peer = (ListPeer)this.peer;
        if (peer != null) {
            peer.removeAll();
        }
        this.items = new Vector();
        this.selected = new int[0];
    }

    public synchronized void remove(String item) {
        int index = this.items.indexOf(item);
        if (index < 0) {
            throw new IllegalArgumentException("item " + item + " not found in list");
        }
        this.remove(index);
    }

    public void remove(int position) {
        this.delItem(position);
    }

    @Deprecated
    public void delItem(int position) {
        this.delItems(position, position);
    }

    public synchronized int getSelectedIndex() {
        int[] sel = this.getSelectedIndexes();
        return sel.length == 1 ? sel[0] : -1;
    }

    public synchronized int[] getSelectedIndexes() {
        ListPeer peer = (ListPeer)this.peer;
        if (peer != null) {
            this.selected = peer.getSelectedIndexes();
        }
        return (int[])this.selected.clone();
    }

    public synchronized String getSelectedItem() {
        int index = this.getSelectedIndex();
        return index < 0 ? null : this.getItem(index);
    }

    public synchronized String[] getSelectedItems() {
        int[] sel = this.getSelectedIndexes();
        String[] str = new String[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            str[i] = this.getItem(sel[i]);
        }
        return str;
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(int index) {
        ListPeer peer;
        do {
            if ((peer = (ListPeer)this.peer) != null) {
                peer.select(index);
                return;
            }
            List list = this;
            synchronized (list) {
                boolean alreadySelected = false;
                for (int i = 0; i < this.selected.length; ++i) {
                    if (this.selected[i] != index) continue;
                    alreadySelected = true;
                    break;
                }
                if (!alreadySelected) {
                    if (!this.multipleMode) {
                        this.selected = new int[1];
                        this.selected[0] = index;
                    } else {
                        int[] newsel = new int[this.selected.length + 1];
                        System.arraycopy(this.selected, 0, newsel, 0, this.selected.length);
                        newsel[this.selected.length] = index;
                        this.selected = newsel;
                    }
                }
            }
        } while (peer != this.peer);
    }

    public synchronized void deselect(int index) {
        ListPeer peer = (ListPeer)this.peer;
        if (peer != null && (this.isMultipleMode() || this.getSelectedIndex() == index)) {
            peer.deselect(index);
        }
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i] != index) continue;
            int[] newsel = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, newsel, 0, i);
            System.arraycopy(this.selected, i + 1, newsel, i, this.selected.length - (i + 1));
            this.selected = newsel;
            return;
        }
    }

    public boolean isIndexSelected(int index) {
        return this.isSelected(index);
    }

    @Deprecated
    public boolean isSelected(int index) {
        int[] sel = this.getSelectedIndexes();
        for (int i = 0; i < sel.length; ++i) {
            if (sel[i] != index) continue;
            return true;
        }
        return false;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    @Deprecated
    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean b) {
        this.setMultipleSelections(b);
    }

    @Deprecated
    public synchronized void setMultipleSelections(boolean b) {
        if (b != this.multipleMode) {
            this.multipleMode = b;
            ListPeer peer = (ListPeer)this.peer;
            if (peer != null) {
                peer.setMultipleMode(b);
            }
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void makeVisible(int index) {
        this.visibleIndex = index;
        ListPeer peer = (ListPeer)this.peer;
        if (peer != null) {
            peer.makeVisible(index);
        }
    }

    public Dimension getPreferredSize(int rows) {
        return this.preferredSize(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension preferredSize(int rows) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer peer = (ListPeer)this.peer;
            return peer != null ? peer.getPreferredSize(rows) : super.preferredSize();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 ? this.preferredSize(this.rows) : super.preferredSize();
        }
    }

    public Dimension getMinimumSize(int rows) {
        return this.minimumSize(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension minimumSize(int rows) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer peer = (ListPeer)this.peer;
            return peer != null ? peer.getMinimumSize(rows) : super.minimumSize();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 ? this.minimumSize(this.rows) : super.minimumSize();
        }
    }

    @Override
    public synchronized void addItemListener(ItemListener l) {
        if (l == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
        this.newEventsOnly = true;
    }

    @Override
    public synchronized void removeItemListener(ItemListener l) {
        if (l == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    public synchronized void addActionListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener l = null;
        if (listenerType == ActionListener.class) {
            l = this.actionListener;
        } else if (listenerType == ItemListener.class) {
            l = this.itemListener;
        } else {
            return super.getListeners(listenerType);
        }
        return AWTEventMulticaster.getListeners((EventListener)l, listenerType);
    }

    @Override
    boolean eventEnabled(AWTEvent e) {
        switch (e.id) {
            case 1001: {
                return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
            }
            case 701: {
                return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
            }
        }
        return super.eventEnabled(e);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processItemEvent(ItemEvent e) {
        ItemListener listener = this.itemListener;
        if (listener != null) {
            listener.itemStateChanged(e);
        }
    }

    protected void processActionEvent(ActionEvent e) {
        ActionListener listener = this.actionListener;
        if (listener != null) {
            listener.actionPerformed(e);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",selected=" + this.getSelectedItem();
    }

    @Deprecated
    public synchronized void delItems(int start, int end) {
        for (int i = end; i >= start; --i) {
            this.items.removeElementAt(i);
        }
        ListPeer peer = (ListPeer)this.peer;
        if (peer != null) {
            peer.delItems(start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        List list = this;
        synchronized (list) {
            ListPeer peer = (ListPeer)this.peer;
            if (peer != null) {
                this.selected = peer.getSelectedIndexes();
            }
        }
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "itemL", this.itemListener);
        AWTEventMulticaster.save(s, "actionL", this.actionListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        Object keyOrNull;
        GraphicsEnvironment.checkHeadless();
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTList();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTList
    extends Component.AccessibleAWTComponent
    implements AccessibleSelection,
    ItemListener,
    ActionListener {
        private static final long serialVersionUID = 7924617370136012829L;

        public AccessibleAWTList() {
            super(List.this);
            List.this.addActionListener(this);
            List.this.addItemListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (List.this.isMultipleMode()) {
                states.add(AccessibleState.MULTISELECTABLE);
            }
            return states;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return List.this.getItemCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Accessible getAccessibleChild(int i) {
            List list = List.this;
            synchronized (list) {
                if (i >= List.this.getItemCount()) {
                    return null;
                }
                return new AccessibleAWTListChild(List.this, i);
            }
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            return List.this.getSelectedIndexes().length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Accessible getAccessibleSelection(int i) {
            List list = List.this;
            synchronized (list) {
                int len = this.getAccessibleSelectionCount();
                if (i < 0 || i >= len) {
                    return null;
                }
                return this.getAccessibleChild(List.this.getSelectedIndexes()[i]);
            }
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            return List.this.isIndexSelected(i);
        }

        @Override
        public void addAccessibleSelection(int i) {
            List.this.select(i);
        }

        @Override
        public void removeAccessibleSelection(int i) {
            List.this.deselect(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAccessibleSelection() {
            List list = List.this;
            synchronized (list) {
                int[] selectedIndexes = List.this.getSelectedIndexes();
                if (selectedIndexes == null) {
                    return;
                }
                for (int i = selectedIndexes.length - 1; i >= 0; --i) {
                    List.this.deselect(selectedIndexes[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectAllAccessibleSelection() {
            List list = List.this;
            synchronized (list) {
                for (int i = List.this.getItemCount() - 1; i >= 0; --i) {
                    List.this.select(i);
                }
            }
        }

        protected class AccessibleAWTListChild
        extends Component.AccessibleAWTComponent
        implements Accessible {
            private static final long serialVersionUID = 4412022926028300317L;
            private List parent;
            private int indexInParent;

            public AccessibleAWTListChild(List parent, int indexInParent) {
                super(List.this);
                this.parent = parent;
                this.setAccessibleParent(parent);
                this.indexInParent = indexInParent;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet states = super.getAccessibleStateSet();
                if (this.parent.isIndexSelected(this.indexInParent)) {
                    states.add(AccessibleState.SELECTED);
                }
                return states;
            }

            @Override
            public Locale getLocale() {
                return this.parent.getLocale();
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            @Override
            public int getAccessibleChildrenCount() {
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                return null;
            }

            @Override
            public Color getBackground() {
                return this.parent.getBackground();
            }

            @Override
            public void setBackground(Color c) {
                this.parent.setBackground(c);
            }

            @Override
            public Color getForeground() {
                return this.parent.getForeground();
            }

            @Override
            public void setForeground(Color c) {
                this.parent.setForeground(c);
            }

            @Override
            public Cursor getCursor() {
                return this.parent.getCursor();
            }

            @Override
            public void setCursor(Cursor cursor) {
                this.parent.setCursor(cursor);
            }

            @Override
            public Font getFont() {
                return this.parent.getFont();
            }

            @Override
            public void setFont(Font f) {
                this.parent.setFont(f);
            }

            @Override
            public FontMetrics getFontMetrics(Font f) {
                return this.parent.getFontMetrics(f);
            }

            @Override
            public boolean isEnabled() {
                return this.parent.isEnabled();
            }

            @Override
            public void setEnabled(boolean b) {
                this.parent.setEnabled(b);
            }

            @Override
            public boolean isVisible() {
                return false;
            }

            @Override
            public void setVisible(boolean b) {
                this.parent.setVisible(b);
            }

            @Override
            public boolean isShowing() {
                return false;
            }

            @Override
            public boolean contains(Point p) {
                return false;
            }

            @Override
            public Point getLocationOnScreen() {
                return null;
            }

            @Override
            public Point getLocation() {
                return null;
            }

            @Override
            public void setLocation(Point p) {
            }

            @Override
            public Rectangle getBounds() {
                return null;
            }

            @Override
            public void setBounds(Rectangle r) {
            }

            @Override
            public Dimension getSize() {
                return null;
            }

            @Override
            public void setSize(Dimension d) {
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }

            @Override
            public void requestFocus() {
            }

            @Override
            public void addFocusListener(FocusListener l) {
            }

            @Override
            public void removeFocusListener(FocusListener l) {
            }
        }
    }
}

