package jdk.internal.jshell.tool.resources;

public final class l10n extends java.util.ListResourceBundle {
    protected final Object[][] getContents() {
        return new Object[][] {
            { "help.bang", "Reevaluate the most recently entered snippet." },
            { "help.bang.args", "" },
            { "help.bang.summary", "re-run last snippet" },
            { "help.context", "These options configure the evaluation context, they can be specified when\njshell is started: on the command-line, or restarted with the commands /env,\n/reload, or /reset.\n\nThey are:\n\t--class-path <class search path of directories and zip/jar files>\n\t\tA list of directories, JAR archives,\n\t\tand ZIP archives to search for class files.\n\t\tThe list is separated with the path separator\n\t\t(a : on unix/linux/mac, and ; on windows).\n\t--module-path <module path>...\n\t\tA list of directories, each directory\n\t\tis a directory of modules.\n\t\tThe list is separated with the path separator\n\t\t(a : on unix/linux/mac, and ; on windows).\n\t--add-modules <modulename>[,<modulename>...]\n\t\troot modules to resolve in addition to the initial module.\n\t\t<modulename> can also be ALL-DEFAULT, ALL-SYSTEM,\n\t\tALL-MODULE-PATH.\n\t--add-exports <module>/<package>=<target-module>(,<target-module>)*\n\t\tupdates <module> to export <package> to <target-module>,\n\t\tregardless of module declaration.\n\t\t<target-module> can be ALL-UNNAMED to export to all\n\t\tunnamed modules. In jshell, if the <target-module> is not\n\t\tspecified (no =) then ALL-UNNAMED is used.\n\nOn the command-line these options must have two dashes, e.g.: --module-path\nOn jshell commands they can have one or two dashes, e.g.: -module-path\n" },
            { "help.context.summary", "the evaluation context options for /env /reload and /reset" },
            { "help.debug", "Display debugging information for the jshell implementation.\n0: Debugging off\nr: Tool level debugging on\ng: General debugging on\nf: File manager debugging on\nc: Completion analysis debugging on\nd: Dependency debugging on\ne: Event debugging on" },
            { "help.debug.args", "[0][r][g][f][c][d][e]" },
            { "help.debug.summary", "toggle debugging of the jshell" },
            { "help.drop", "Drop a snippet -- making it inactive.\n\n/drop <name>\n\tDrop the snippet with the specified name\n\n/drop <id>\n\tDrop the snippet with the specified snippet id" },
            { "help.drop.args", "<name or id>" },
            { "help.drop.summary", "delete a source entry referenced by name or id" },
            { "help.edit", "Edit a snippet or snippets of source in an external editor.\nThe editor to use is set with /set editor.\nIf no editor has been set, a simple editor will be launched.\n\n/edit <name>\n\tEdit the snippet or snippets with the specified name (preference for active snippets)\n\n/edit <id>\n\tEdit the snippet with the specified snippet id\n\n/edit\n\tEdit the currently active snippets of code that you typed or read with /open" },
            { "help.edit.args", "<name or id>" },
            { "help.edit.summary", "edit a source entry referenced by name or id" },
            { "help.env", "View or change the evaluation context.  The evaluation context is the class path,\nmodule path, etc.\n/env\n\tShow the evaluation context displayed as context options.\n\n/env [-class-path <path>] [-module-path <path>] [-add-modules <modules>] ...\n\tWith at least one option set, sets the evaluation context.  If snippets\n\thave been defined, the execution state is reset with the new\n\tevaluation context and the snippets will be replayed -- the replay is not\n\tshown, however, errors will display.  This is equivalent to: /reload -quiet\n\tFor details of context options, see:\n\n\t\t/help context\n\n\tFor example:\n\n\t\t/env -add-modules com.greetings" },
            { "help.env.args", "[-class-path <path>] [-module-path <path>] [-add-modules <modules>] ..." },
            { "help.env.summary", "view or change the evaluation context" },
            { "help.exit", "Leave the jshell tool.  No work is saved.\nSave any work before using this command" },
            { "help.exit.args", "" },
            { "help.exit.summary", "exit jshell" },
            { "help.help", "Display information about jshell.\n/help\n\tList the jshell commands and help subjects.\n\n/help <command>\n\tDisplay information about the specified command. The slash must be included.\n\tOnly the first few letters of the command are needed -- if more than one\n\teach will be displayed.  Example:  /help /li\n\n/help <subject>\n\tDisplay information about the specified help subject. Example: /help intro" },
            { "help.help.args", "[<command>|<subject>]" },
            { "help.help.summary", "get information about jshell" },
            { "help.history", "Display the history of snippet and command input since this jshell was launched." },
            { "help.history.args", "" },
            { "help.history.summary", "history of what you have typed" },
            { "help.id", "Reevaluate the snippet specified by the id." },
            { "help.id.args", "" },
            { "help.id.summary", "re-run snippet by id" },
            { "help.imports", "List the current active jshell imports." },
            { "help.imports.args", "" },
            { "help.imports.summary", "list the imported items" },
            { "help.intro", "The jshell tool allows you to execute Java code, getting immediate results.\nYou can enter a Java definition (variable, method, class, etc), like:  int x = 8\nor a Java expression, like:  x + x\nor a Java statement or import.\nThese little chunks of Java code are called 'snippets'.\n\nThere are also jshell commands that allow you to understand and\ncontrol what you are doing, like:  /list\n\nFor a list of commands: /help" },
            { "help.intro.summary", "an introduction to the jshell tool" },
            { "help.list", "Show the source of snippets, prefaced with the snippet id.\n\n/list\n\tList the currently active snippets of code that you typed or read with /open\n\n/list -start\n\tList the automatically evaluated start-up snippets\n\n/list -all\n\tList all snippets including failed, overwritten, dropped, and start-up\n\n/list <name>\n\tList snippets with the specified name (preference for active snippets)\n\n/list <id>\n\tList the snippet with the specified snippet id" },
            { "help.list.args", "[<name or id>|-all|-start]" },
            { "help.list.summary", "list the source you have typed" },
            { "help.methods", "List the name, parameter types, and return type of jshell methods.\n\n/methods\n\tList the name, parameter types, and return type of the current active jshell methods\n\n/methods <name>\n\tList jshell methods with the specified name (preference for active methods)\n\n/methods <id>\n\tList the jshell method with the specified snippet id\n\n/methods -start\n\tList the automatically added start-up jshell methods\n\n/methods -all\n\tList all snippets including failed, overwritten, dropped, and start-up" },
            { "help.methods.args", "[<name or id>|-all|-start]" },
            { "help.methods.summary", "list the declared methods and their signatures" },
            { "help.open", "Open a file and read its contents as snippets and commands.\n\n/open <file>\n\tRead the specified file as jshell input." },
            { "help.open.args", "<file>" },
            { "help.open.summary", "open a file as source input" },
            { "help.previous", "Reevaluate the n-th most recently entered snippet." },
            { "help.previous.args", "" },
            { "help.previous.summary", "re-run n-th previous snippet" },
            { "help.quest", "Display information about jshell (abbreviation for /help).\n/?\n\tDisplay list of commands and help subjects.\n/? <command>\n\tDisplay information about the specified command. The slash must be included.\n\tOnly the first few letters of the command are needed -- if more than one\n\tmatch, each will be displayed.  Example:  /? /li\n/? <subject>\n\tDisplay information about the specified help subject. Example: /? intro" },
            { "help.quest.args", "[<command>|<subject>]" },
            { "help.quest.summary", "get information about jshell" },
            { "help.reload", "Reset the jshell tool code and execution state then replay each valid snippet\nand any /drop commands in the order they were entered.\n\n/reload\n\tReset and replay the valid history since jshell was entered, or\n\ta /reset, or /reload command was executed -- whichever is most\n\trecent.\n\n/reload -restore\n\tReset and replay the valid history between the previous and most\n\trecent time that jshell was entered, or a /reset, or /reload\n\tcommand was executed. This can thus be used to restore a previous\n\tjshell tool session.\n\n/reload [-restore] -quiet\n\tWith the '-quiet' argument the replay is not shown.  Errors will display.\n\nEach of the above accepts context options, see:\n\n\t/help context\n\nFor example:\n\n\t/reload -add-modules com.greetings -restore" },
            { "help.reload.args", "[-restore] [-quiet] [-class-path <path>] [-module-path <path>]..." },
            { "help.reload.summary", "reset and replay relevant history -- current or previous (-restore)" },
            { "help.reset", "Reset the jshell tool code and execution state:\n\t* All entered code is lost.\n\t* Start-up code is re-executed.\n\t* The execution state is restarted.\n\tTool settings are maintained, as set with: /set ...\nSave any work before using this command.\nThe /reset command accepts context options, see:\n\n\t/help context\n" },
            { "help.reset.args", "[-class-path <path>] [-module-path <path>] [-add-modules <modules>]..." },
            { "help.reset.summary", "reset jshell" },
            { "help.save", "Save the specified snippets and/or commands to the specified file.\n\n/save <file>\n\tSave the source of current active snippets to the file.\n\n/save -all <file>\n\tSave the source of all snippets to the file.\n\tIncludes source including overwritten, failed, and start-up code.\n\n/save -history <file>\n\tSave the sequential history of all commands and snippets entered since jshell was launched.\n\n/save -start <file>\n\tSave the current start-up definitions to the file." },
            { "help.save.args", "[-all|-history|-start] <file>" },
            { "help.save.summary", "Save snippet source to a file." },
            { "help.set", "Set jshell configuration information, including:\nthe external editor to use, the start-up definitions to use, a new feedback mode,\nthe command prompt, the feedback mode to use, or the format of output.\n\n/set editor [-wait] <command> <optional-arg>...\n\tSpecify the command to launch for the /edit command.\n\tThe <command> is an operating system dependent string.\n\n/set start <file>\n\tThe contents of the specified <file> become the default start-up snippets and commands.\n\n/set feedback <mode>\n\tSet the feedback mode describing displayed feedback for entered snippets and commands.\n\n/set mode <mode> [<old-mode>] -command|-quiet|-delete\n\tCreate or update a user-defined feedback mode, optionally copying from an existing mode.\n\n/set prompt <mode> \"<prompt>\" \"<continuation-prompt>\"\n\tSet the displayed prompts for a given feedback mode.\n\n/set truncation <mode> <length> <selector>...\n\tSet the maximum length of a displayed value.\n\n/set format <mode> <field> \"<format>\" <selector>...\n\tConfigure a feedback mode by setting the format of a field when the selector matches.\n\n/set\n\tShow editor, start, and feedback settings as /set commands.\n\tTo show the settings of any of the above, omit the set value.\n\nTo get more information about one of these forms, use /help with the form specified.\nFor example:   /help /set format" },
            { "help.set._retain", "The '-retain' option saves a setting so that it is used in future sessions.\nThe -retain option can be used on the following forms of /set:\n\n\t/set editor -retain\n\t/set start -retain\n\t/set feedback -retain\n\t/set mode -retain\n\nSee these commands for more detail -- for example /help /set editor" },
            { "help.set.args", "editor|start|feedback|mode|prompt|truncation|format ..." },
            { "help.set.editor", "Specify the command to launch for the /edit command:\n\n\t/set editor [-retain] [-wait] <command>\n\n\t/set editor [-retain] -default\n\n\t/set editor [-retain] -delete\n\nRetain the current editor setting for future sessions:\n\n\t/set editor -retain\n\nShow the command to launch for the /edit command:\n\n\t/set editor\n\nThe <command> is an operating system dependent string.\nThe <command> may include space-separated arguments (such as flags)\n\nIf the -default option is specified, the built-in default editor will be used.\n\nIf the -delete option is specified, previous settings are ignored -- the editor\nsettings are initialized as when starting the jshell tool.  Specifically, if there\nis a retained setting it is used (unless both -retain and -delete are specified --\nwhich deletes the retained setting), if one of these environment variables is set\nit will be used: JSHELLEDITOR, VISUAL, or EDITOR (in that order).  Otherwise the\nbuilt-in default editor will be used.\n\nIf <command> is specified, it will be used as the external editor. The <command>\nconsists of the program and zero or more program arguments.  When <command>\nis used, the temporary file to edit will be appended as the last argument.\nNormally, edit mode will last until the external editor exits. Some external editors\nwill exit immediately (for example, if the edit window exists) either external editor\nflags should be used to prevent immediate exit, or the -wait option should be used to\nprompt the user to indicate when edit mode should end.\n\nNote: while in edit mode no command inputs are seen.  After leaving edit mode changes\nto the edited snippets are not seen.\n\nWhen the -retain option is used, the setting will be used in this and future\nruns of the jshell tool.\n\nThe form without <command> or options shows the editor setting.\n" },
            { "help.set.feedback", "Set the feedback mode describing displayed feedback for entered snippets and commands:\n\n\t/set feedback [-retain] <mode>\n\nRetain the current feedback mode for future sessions:\n\n\t/set feedback -retain\n\nShow the feedback mode and list available modes:\n\n\t/set feedback\n\nWhere <mode> is the name of a previously defined feedback mode.\nYou may use just enough letters to make it unique.\nUser-defined modes can be added, see '/help /set mode'\n\nWhen the -retain option is used, the setting will be used in this and future\nruns of the jshell tool.\n\nThe form without <mode> or -retain displays the current feedback mode and available modes.\n" },
            { "help.set.format", "Set the format for reporting a snippet event:\n\n\t/set format <mode> <field> \"<format>\" <selector>...\n\nShow the format settings:\n\n\t/set format [<mode> [<field>]]\n\nWhere <mode> is the name of a previously defined feedback mode -- see '/help /set mode'.\nWhere <field> is the name of context-specific format to define.\nWhere <format> is a quoted string which will be the value of the field if one of\nthe selectors matches (or there are no selectors). When the format is used,\nfield names enclosed in braces are replaced with the value of the field at that\ntime. These fields may have been previously defined with this command or may be\none of these predefined fields specific to the context:\n\t{name}       == The name, e.g.: the variable name, ...\n\t{type}       == The type name. The type of a variable or expression, the\n\t\t\tparameter types of a method\n\t{value}      == The result value of an expression or variable initialization\n\t{unresolved} == The list of unresolved references\n\t{errors}     == The list of recoverable errors (during the processing of the\n\t\t\t\"display\" field only)\n\t{err}        == An unformatted error line (during the processing of the\n\t\t\t\"errorline\" field only)\nThe following fields are accessed by the tool to determine the displayed feedback:\n\t{display}    == The displayed message for a snippet event\n\t{errorline}  == The format of one error line within the \"errors\" field\n\t{pre}        == The feedback prefix (begins command feedback)\n\t{post}       == The feedback postfix (ends command feedback)\n\t{errorpre}   == The error prefix (begins error feedback)\n\t{errorpost}  == The error postfix (ends error feedback)\nThese fields have default settings (which may be overwritten).\nWhere <selector> is the context in which the format is applied.\nThe structure of selector is a hyphen separated list of selector kind lists.\nA selector kind list is a comma separated list of values of one selector kind.\nA selector matches if each selector kind list matches; A selector kind list\nmatches if one of the values matches.\n\nThe case selector kind describes the kind of snippet.  The values are:\n\timport     -- import declaration\n\tclass      -- class declaration\n\tinterface  -- interface declaration\n\tenum       -- enum declaration\n\tannotation -- annotation interface declaration\n\tmethod     -- method declaration -- note: {type}==parameter-types\n\tvardecl    -- variable declaration without init\n\tvarinit    -- variable declaration with init\n\texpression -- expression -- note: {name}==scratch-variable-name\n\tvarvalue   -- variable value expression\n\tassignment -- assign variable\n\tstatement  -- statement\nThe action selector kind describes what happened to the snippet.  The values are:\n\tadded     -- snippet has been added\n\tmodified  -- an existing snippet has been modified\n\treplaced  -- an existing snippet has been replaced with a new snippet\n\toverwrote -- an existing snippet has been overwritten\n\tdropped   -- snippet has been dropped\n\tused      -- snippet was used when it cannot be\nThe when-did-it-occur selector kind describes if this is a direct or indirect action.  The values are:\n\tprimary -- the entered snippet\n\tupdate  -- an update to a dependent snippet\nThe resolution-state selector kind describes the state of resolution/definition of the snippet.  The values are:\n\tok         -- resolved correctly\n\tdefined    -- defined despite recoverably unresolved references\n\tnotdefined -- not defined because of recoverably unresolved references\nThe unresolved-count selector kind describes the number of unresolved references.  The values are:\n\tunresolved0 -- no names are unresolved\n\tunresolved1 -- one name is unresolved\n\tunresolved2 -- two or more names are unresolved\nThe errors-count selector kind describes the number of errors.  The values are:\n\terror0 -- no errors\n\terror1 -- one error\n\terror2 -- two or more errors\n\nExamples:\n\t/set format myformat action 'Created' added-primary\n\t/set format myformat action 'Update replaced' replaced-update\n\t/set format myformat display '{pre}{action} class {name}{post}' class-ok\n\t/set format myformat display '{pre}{action} variable {name}, reset to null{post}' replaced-vardecl,varinit-ok-update\n\nNote that subsequent selectors for a field may overwrite some or all of previous used selectors -- last one wins\n\nThe form without <format> shows the current format settings.\nWhen the <mode> is specified only the format settings for that mode are shown.\nWhen both the <mode> and <field> are specified only the format settings for that\nmode and field are shown.  Example:\n\t/set format myformat\nshows the format settings for the mode myformat\n" },
            { "help.set.mode", "Create a user-defined feedback mode, optionally copying from an existing mode:\n\n\t/set mode <new-mode> [<old-mode>] (-command|-quiet)\n\nRetain a user-defined feedback mode for future sessions:\n\n\t/set mode -retain <mode>\n\nDelete a user-defined feedback mode:\n\n\t/set mode -delete [-retain] <mode>\n\nShow feedback mode settings:\n\n\t/set mode [<mode>]\n\nWhere <new-mode> is the name of a mode you wish to create.\nWhere <old-mode> is the name of a existing feedback mode.\nWhere <mode> is the name of a existing feedback mode.\n\nIf <old-mode> is present, its settings are copied to the new mode.\n\nThe feedback that a mode provides for entered snippets is determined by the\n'/set format' settings. However, for entered commands, feedback is either on or off,\nas determined by the option used when creating the mode; Either the option '-command'\nor the option '-quiet' must be specified. If '-command' is used, informative and\nverifying command feedback is displayed when in the new mode.  If '-quiet' is used,\ncommands give only essential feedback (e.g., errors).\n\nOnce the new mode is created, use '/set format', '/set prompt' and '/set truncation'\nto configure it.  Use '/set feedback' to use the new mode.\n\nWhen the '-retain' option is used (without the '-delete' option), the mode (including\nits current prompt, format, and truncation settings) will be stored for use in\nfuture runs of the jshell tool.  If retain is not used, the mode is only defined in\nthe current session. After updating the mode's settings, retain the mode again to\npreserve the updates across sessions.\n\nWhen only the '-delete' option is used, the mode is deleted from the current session.\nWhen both '-retain' and '-delete' are used, the mode is deleted from the current and\nfuture sessions.\n\nWhen the form without options is used, the mode settings are displayed.\nWhen the <mode> is specified, only the mode settings for that mode are shown.\nNote: the settings for the mode include the settings for prompt, format, and\ntruncation.\nExample:\n\t/set mode myformat\n\nshows the mode, prompt, format, and truncation settings for the mode myformat" },
            { "help.set.prompt", "Set the prompts.  Both the normal prompt and the continuation-prompt must be set:\n\n\t/set prompt <mode> \"<prompt>\" \"<continuation-prompt>\"\n\nShow the normal prompt and the continuation-prompts:\n\n\t/set prompt [<mode>]\n\nWhere <mode> is the name of a previously defined feedback mode.\nWhere <prompt> and <continuation-prompt> are quoted strings printed as input prompts;\nBoth may optionally contain '%%s' which will be substituted with the next snippet id --\nnote that what is entered may not be assigned that id, for example it may be an error or command.\nThe continuation-prompt is used on the second and subsequent lines of a multi-line snippet.\n\nThe form without <prompt> shows the currently set prompts.\nWhen the <mode> is specified only the prompts for that mode are shown.\nExample:\n\t/set prompt myformat\nshows the prompts set for the mode myformat\n" },
            { "help.set.start", "Set the start-up configuration -- a sequence of snippets and commands read at start-up:\n\n\t/set start [-retain] <file>...\n\n\t/set start [-retain] -default\n\n\t/set start [-retain] -none\n\nRetain the start-up configuration for future sessions:\n\n\t/set start -retain\n\nShow the start-up setting:\n\n\t/set start\n\nThe contents of the specified <file> become the start-up snippets and commands used\nwhen the /reset, /reload, or /env commands are used in this session.\nIf instead the -default option is specified, the predefined start-up import\nsnippets will be used.\nIf the -none option is used, the start-up will be empty -- no start-up snippets\nor commands will be used.\nThis command is good for testing the start-up settings.  To retain them for future\nruns of the jshell tool use the command:\n\t/set start -retain\n\nWhen the -retain option is used, the setting will be used in this and future\nruns of the jshell tool.\n\nThe form without <file> or options shows the start-up setting.\nNote: if the start-up was last set from a file, this is shown with the\n'set start' command followed by the contents of the file.\n\nThe <file> may be an operating system file name, or one of the predefined\nstartup file names: DEFAULT, PRINTING, or JAVASE.\nThese are respectively: the default import snippets (as used by -default),\ndefinitions of print(), println(), and printf() method snippets, or\nimports of all Java SE packages.\nMore than one <file> may be specified, for example:\n\n\t/set start -retain DEFAULT PRINTING" },
            { "help.set.summary", "set jshell configuration information" },
            { "help.set.truncation", "Set the max length of a displayed value:\n\n\t/set truncation <mode> <length> <selector>...\n\nShow the current truncation settings:\n\n\t/set truncation [<mode>]\n\nWhere <mode> is the name of a previously defined feedback mode -- see '/help /set mode'.\nWhere <length> is an unsigned integer representing a maximum length.\nWhere <selector> is only needed if you wish to fine-tune value truncation length\nby context, <selector> is the context in which the truncation is applied.\nThe structure of selector is a hyphen separated list of selector kind lists.\nA selector kind list is a comma separated list of values of one selector kind.\nA selector matches if each selector kind list matches; A selector kind list\nmatches if one of the values matches.\n\nBelow are the relevant selector kinds for truncation.\n\nThe case selector kind describes the kind of snippet.  The values are:\n\tvardecl    -- variable declaration without init\n\tvarinit    -- variable declaration with init\n\texpression -- expression -- note: {name}==scratch-variable-name\n\tvarvalue   -- variable value expression\n\tassignment -- assign variable\nThe action selector kind describes what happened to the snippet.  The values are:\n\tadded     -- snippet has been added\n\tmodified  -- an existing snippet has been modified\n\treplaced  -- an existing snippet has been replaced with a new snippet\nExamples:\n\t/set trunc mymode 80\n\t/set truncation mymode 45 expression\n\t/set truncation mymode 0 vardecl-modified,replaced\n\nNote that subsequent selectors for a field may overwrite some or all of previous used selectors -- last one wins\n\nThe form without <length> shows the truncation settings.\nWhen the <mode> is specified only the truncation settings for that mode are shown.\nExample:\n\t/set truncation myformat\nshows the truncation settings for the mode myformat\n" },
            { "help.shortcuts", "Supported shortcuts include:\n\n<tab>\n\t\tAfter entering the first few letters of a Java identifier,\n\t\ta jshell command, or, in some cases, a jshell command argument,\n\t\tpress the <tab> key to complete the input.\n\t\tIf there is more than one completion, then possible completions will be shown.\n\t\tWill show documentation if available and appropriate.\n\nShift-<tab> v\n\t\tAfter a complete expression, hold down <shift> while pressing <tab>,\n\t\tthen release and press \"v\", the expression will be converted to\n\t\ta variable declaration whose type is based on the type of the expression.\n\nShift-<tab> i\n\t\tAfter an unresolvable identifier, hold down <shift> while pressing <tab>,\n\t\tthen release and press \"i\", and jshell will propose possible imports\n\t\twhich will resolve the identifier based on the content of the specified classpath." },
            { "help.shortcuts.summary", "a description of keystrokes for snippet and command completion,\ninformation access, and automatic code generation" },
            { "help.types", "List jshell classes, interfaces, and enums.\n\n/types\n\tList the current active jshell classes, interfaces, and enums.\n\n/types <name>\n\tList jshell types with the specified name (preference for active types)\n\n/types <id>\n\tList the jshell type with the specified snippet id\n\n/types -start\n\tList the automatically added start-up jshell types\n\n/types -all\n\tList all jshell types including failed, overwritten, dropped, and start-up" },
            { "help.types.args", "[<name or id>|-all|-start]" },
            { "help.types.summary", "list the declared types" },
            { "help.usage", "Usage:   jshell <options> <load files>\nwhere possible options include:\n    --class-path <path>   Specify where to find user class files\n    --module-path <path>  Specify where to find application modules\n    --add-modules <module>(,<module>)*\n                          Specify modules to resolve, or all modules on the\n                            module path if <module> is ALL-MODULE-PATHs\n    --startup <file>      One run replacement for the start-up definitions\n    --no-startup          Do not run the start-up definitions\n    --feedback <mode>     Specify the initial feedback mode. The mode may be\n                            predefined (silent, concise, normal, or verbose) or\n                            previously user-defined\n    -q                    Quiet feedback.  Same as: --feedback concise\n    -s                    Really quiet feedback.  Same as: --feedback silent\n    -v                    Verbose feedback.  Same as: --feedback verbose\n    -J<flag>              Pass <flag> directly to the runtime system.\n                            Use one -J for each runtime flag or flag argument\n    -R<flag>              Pass <flag> to the remote runtime system.\n                            Use one -R for each remote flag or flag argument\n    -C<flag>              Pass <flag> to the compiler.\n                            Use one -C for each compiler flag or flag argument\n    --version             Print version information and exit\n    --show-version        Print version information and continue\n    --help                Print this synopsis of standard options and exit\n    --help-extra, -X      Print help on non-standard options and exit\n" },
            { "help.usage.x", "    --add-exports <module>/<package>   Export specified module-private package to snippets\n    --execution <spec>                 Specify an alternate execution engine.\n                                         Where <spec> is an ExecutionControl spec.\n                                         See the documentation of the package\n                                         jdk.jshell.spi for the syntax of the spec\n    \nThese options are non-standard and subject to change without notice.\n" },
            { "help.vars", "List the type, name, and value of jshell variables.\n\n/vars\n\tList the type, name, and value of the current active jshell variables\n\n/vars <name>\n\tList jshell variables with the specified name (preference for active variables)\n\n/vars <id>\n\tList the jshell variable with the specified snippet id\n\n/vars -start\n\tList the automatically added start-up jshell variables\n\n/vars -all\n\tList all jshell variables including failed, overwritten, dropped, and start-up" },
            { "help.vars.args", "[<name or id>|-all|-start]" },
            { "help.vars.summary", "list the declared variables and their values" },
            { "jshell.console.choice", "Choice: " },
            { "jshell.console.completion.all.completions", "<press tab again to see all possible completions>" },
            { "jshell.console.completion.all.completions.number", "<press tab again to see all possible completions; total possible completions: {0}>" },
            { "jshell.console.completion.current.signatures", "Signatures:" },
            { "jshell.console.create.variable", "Create variable" },
            { "jshell.console.do.nothing", "Do nothing" },
            { "jshell.console.incomplete", "\nResults may be incomplete; try again later for complete results." },
            { "jshell.console.no.candidate", "\nNo candidate fully qualified names found to import." },
            { "jshell.console.no.javadoc", "<no documentation found>" },
            { "jshell.console.no.such.command", "No such command" },
            { "jshell.console.resolvable", "\nThe identifier is resolvable in this context." },
            { "jshell.console.see.documentation", "<press tab again to see documentation>" },
            { "jshell.console.see.full.documentation", "<press tab again to see full documentation>" },
            { "jshell.console.see.next.command.doc", "<press tab to see next command>" },
            { "jshell.console.see.next.javadoc", "<press tab to see next documentation>" },
            { "jshell.console.see.next.page", "<press tab again to see next page>" },
            { "jshell.console.see.synopsis", "<press tab again to see synopsis>" },
            { "jshell.err.arg", "Invalid ''{0}'' argument: {1}" },
            { "jshell.err.cannot.delete.current.mode", "The current feedback mode ''{0}'' cannot be deleted, use ''/set feedback'' first -- {1}" },
            { "jshell.err.cannot.delete.retained.mode", "The retained feedback mode ''{0}'' cannot be deleted, use ''/set feedback -retain'' first -- {1}" },
            { "jshell.err.cant.launch.editor", "Cannot launch built-in editor -- unexpected exception: {0}" },
            { "jshell.err.classpath.arg", "The /classpath command requires a path argument." },
            { "jshell.err.command.ambiguous", "Command: ''{0}'' is ambiguous: {1}" },
            { "jshell.err.conflicting.options", "Conflicting options -- {0}" },
            { "jshell.err.continuation.prompt.required", "Continuation prompt required -- {0}" },
            { "jshell.err.corrupted.stored.startup", "Corrupted stored startup, using default -- {0}" },
            { "jshell.err.default.option.or.program", "Specify -default option, -delete option, or program -- {0}" },
            { "jshell.err.drop.ambiguous", "The argument references more than one import, variable, method, or class." },
            { "jshell.err.drop.arg", "In the /drop argument, please specify an import, variable, method, or class to drop.\nSpecify by id or name. Use /list to see ids. Use /reset to reset all state." },
            { "jshell.err.failed", "Failed." },
            { "jshell.err.feedback.ambiguous.mode", "Matches more then one current feedback mode: {0} -- {1}" },
            { "jshell.err.feedback.different.selector.kinds", "Different selector kinds in same sections of selector list ''{0}'' in ''{1}'' -- {2}" },
            { "jshell.err.feedback.does.not.match.mode", "Does not match any current feedback mode: {0} -- {1}" },
            { "jshell.err.feedback.multiple.sections", "Selector kind in multiple sections of selector list ''{0}'' in ''{1}'' -- {2}" },
            { "jshell.err.feedback.must.be.quoted", "Format ''{0}'' must be quoted -- {1}" },
            { "jshell.err.feedback.not.a.valid.selector", "Not a valid selector ''{0}'' in ''{1}'' -- {2}" },
            { "jshell.err.field.name", "Expected a field name: {0} -- {1}" },
            { "jshell.err.file.exception", "File ''{1}'' for ''{0}'' threw exception: {2}" },
            { "jshell.err.file.filename", "''{0}'' requires a filename argument." },
            { "jshell.err.file.not.accessible", "File ''{1}'' for ''{0}'' is not accessible: {2}" },
            { "jshell.err.file.not.found", "File ''{1}'' for ''{0}'' is not found." },
            { "jshell.err.help.arg", "No commands or subjects start with the provided argument: {0}" },
            { "jshell.err.may.not.specify.options.and.snippets", "Options and snippets must not both be used: {0}" },
            { "jshell.err.missing.mode", "Missing the feedback mode -- {0}" },
            { "jshell.err.mode.creation", "To create a new mode either the -command or the -quiet option must be used -- {0}" },
            { "jshell.err.mode.exists", "Mode to be created already exists: {0} -- {1}" },
            { "jshell.err.mode.name", "Expected a feedback mode name: {0}" },
            { "jshell.err.mode.unknown", "No feedback mode named: {0} -- {1}" },
            { "jshell.err.no.builtin.editor", "Built-in editor not available." },
            { "jshell.err.no.such.command.or.snippet.id", "No such command or snippet id: {0}" },
            { "jshell.err.no.such.snippets", "No such snippet: {0}" },
            { "jshell.err.not.valid.with.predefined.mode", "Not valid with a predefined mode: {0} -- {1}" },
            { "jshell.err.opt.arg", "Argument to {0} missing." },
            { "jshell.err.opt.feedback.one", "Only one feedback option (--feedback, -q, -s, or -v) may be used." },
            { "jshell.err.opt.invalid", "Invalid options: {0}." },
            { "jshell.err.opt.one", "Only one {0} option may be used." },
            { "jshell.err.opt.startup.conflict", "Conflicting options: both --startup and --no-startup were used." },
            { "jshell.err.opt.unknown", "Unknown option: {0}" },
            { "jshell.err.option.or.filename", "Specify no more than one of -default, -none, or a startup file name -- {0}" },
            { "jshell.err.out.of.range", "Out of range" },
            { "jshell.err.reload.no.previous", "No previous history to restore" },
            { "jshell.err.reload.restarting.previous.state", "Restarting and restoring from previous state." },
            { "jshell.err.reload.restarting.state", "Restarting and restoring state." },
            { "jshell.err.restart.failed", "Restart failed: {0}\n\nReverting to previous settings and restarting..." },
            { "jshell.err.retained.feedback.mode.must.be.retained.or.predefined", "''/set feedback -retain <mode>'' requires that <mode> is predefined or has been retained with ''/set mode -retain'' -- {0}" },
            { "jshell.err.retained.mode.failure", "Failure in retained modes (modes cleared) -- {0} {1}" },
            { "jshell.err.setting.to.retain.must.be.specified", "The setting to retain must be specified -- {0}" },
            { "jshell.err.startup.unexpected.exception", "Unexpected exception reading start-up: {0}" },
            { "jshell.err.sub.ambiguous", "Ambiguous sub-command argument to ''{0}'': {1}" },
            { "jshell.err.sub.arg", "The ''{0}'' command requires a sub-command. See: ''/help {0}''" },
            { "jshell.err.the.snippet.cannot.be.used.with.this.command", "This command does not accept the snippet ''{0}'' : {1}" },
            { "jshell.err.truncation.expected.length", "Expected truncation length -- {0}" },
            { "jshell.err.truncation.length.not.integer", "Truncation length must be an integer: {0} -- {1}" },
            { "jshell.err.unexpected.at.end", "Unexpected arguments at end of command: {0} -- {1}" },
            { "jshell.err.unexpected.exception", "Unexpected exception: {0}" },
            { "jshell.err.unknown.option", "Unknown option: {0} -- {1}" },
            { "jshell.err.wait.applies.to.external.editor", "-wait applies to external editors" },
            { "jshell.fix.wrong.shortcut", "Unexpected character after Shift-Tab.  Use \"i\" for auto-import or \"v\" for variable creation.  For more information see:\n/help shortcuts" },
            { "jshell.label.editpad", "JShell Edit Pad" },
            { "jshell.msg.classpath", "Path ''{0}'' added to classpath" },
            { "jshell.msg.error", "Error:" },
            { "jshell.msg.feedback.mode", "Feedback mode: {0}" },
            { "jshell.msg.feedback.mode.following", "Available feedback modes:" },
            { "jshell.msg.feedback.new.mode", "Created new feedback mode: {0}" },
            { "jshell.msg.feedback.retained.mode.following", "Retained feedback modes:" },
            { "jshell.msg.goodbye", "Goodbye" },
            { "jshell.msg.help.begin", "Type a Java language expression, statement, or declaration.\nOr type one of the following commands:\n" },
            { "jshell.msg.help.for.help", "Type /help for help." },
            { "jshell.msg.help.subject", "\nFor more information type ''/help'' followed by the name of a\ncommand or a subject.\nFor example ''/help /list'' or ''/help intro''.\n\nSubjects:\n\n" },
            { "jshell.msg.native.method", "Native Method" },
            { "jshell.msg.no.active", "There are no active definitions." },
            { "jshell.msg.press.return.to.leave.edit.mode", "Press return to leave edit mode." },
            { "jshell.msg.resetting", "Resetting..." },
            { "jshell.msg.resetting.state", "Resetting state." },
            { "jshell.msg.see", "See {0} for help." },
            { "jshell.msg.see.classes.etc", "See /types, /methods, /vars, or /list" },
            { "jshell.msg.set.editor.retain", "Editor setting retained: {0}" },
            { "jshell.msg.set.editor.set", "Editor set to: {0}" },
            { "jshell.msg.set.restore", "Setting new options and restoring state." },
            { "jshell.msg.set.show.mode.settings", "\nTo show mode settings use ''/set prompt'', ''/set truncation'', ...\nor use ''/set mode'' followed by the feedback mode name." },
            { "jshell.msg.terminated", "State engine terminated.\nRestore definitions with: /reload -restore" },
            { "jshell.msg.try.command.without.args", "Try ''{0}'' without arguments." },
            { "jshell.msg.try.set.editor", "See ''/help /set editor'' to use external editor." },
            { "jshell.msg.unknown.source", "Unknown Source" },
            { "jshell.msg.use.one.of", "Use one of: {0}" },
            { "jshell.msg.vars.not.active", "(not-active)" },
            { "jshell.msg.warning", "Warning:" },
            { "jshell.msg.welcome", "Welcome to JShell -- Version {0}\nFor an introduction type: /help intro" },
            { "startup.feedback", "/set mode verbose -command    \n\n/set prompt verbose '\\njshell> '   '   ...> '    \n\n/set format verbose pre '|  '    \n/set format verbose post '%n'    \n/set format verbose errorpre '|  '    \n/set format verbose errorpost '%n'    \n\n/set format verbose errorline '{post}{pre}    {err}'    \n\n/set format verbose action 'created' added-primary    \n/set format verbose action 'modified' modified-primary    \n/set format verbose action 'replaced' replaced-primary    \n/set format verbose action 'overwrote' overwrote-primary    \n/set format verbose action 'dropped' dropped-primary    \n/set format verbose action '  update created' added-update    \n/set format verbose action '  update modified' modified-update    \n/set format verbose action '  update replaced' replaced-update    \n/set format verbose action '  update overwrote' overwrote-update    \n/set format verbose action '  update dropped' dropped-update    \n\n/set format verbose until ', however, it cannot be instantiated or its methods invoked until'   defined-class-primary    \n/set format verbose until ', however, its methods cannot be invoked until'                      defined-interface-primary    \n/set format verbose until ', however, it cannot be used until'                                  defined-enum,annotation-primary    \n/set format verbose until ', however, it cannot be invoked until'                               defined-method-primary    \n/set format verbose until ', however, it cannot be referenced until'                            notdefined-primary    \n/set format verbose until ' which cannot be instantiated or its methods invoked until'          defined-class-update    \n/set format verbose until ' whose methods cannot be invoked until'                              defined-interface-update    \n/set format verbose until ' which cannot be invoked until'                                      defined-method-update    \n/set format verbose until ' which cannot be referenced until'                                   notdefined-update    \n\n/set format verbose unrerr '{unresolved} is declared'                                           unresolved1-error0    \n/set format verbose unrerr '{unresolved} are declared'                                          unresolved2-error0    \n/set format verbose unrerr ' this error is corrected: {errors}'                                 unresolved0-error1    \n/set format verbose unrerr '{unresolved} is declared and this error is corrected: {errors}'     unresolved1-error1    \n/set format verbose unrerr '{unresolved} are declared and this error is corrected: {errors}'    unresolved2-error1    \n/set format verbose unrerr ' these errors are corrected: {errors}'                              unresolved0-error2    \n/set format verbose unrerr '{unresolved} is declared and these errors are corrected: {errors}'  unresolved1-error2    \n/set format verbose unrerr '{unresolved} are declared and these errors are corrected: {errors}' unresolved2-error2    \n\n/set format verbose resolve '{until}{unrerr}'                                                   defined,notdefined-added,modified,replaced,used    \n\n/set format verbose typeKind 'class'                  class    \n/set format verbose typeKind 'interface'              interface    \n/set format verbose typeKind 'enum'                   enum    \n/set format verbose typeKind 'annotation interface'   annotation    \n\n/set format verbose result '{name} ==> {value}{post}'                                        added,modified,replaced-ok-primary    \n\n/set format verbose display '{result}{pre}created scratch variable {name} : {type}{post}'    expression-added,modified,replaced-primary    \n/set format verbose display '{result}{pre}value of {name} : {type}{post}'                    varvalue-added,modified,replaced-primary    \n/set format verbose display '{result}{pre}assigned to {name} : {type}{post}'                 assignment-primary    \n/set format verbose display '{result}{pre}{action} variable {name} : {type}{resolve}{post}'  varinit,vardecl    \n/set format verbose display '{pre}{action} variable {name}{resolve}{post}'                   vardecl,varinit-notdefined    \n/set format verbose display '{pre}{action} variable {name}{post}'                            dropped-vardecl,varinit,expression    \n/set format verbose display '{pre}{action} variable {name}, reset to null{post}'             replaced-vardecl,varinit-ok-update    \n\n/set format verbose display '{pre}{action} {typeKind} {name}{resolve}{post}'                 class,interface,enum,annotation    \n/set format verbose display '{pre}{action} method {name}({type}){resolve}{post}'             method    \n\n/set format verbose display '{pre}attempted to use {typeKind} {name}{resolve}{post}'         used-class,interface,enum,annotation    \n/set format verbose display '{pre}attempted to call method {name}({type}){resolve}{post}'    used-method    \n\n/set truncation verbose 80\n/set truncation verbose 1000                                                                  varvalue,expression\n\n/set mode normal -command verbose    \n/set format normal display ''                                                               added,modified,replaced,overwrote,dropped-update    \n/set format normal display '{pre}{action} variable {name}, reset to null{post}'             replaced-vardecl,varinit-ok-update    \n/set format normal display '{result}'                                                       added,modified,replaced-expression,varvalue,assignment,varinit,vardecl-ok-primary    \n/set mode concise -quiet normal    \n\n/set prompt concise 'jshell> '   '   ...> '    \n\n/set format concise display ''                                                              class,interface,enum,annotation,method,assignment,varinit,vardecl-ok    \n\n/set feedback normal    \n\n/set mode silent -quiet    \n/set prompt silent '-> ' '>> '    \n/set truncation silent 80\n/set truncation silent 1000                                                                  varvalue,expression\n/set format silent pre '|  '    \n/set format silent post '%n'    \n/set format silent errorpre '|  '    \n/set format silent errorpost '%n'    \n/set format silent display ''    \n" },
        };
    }
}
