#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: generics-sop
version: 0.3.1.0
id: generics-sop-0.3.1.0-FKagpR579zL2xkhppkccJi
key: generics-sop-0.3.1.0-FKagpR579zL2xkhppkccJi
license: BSD3
maintainer: andres@well-typed.com
synopsis: Generic Programming using True Sums of Products
description:
    A library to support the definition of generic functions.
    Datatypes are viewed in a uniform, structured way:
    the choice between constructors is represented using an n-ary
    sum, and the arguments of each constructor are represented using
    an n-ary product.
    .
    The module "Generics.SOP" is the main module of this library and contains
    more detailed documentation.
    .
    Examples of using this library are provided by the following
    packages:
    .
    * @<https://hackage.haskell.org/package/basic-sop basic-sop>@ basic examples,
    .
    * @<https://hackage.haskell.org/package/pretty-sop pretty-sop>@ generic pretty printing,
    .
    * @<https://hackage.haskell.org/package/lens-sop lens-sop>@ generically computed lenses,
    .
    * @<https://hackage.haskell.org/package/json-sop json-sop>@ generic JSON conversions.
    .
    A detailed description of the ideas behind this library is provided by
    the paper:
    .
    * Edsko de Vries and Andres Löh.
    <http://www.andres-loeh.de/TrueSumsOfProducts True Sums of Products>.
    Workshop on Generic Programming (WGP) 2014.
    .
category: Generics
author: Edsko de Vries <edsko@well-typed.com>, Andres Löh <andres@well-typed.com>
exposed: True
indefinite: False
exposed-modules:
    Generics.SOP Generics.SOP.BasicFunctors Generics.SOP.Classes
    Generics.SOP.Constraint Generics.SOP.Dict Generics.SOP.GGP
    Generics.SOP.Instances Generics.SOP.Metadata Generics.SOP.NP
    Generics.SOP.NS Generics.SOP.Sing Generics.SOP.TH
    Generics.SOP.Type.Metadata Generics.SOP.Universe
abi: 3739529eed84473cc2a68f9b39440988
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/generics-sop-0.3.1.0
library-dirs: /usr/lib/ghc-8.2.2/site-local/generics-sop-0.3.1.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/generics-sop-0.3.1.0
hs-libraries: HSgenerics-sop-0.3.1.0-FKagpR579zL2xkhppkccJi
depends:
    base-4.10.1.0 template-haskell-2.12.0.0 ghc-prim-0.5.1.1
    deepseq-1.4.3.0
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
haddock-interfaces: /usr/share/doc/haskell-generics-sop/html/generics-sop.haddock
haddock-html: /usr/share/doc/haskell-generics-sop/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

