/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public abstract class StrLookup<V> {
    private static final StrLookup<String> NONE_LOOKUP = new MapStrLookup<String>(null);

    public static StrLookup<?> noneLookup() {
        return NONE_LOOKUP;
    }

    private static Properties copyProperties(Properties input) {
        if (input == null) {
            return null;
        }
        Properties output = new Properties();
        Enumeration<?> propertyNames = input.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            output.setProperty(propertyName, input.getProperty(propertyName));
        }
        return output;
    }

    public static StrLookup<String> systemPropertiesLookup() {
        Properties properties;
        Properties systemProperties = null;
        try {
            systemProperties = System.getProperties();
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        Properties propertiesMap = properties = StrLookup.copyProperties(systemProperties);
        return new MapStrLookup<Object>(propertiesMap);
    }

    public static <V> StrLookup<V> mapLookup(Map<String, V> map2) {
        return new MapStrLookup<V>(map2);
    }

    protected StrLookup() {
    }

    public abstract String lookup(String var1);

    static class MapStrLookup<V>
    extends StrLookup<V> {
        private final Map<String, V> map;

        MapStrLookup(Map<String, V> map2) {
            this.map = map2;
        }

        @Override
        public String lookup(String key2) {
            if (this.map == null) {
                return null;
            }
            V obj = this.map.get(key2);
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
    }
}

