/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.api;

public final class Issue {
    private final Throwable throwable;
    private final String message;
    private final Level level;

    public Issue(Throwable throwable, Level level) {
        this.throwable = throwable;
        this.level = level;
        this.message = throwable.getMessage();
    }

    public Issue(String message, Level level, Throwable throwable) {
        this.throwable = throwable;
        this.level = level;
        this.message = message;
    }

    public Issue(String message, Level level) {
        this.message = message;
        this.level = level;
        this.throwable = null;
    }

    public String getMessage() {
        return this.message;
    }

    public Level getLevel() {
        return this.level;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "Issue{message=" + this.message + ", level=" + (Object)((Object)this.level) + '}';
    }

    public static enum Level {
        INFO(100),
        WARNING(200),
        SEVERE(500),
        CRITICAL(1000);

        private final int levelInt;

        private Level(int levelInt) {
            this.levelInt = levelInt;
        }

        public int toInteger() {
            return this.levelInt;
        }
    }
}

