/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.DefaultCppApplication;
import org.gradle.language.cpp.internal.MainExecutableVariant;
import org.gradle.language.cpp.internal.NativeVariant;
import org.gradle.language.cpp.plugins.CppBasePlugin;

@Incubating
public class CppExecutablePlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public CppExecutablePlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        ObjectFactory objectFactory = project.getObjects();
        final CppApplication application = (CppApplication)project.getExtensions().create(CppApplication.class, "executable", DefaultCppApplication.class, new Object[]{"main", project.getLayout(), objectFactory, this.fileOperations, configurations});
        project.getComponents().add((Object)application);
        project.getComponents().add((Object)application.getDebugExecutable());
        project.getComponents().add((Object)application.getReleaseExecutable());
        application.getBaseName().set((Object)project.getName());
        tasks.getByName("assemble").dependsOn(new Object[]{application.getDevelopmentBinary().getInstallDirectory()});
        Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
        Configuration debugRuntimeElements = (Configuration)configurations.maybeCreate("debugRuntimeElements");
        debugRuntimeElements.extendsFrom(new Configuration[]{application.getImplementationDependencies()});
        debugRuntimeElements.setCanBeResolved(false);
        debugRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        debugRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugRuntimeElements.getOutgoing().artifact(application.getDebugExecutable().getExecutableFile());
        Configuration releaseRuntimeElements = (Configuration)configurations.maybeCreate("releaseRuntimeElements");
        releaseRuntimeElements.extendsFrom(new Configuration[]{application.getImplementationDependencies()});
        releaseRuntimeElements.setCanBeResolved(false);
        releaseRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        releaseRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseRuntimeElements.getOutgoing().artifact(application.getReleaseExecutable().getExecutableFile());
        final MainExecutableVariant mainVariant = new MainExecutableVariant();
        NativeVariant debugVariant = new NativeVariant("debug", runtimeUsage, (Set<? extends PublishArtifact>)debugRuntimeElements.getAllArtifacts(), debugRuntimeElements);
        mainVariant.addVariant((SoftwareComponent)debugVariant);
        NativeVariant releaseVariant = new NativeVariant("release", runtimeUsage, (Set<? extends PublishArtifact>)releaseRuntimeElements.getAllArtifacts(), releaseRuntimeElements);
        mainVariant.addVariant((SoftwareComponent)releaseVariant);
        project.getPluginManager().withPlugin("maven-publish", (Action)new Action<AppliedPlugin>(){

            public void execute(AppliedPlugin appliedPlugin) {
                project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

                    public void execute(PublishingExtension extension) {
                        extension.getPublications().create("main", MavenPublication.class, (Action)new Action<MavenPublication>(){

                            public void execute(MavenPublication publication) {
                                publication.setGroupId(project.getGroup().toString());
                                publication.setArtifactId((String)application.getBaseName().get());
                                publication.setVersion(project.getVersion().toString());
                                publication.from((SoftwareComponent)mainVariant);
                                ((MavenPublicationInternal)publication).publishWithOriginalFileName();
                            }
                        });
                        for (final SoftwareComponent child : mainVariant.getVariants()) {
                            extension.getPublications().create(child.getName(), MavenPublication.class, (Action)new Action<MavenPublication>(){

                                public void execute(MavenPublication publication) {
                                    publication.setGroupId(project.getGroup().toString());
                                    publication.setArtifactId((String)application.getBaseName().get() + "_" + child.getName());
                                    publication.setVersion(project.getVersion().toString());
                                    publication.from(child);
                                    ((MavenPublicationInternal)publication).publishWithOriginalFileName();
                                }
                            });
                        }
                    }
                });
            }
        });
    }
}

