/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeSpec<T>
implements Spec<T> {
    private static final Spec<?>[] EMPTY = new Spec[0];
    private final Spec<? super T>[] specs;

    protected CompositeSpec() {
        this.specs = (Spec[])CompositeSpec.uncheckedCast(EMPTY);
    }

    protected CompositeSpec(Spec<? super T> ... specs) {
        this.specs = specs.length == 0 ? (Spec[])CompositeSpec.uncheckedCast(EMPTY) : (Spec[])specs.clone();
    }

    protected CompositeSpec(Iterable<? extends Spec<? super T>> specs) {
        Iterator<Spec<T>> iterator;
        Collection specCollection;
        this.specs = specs instanceof Collection ? ((specCollection = (Collection)CompositeSpec.uncheckedCast(specs)).isEmpty() ? (Spec[])CompositeSpec.uncheckedCast(EMPTY) : (Spec[])CompositeSpec.uncheckedCast(specCollection.toArray(EMPTY))) : (!(iterator = specs.iterator()).hasNext() ? (Spec[])CompositeSpec.uncheckedCast(EMPTY) : (Spec[])CompositeSpec.uncheckedCast(Iterators.toArray(iterator, Spec.class)));
    }

    static <T> T uncheckedCast(Object object) {
        return (T)object;
    }

    Spec<? super T>[] getSpecsArray() {
        return this.specs;
    }

    public List<Spec<? super T>> getSpecs() {
        return Collections.unmodifiableList(Arrays.asList(this.specs));
    }

    public boolean isEmpty() {
        return this.specs.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeSpec that = (CompositeSpec)o;
        return Arrays.equals(this.specs, that.specs);
    }

    public int hashCode() {
        return Arrays.hashCode(this.specs);
    }
}

