/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.FixingLayoutMatcher;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;

public class AllOccurrencesMatcher
extends FixingLayoutMatcher {
    public AllOccurrencesMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/AllOccurrencesMatcher", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/AllOccurrencesMatcher", "<init>"));
        }
        super(pattern, options, hardSeparators);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/AllOccurrencesMatcher", "matchingFragments"));
        }
        FList<TextRange> match2 = super.matchingFragments(name);
        if (!ContainerUtil.isEmpty(match2)) {
            ArrayList<FList<TextRange>> allMatchesReversed = new ArrayList<FList<TextRange>>();
            int lastOffset = 0;
            while (!ContainerUtil.isEmpty(match2)) {
                FList<TextRange> reversedWithAbsoluteOffsets = FList.emptyList();
                for (TextRange r : match2) {
                    reversedWithAbsoluteOffsets = reversedWithAbsoluteOffsets.prepend(r.shiftRight(lastOffset));
                }
                allMatchesReversed.add(reversedWithAbsoluteOffsets);
                lastOffset = ((TextRange)reversedWithAbsoluteOffsets.get(0)).getEndOffset();
                match2 = super.matchingFragments(name.substring(lastOffset));
            }
            match2 = FList.emptyList();
            for (int i = allMatchesReversed.size() - 1; i >= 0; --i) {
                for (TextRange range : (FList)allMatchesReversed.get(i)) {
                    match2 = match2.prepend(range);
                }
            }
        }
        return match2;
    }
}

