/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.ls.DOMWriter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer
implements DOMWriter {
    protected static final boolean DEBUG = false;
    protected final NamespaceSupport fNSBinder = new NamespaceSupport();
    protected final NamespaceSupport fLocalNSBinder = new NamespaceSupport();
    protected final SymbolTable fSymbolTable = new SymbolTable();
    protected String fEmptySymbol;
    protected String fXmlSymbol;
    protected String fXmlnsSymbol;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    private boolean fPreserveSpace;
    private String fEncoding;
    private String fLastEncoding;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        try {
            String string4;
            String string5;
            Object object;
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2 == null || string2.length() == 0 ? string3 : string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl2 = elementState.preserveSpace;
            attributes = this.extractNamespaces(attributes);
            if (string3 == null || string3.length() == 0) {
                if (string2 == null) {
                    throw new SAXException("No rawName and localName is null");
                }
                string3 = string != null && !string.equals("") ? ((object = this.getPrefix(string)) != null && ((String)object).length() > 0 ? (String)object + ":" + string2 : string2) : string2;
                bl = true;
            }
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    this._printer.printSpace();
                    string5 = attributes.getQName(n);
                    if (string5 != null && string5.length() == 0) {
                        string5 = attributes.getLocalName(n);
                        String string6 = attributes.getURI(n);
                        if (!(string6 == null || string6.length() == 0 || string != null && string.length() != 0 && string6.equals(string) || (object = this.getPrefix(string6)) == null || ((String)object).length() <= 0)) {
                            string5 = (String)object + ":" + string5;
                        }
                    }
                    if ((string4 = attributes.getValue(n)) == null) {
                        string4 = "";
                    }
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    if (string5.equals("xml:space")) {
                        bl2 = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            if (this._prefixes != null) {
                object = this._prefixes.keys();
                while (object.hasMoreElements()) {
                    this._printer.printSpace();
                    string4 = (String)object.nextElement();
                    string5 = (String)this._prefixes.get(string4);
                    if (string5.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string, string2, string3, bl2);
            string5 = string2 == null || string2.length() == 0 ? string3 : string + "^" + string2;
            elementState.doCData = this._format.isCDataElement(string5);
            elementState.unescaped = this._format.isNonEscapingElement(string5);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.endElementIO(string, string2, string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string, String string2, String string3) throws IOException {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.afterComment = false;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(string);
            this._printer.indent();
            if (attributeList != null) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    this._printer.printSpace();
                    String string2 = attributeList.getName(n);
                    String string3 = attributeList.getValue(n);
                    if (string3 != null) {
                        this._printer.printText(string2);
                        this._printer.printText("=\"");
                        this.printEscaped(string3);
                        this._printer.printText('\"');
                    }
                    if (string2.equals("xml:space")) {
                        bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            elementState = this.enterElementState(null, null, string, bl);
            elementState.doCData = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    protected void startDocument(String string) throws IOException {
        String string2 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                if (this._format.getEncoding() != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(this._format.getEncoding());
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int n = 0;
                            while (n < 18 + string.length()) {
                                this._printer.printText(" ");
                                ++n;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (string2 != null && string2.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string2, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (string2 != null && string2.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    this._printer.printText(" [");
                    this.printText(string2, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    /*
     * Unable to fully structure code
     */
    protected void serializeElement(Element var1_1) throws IOException {
        block50: {
            this.fLocalNSBinder.reset(this.fSymbolTable);
            this.fLocalNSBinder.pushContext();
            this.fNSBinder.pushContext();
            var9_2 = var1_1.getTagName();
            var6_3 = this.getElementState();
            if (this.isDocumentState()) {
                v0 = this.fDOML1 = var1_1.getLocalName() == null;
                if (!this._started) {
                    this.startDocument(var9_2);
                }
            } else {
                if (var6_3.empty) {
                    this._printer.printText('>');
                }
                if (var6_3.inCData) {
                    this._printer.printText("]]>");
                    var6_3.inCData = false;
                }
                if (this._indenting && !var6_3.preserveSpace && (var6_3.empty || var6_3.afterElement || var6_3.afterComment)) {
                    this._printer.breakLine();
                }
            }
            this.fPreserveSpace = var6_3.preserveSpace;
            var3_4 = var1_1.getAttributes();
            var12_5 = false;
            var11_6 = var1_1.getNamespaceURI();
            var10_7 = var1_1.getPrefix();
            if (var11_6 != null && var10_7 != null && var11_6.length() == 0 && var10_7.length() != 0) {
                var10_7 = null;
                this._printer.printText('<');
                this._printer.printText(var1_1.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(var9_2);
                this._printer.indent();
            }
            if (var11_6 != null) {
                var11_6 = this.fSymbolTable.addSymbol(var11_6);
                v1 = var10_7 = var10_7 == null ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_7);
                if (this.fNSBinder.getURI(var10_7) != var11_6) {
                    this.printNamespaceAttr(var10_7, var11_6);
                    this.fLocalNSBinder.declarePrefix(var10_7, var11_6);
                    this.fNSBinder.declarePrefix(var10_7, var11_6);
                }
            } else {
                var13_8 = var9_2.indexOf(58);
                if (var13_8 > -1) {
                    var14_13 = var9_2.lastIndexOf(58);
                    if (var13_8 != var14_13) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("Element's name is not a QName: " + var9_2, (short)1);
                            var15_15 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        }
                    } else if (this.fDOMErrorHandler != null) {
                        this.modifyDOMError("Element <" + var9_2 + "> does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0);
                        var15_15 = this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                } else {
                    var11_6 = this.fNSBinder.getURI(this.fEmptySymbol);
                    if (var11_6 != null && var11_6.length() > 0) {
                        this.printNamespaceAttr(this.fEmptySymbol, this.fEmptySymbol);
                        this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                        this.fNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                    }
                }
            }
            if (var3_4 == null) break block50;
            var4_18 = 0;
            while (var4_18 < var3_4.getLength()) {
                block52: {
                    block51: {
                        var2_19 = (Attr)var3_4.item(var4_18);
                        var8_21 = var2_19.getValue();
                        var7_20 = var2_19.getNodeName();
                        var11_6 = var2_19.getNamespaceURI();
                        if (var11_6 != null && var11_6.length() == 0) {
                            var11_6 = null;
                            var7_20 = var2_19.getLocalName();
                        }
                        if (var8_21 == null) {
                            var8_21 = this.fEmptySymbol;
                        }
                        if (var11_6 == null) break block51;
                        var10_7 = var2_19.getPrefix();
                        var10_7 = var10_7 == null ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_7);
                        var14_14 = this.fSymbolTable.addSymbol(var2_19.getLocalName());
                        if (var10_7 == this.fXmlnsSymbol) {
                            var11_6 = this.fNSBinder.getURI(var14_14);
                            var13_9 = this.fLocalNSBinder.getURI(var14_14);
                            var8_21 = this.fSymbolTable.addSymbol(var8_21);
                            if ((var11_6 == null || var13_9 == null) && var8_21.length() != 0) {
                                this.printNamespaceAttr(var14_14, var8_21);
                                this.fNSBinder.declarePrefix(var14_14, var8_21);
                                this.fLocalNSBinder.declarePrefix(var14_14, var8_21);
                            }
                        } else if (var14_14 == this.fXmlnsSymbol && var10_7 == this.fEmptySymbol) {
                            var11_6 = this.fNSBinder.getURI(this.fEmptySymbol);
                            var13_10 = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                            var8_21 = this.fSymbolTable.addSymbol(var8_21);
                            if (var13_10 == null) {
                                this.printNamespaceAttr(this.fEmptySymbol, var8_21);
                                this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, var8_21);
                                this.fNSBinder.declarePrefix(this.fEmptySymbol, var8_21);
                            }
                        } else {
                            var11_6 = this.fSymbolTable.addSymbol(var11_6);
                            var15_16 = this.fNSBinder.getURI(var10_7);
                            if (var10_7 == this.fEmptySymbol || var15_16 != var11_6) {
                                var7_20 = var2_19.getNodeName();
                                var16_22 = this.fNSBinder.getPrefix(var11_6);
                                if (var16_22 == null || var16_22 == this.fEmptySymbol) {
                                    if (var10_7 == this.fEmptySymbol) {
                                        var10_7 = "NS" + this.fNamespaceCounter++;
                                    }
                                    this.printNamespaceAttr(var10_7, var11_6);
                                    var8_21 = this.fSymbolTable.addSymbol(var8_21);
                                    this.fLocalNSBinder.declarePrefix(var10_7, var8_21);
                                    this.fNSBinder.declarePrefix(var10_7, var11_6);
                                } else {
                                    var10_7 = var16_22;
                                }
                                var7_20 = var10_7 + ":" + var14_14;
                            }
                            this.printAttribute(var7_20, var8_21 == null ? this.fEmptySymbol : var8_21, var2_19.getSpecified());
                        }
                        break block52;
                    }
                    var14_13 = var7_20.indexOf(58);
                    var15_17 = var7_20.lastIndexOf(58);
                    if (!var7_20.startsWith(this.fXmlnsSymbol)) ** GOTO lbl156
                    if (var14_13 < 0) {
                        var11_6 = this.fNSBinder.getURI(this.fEmptySymbol);
                        var13_11 = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                        if (var13_11 == null) {
                            var8_21 = this.fSymbolTable.addSymbol(var8_21);
                            this.fNSBinder.declarePrefix(this.fEmptySymbol, var8_21);
                            this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, var8_21);
                            this.printAttribute(var7_20, var8_21, var2_19.getSpecified());
                        }
                    } else {
                        if (var14_13 == var15_17) {
                            var10_7 = var7_20.substring(6);
                            v2 = var10_7 = var10_7.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_7);
                            if (var10_7.length() == 0) {
                                if (this.fDOMErrorHandler != null) {
                                    this.modifyDOMError("Namespace declaration syntax is incorrect " + var7_20, (short)1);
                                    var16_23 = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (var8_21.length() == 0 && this.fDOMErrorHandler != null) {
                                this.modifyDOMError("Namespace declaration syntax is incorrect " + var7_20, (short)1);
                                var16_24 = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                            var11_6 = this.fNSBinder.getURI(var10_7);
                            var13_12 = this.fLocalNSBinder.getURI(var10_7);
                            if ((var11_6 == null || var13_12 == null) && var8_21.length() != 0) {
                                var8_21 = this.fSymbolTable.addSymbol(var8_21);
                                this.fNSBinder.declarePrefix(var10_7, var8_21);
                                this.fLocalNSBinder.declarePrefix(var10_7, var8_21);
                            }
                        }
lbl156:
                        // 6 sources

                        if (var14_13 > -1) {
                            if (var14_13 != var15_17) {
                                if (this.fDOMErrorHandler != null) {
                                    this.modifyDOMError("Attribute's name is not a QName: " + var7_20, (short)1);
                                    var16_25 = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (this.fDOMErrorHandler != null) {
                                this.modifyDOMError("Attribute '" + var7_20 + "' does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0);
                                var16_26 = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                            this.printAttribute(var7_20, var8_21, var2_19.getSpecified());
                        } else {
                            this.printAttribute(var7_20, var8_21, var2_19.getSpecified());
                        }
                    }
                }
                ++var4_18;
            }
        }
        if (var1_1.hasChildNodes()) {
            var6_3 = this.enterElementState(null, null, var9_2, this.fPreserveSpace);
            var6_3.doCData = this._format.isCDataElement(var9_2);
            var6_3.unescaped = this._format.isNonEscapingElement(var9_2);
            var5_27 = var1_1.getFirstChild();
            while (var5_27 != null) {
                this.serializeNode(var5_27);
                var5_27 = var5_27.getNextSibling();
            }
            this.fNSBinder.popContext();
            this.endElementIO(null, null, var9_2);
        } else {
            this.fNSBinder.popContext();
            this._printer.unindent();
            this._printer.printText("/>");
            var6_3.afterElement = true;
            var6_3.afterComment = false;
            var6_3.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String string, String string2) throws IOException {
        this._printer.printSpace();
        if (string == this.fEmptySymbol) {
            this._printer.printText(this.fXmlnsSymbol);
        } else {
            this._printer.printText(this.fXmlnsSymbol + ":" + string);
        }
        this._printer.printText("=\"");
        this.printEscaped(string2);
        this._printer.printText('\"');
    }

    private void printAttribute(String string, String string2, boolean bl) throws IOException {
        if (bl || !this.getFeature("discard-default-content")) {
            this._printer.printSpace();
            this._printer.printText(string);
            this._printer.printText("=\"");
            this.printEscaped(string2);
            this._printer.printText('\"');
        }
        if (string.equals("xml:space")) {
            this.fPreserveSpace = string2.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int n) {
        switch (n) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attributes) throws SAXException {
        if (attributes == null) {
            return null;
        }
        int n = attributes.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = attributesImpl.getQName(n2);
            if (string.startsWith("xmlns")) {
                if (string.length() == 5) {
                    this.startPrefixMapping("", attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                } else if (string.charAt(5) == ':') {
                    this.startPrefixMapping(string.substring(6), attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                }
            }
            --n2;
        }
        return attributesImpl;
    }

    private void initFeatures() {
        this.fFeatures.put("normalize-characters", new Boolean(false));
        this.fFeatures.put("split-cdata-sections", new Boolean(true));
        this.fFeatures.put("validation", new Boolean(false));
        this.fFeatures.put("expand-entity-references", new Boolean(false));
        this.fFeatures.put("whitespace-in-element-content", new Boolean(true));
        this.fFeatures.put("discard-default-content", new Boolean(true));
        this.fFeatures.put("format-canonical", new Boolean(false));
        this.fFeatures.put("format-pretty-print", new Boolean(false));
    }

    private void checkAllFeatures() {
        if (this.getFeature("whitespace-in-element-content")) {
            this._format.setPreserveSpace(true);
        } else {
            this._format.setPreserveSpace(false);
        }
    }

    public void setFeature(String string, boolean bl) throws DOMException {
        if (string != null && this.fFeatures.containsKey(string)) {
            if (!this.canSetFeature(string, bl)) {
                throw new DOMException(9, "Feature " + string + " cannot be set as " + bl);
            }
        } else {
            throw new DOMException(8, "Feature " + string + " not found");
        }
        this.fFeatures.put(string, new Boolean(bl));
    }

    public boolean canSetFeature(String string, boolean bl) {
        if (string.equals("normalize-characters") && bl) {
            return false;
        }
        if (string.equals("validation") && bl) {
            return false;
        }
        if (string.equals("whitespace-in-element-content") && !bl) {
            return false;
        }
        if (string.equals("format-canonical") && bl) {
            return false;
        }
        return !string.equals("format-pretty-print") || !bl;
    }

    public boolean getFeature(String string) throws DOMException {
        Boolean bl = (Boolean)this.fFeatures.get(string);
        if (bl == null) {
            throw new DOMException(8, "Feature " + string + " not found");
        }
        return bl;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String string) {
        this._format.setEncoding(string);
        this.fEncoding = this._format.getEncoding();
    }

    public String getLastEncoding() {
        return this.fLastEncoding;
    }

    public String getNewLine() {
        return this._format.getLineSeparator();
    }

    public void setNewLine(String string) {
        this._format.setLineSeparator(string);
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.fDOMErrorHandler = dOMErrorHandler;
    }

    public boolean writeNode(OutputStream outputStream, Node node) throws Exception {
        block7: {
            this.checkAllFeatures();
            try {
                this.setOutputByteStream(outputStream);
                if (node == null) {
                    return false;
                }
                if (node.getNodeType() == 9) {
                    this.serialize((Document)node);
                    break block7;
                }
                if (node.getNodeType() == 11) {
                    this.serialize((DocumentFragment)node);
                    break block7;
                }
                if (node.getNodeType() == 1) {
                    this.serialize((Element)node);
                    break block7;
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
        this.fLastEncoding = this.getEncoding();
        return true;
    }

    public String writeToString(Node node) throws DOMException {
        StringWriter stringWriter;
        block6: {
            this.checkAllFeatures();
            stringWriter = new StringWriter();
            try {
                this.setOutputCharStream(stringWriter);
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 9) {
                    this.serialize((Document)node);
                    break block6;
                }
                if (node.getNodeType() == 11) {
                    this.serialize((DocumentFragment)node);
                    break block6;
                }
                if (node.getNodeType() == 1) {
                    this.serialize((Element)node);
                    break block6;
                }
                return null;
            }
            catch (IOException iOException) {
                throw new DOMException(2, "The resulting string is too long to fit in a DOMString: " + iOException.getMessage());
            }
        }
        this.fLastEncoding = this.getEncoding();
        return stringWriter.toString();
    }

    public boolean reset() {
        super.reset();
        this.fNSBinder.reset(this.fSymbolTable);
        this.fNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
        this.fNamespaceCounter = 1;
        this.fXmlSymbol = this.fSymbolTable.addSymbol("xml");
        this.fXmlnsSymbol = this.fSymbolTable.addSymbol("xmlns");
        this.fEmptySymbol = this.fSymbolTable.addSymbol("");
        return true;
    }
}

