/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.ButtonColumn;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class CacheContentsPanel
extends JPanel {
    public CacheContentsPanel() {
        super(new GridBagLayout());
        MainApplication.worker.submit(() -> {
            this.addToPanel(TMSLayer.getCache(), "TMS");
            this.addToPanel(WMSLayer.getCache(), "WMS");
            this.addToPanel(WMTSLayer.getCache(), "WMTS");
        });
    }

    private void addToPanel(CacheAccess<String, BufferedImageCacheEntry> cache, String name) {
        Long cacheSize = CacheContentsPanel.getCacheSize(cache);
        DefaultTableModel tableModel = CacheContentsPanel.getTableModel(cache);
        GuiHelper.runInEDT(() -> {
            this.add((Component)new JLabel(I18n.tr("{0} cache, total cache size: {1} bytes", name, cacheSize)), GBC.eol().insets(5, 5, 0, 0));
            this.add((Component)new JScrollPane(CacheContentsPanel.getTableForCache(cache, tableModel)), GBC.eol().fill(1));
        });
    }

    private static Long getCacheSize(CacheAccess<String, BufferedImageCacheEntry> cache) {
        ICacheStats stats = cache.getStatistics();
        for (IStats cacheStats : stats.getAuxiliaryCacheStats()) {
            for (IStatElement<?> statElement : cacheStats.getStatElements()) {
                Object val;
                if (!"Data File Length".equals(statElement.getName()) || !((val = statElement.getData()) instanceof Long)) continue;
                return (Long)val;
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public static String[][] getCacheStats(CacheAccess<String, BufferedImageCacheEntry> cache) {
        Set keySet = cache.getCacheControl().getKeySet();
        ConcurrentHashMap<String, int[]> temp = new ConcurrentHashMap<String, int[]>();
        for (Object key : keySet) {
            String[] stringArray = ((String)key).split(":", 2);
            if (stringArray.length == 2) {
                int[] counter = (int[])temp.get(stringArray[0]);
                if (counter == null) {
                    temp.put(stringArray[0], new int[]{1});
                    continue;
                }
                counter[0] = counter[0] + 1;
                continue;
            }
            Logging.warn("Could not parse the key: {0}. No colon found", key);
        }
        ArrayList<Pair> sortedStats = new ArrayList<Pair>();
        for (Map.Entry entry : temp.entrySet()) {
            sortedStats.add(new Pair<String, Integer>((String)entry.getKey(), ((int[])entry.getValue())[0]));
        }
        sortedStats.sort(Comparator.comparing(o -> (Integer)o.b, Comparator.reverseOrder()));
        String[][] ret = new String[sortedStats.size()][3];
        boolean bl = false;
        for (Pair e : sortedStats) {
            void var5_9;
            ret[var5_9] = new String[]{(String)e.a, ((Integer)e.b).toString(), I18n.tr("Clear", new Object[0])};
            ++var5_9;
        }
        return ret;
    }

    private static JTable getTableForCache(final CacheAccess<String, BufferedImageCacheEntry> cache, final TableModel tableModel) {
        final JTable ret = new JTable(tableModel);
        ButtonColumn buttonColumn = new ButtonColumn(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ret.convertRowIndexToModel(ret.getEditingRow());
                tableModel.setValueAt("0", row, 1);
                cache.remove(ret.getValueAt(row, 0).toString() + ':');
            }
        });
        TableColumn tableColumn = ret.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(buttonColumn);
        tableColumn.setCellEditor(buttonColumn);
        return ret;
    }

    private static DefaultTableModel getTableModel(CacheAccess<String, BufferedImageCacheEntry> cache) {
        return new DefaultTableModel(CacheContentsPanel.getCacheStats(cache), new String[]{I18n.tr("Cache name", new Object[0]), I18n.tr("Object Count", new Object[0]), I18n.tr("Clear", new Object[0])}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2;
            }
        };
    }
}

