/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.Centroid;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GroupTree
implements Iterable<Centroid> {
    private long count;
    private int size;
    private int depth;
    private Centroid leaf;
    private GroupTree left;
    private GroupTree right;

    public GroupTree() {
        this.depth = 0;
        this.size = 0;
        this.count = 0;
        this.leaf = null;
        this.right = null;
        this.left = null;
    }

    public GroupTree(Centroid leaf) {
        this.depth = 1;
        this.size = 1;
        this.leaf = leaf;
        this.count = leaf.count();
        this.right = null;
        this.left = null;
    }

    public GroupTree(GroupTree left, GroupTree right) {
        this.left = left;
        this.right = right;
        this.count = left.count + right.count;
        this.size = left.size + right.size;
        this.rebalance();
        this.leaf = this.right.first();
    }

    public void add(Centroid centroid) {
        if (this.size == 0) {
            this.leaf = centroid;
            this.depth = 1;
            this.count = centroid.count();
            this.size = 1;
            return;
        }
        if (this.size == 1) {
            int order = centroid.compareTo(this.leaf);
            if (order < 0) {
                this.left = new GroupTree(centroid);
                this.right = new GroupTree(this.leaf);
            } else if (order > 0) {
                this.left = new GroupTree(this.leaf);
                this.right = new GroupTree(centroid);
                this.leaf = centroid;
            }
        } else if (centroid.compareTo(this.leaf) < 0) {
            this.left.add(centroid);
        } else {
            this.right.add(centroid);
        }
        this.count += (long)centroid.count();
        ++this.size;
        this.depth = Math.max(this.left.depth, this.right.depth) + 1;
        this.rebalance();
    }

    public void move(double x, int count, Centroid v, Iterable<? extends Double> data) {
        if (this.size <= 0) {
            throw new IllegalStateException("Cannot move element of empty tree");
        }
        if (this.size == 1) {
            if (this.leaf != v) {
                throw new IllegalStateException("Cannot move element that is not in tree");
            }
            this.leaf.add(x, count, data);
        } else if (v.compareTo(this.leaf) < 0) {
            this.left.move(x, count, v, data);
        } else {
            this.right.move(x, count, v, data);
        }
        this.count += (long)count;
    }

    private void rebalance() {
        int r;
        int l = this.left.depth();
        if (l > (r = this.right.depth()) + 1) {
            if (this.left.left.depth() > this.left.right.depth()) {
                this.rotate(this.left.left.left, this.left.left.right, this.left.right, this.right);
            } else {
                this.rotate(this.left.left, this.left.right.left, this.left.right.right, this.right);
            }
        } else if (r > l + 1) {
            if (this.right.left.depth() > this.right.right.depth()) {
                this.rotate(this.left, this.right.left.left, this.right.left.right, this.right.right);
            } else {
                this.rotate(this.left, this.right.left, this.right.right.left, this.right.right.right);
            }
        } else {
            this.depth = Math.max(this.left.depth(), this.right.depth()) + 1;
        }
    }

    private void rotate(GroupTree a, GroupTree b, GroupTree c, GroupTree d) {
        this.left = new GroupTree(a, b);
        this.right = new GroupTree(c, d);
        this.count = this.left.count + this.right.count;
        this.size = this.left.size + this.right.size;
        this.depth = Math.max(this.left.depth(), this.right.depth()) + 1;
        this.leaf = this.right.first();
    }

    private int depth() {
        return this.depth;
    }

    public int size() {
        return this.size;
    }

    public int headCount(Centroid base) {
        if (this.size == 0) {
            return 0;
        }
        if (this.left == null) {
            return this.leaf.compareTo(base) < 0 ? 1 : 0;
        }
        if (base.compareTo(this.leaf) < 0) {
            return this.left.headCount(base);
        }
        return this.left.size + this.right.headCount(base);
    }

    public long headSum(Centroid base) {
        if (this.size == 0) {
            return 0L;
        }
        if (this.left == null) {
            return this.leaf.compareTo(base) < 0 ? this.count : 0L;
        }
        if (base.compareTo(this.leaf) <= 0) {
            return this.left.headSum(base);
        }
        return this.left.count + this.right.headSum(base);
    }

    public Centroid first() {
        if (this.size <= 0) {
            throw new IllegalStateException("No first element of empty set");
        }
        if (this.left == null) {
            return this.leaf;
        }
        return this.left.first();
    }

    @Override
    public Iterator<Centroid> iterator() {
        return this.iterator(null);
    }

    private Iterator<Centroid> iterator(final Centroid start) {
        return new Iterator<Centroid>(){
            Centroid end;
            Centroid next;
            Deque<GroupTree> stack = new ArrayDeque<GroupTree>();
            {
                this.push(GroupTree.this, start);
                this.end = new Centroid(0.0, 0, -1);
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.computeNext();
                }
                return this.next != this.end;
            }

            @Override
            public Centroid next() {
                if (this.hasNext()) {
                    Centroid r = this.next;
                    this.next = null;
                    return r;
                }
                throw new NoSuchElementException("Can't iterate past end of data");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Default operation");
            }

            private void push(GroupTree z, Centroid start2) {
                while (z.left != null) {
                    if (start2 == null || start2.compareTo(z.leaf) < 0) {
                        this.stack.push(z.right);
                        z = z.left;
                        continue;
                    }
                    z = z.right;
                }
                if (start2 == null || z.leaf.compareTo(start2) >= 0) {
                    this.stack.push(z);
                }
            }

            protected Centroid computeNext() {
                GroupTree r = this.stack.poll();
                while (r != null && r.left != null) {
                    this.push(r, start);
                    r = this.stack.poll();
                }
                if (r != null) {
                    return r.leaf;
                }
                return this.end;
            }
        };
    }

    public void remove(Centroid base) {
        if (this.size <= 0) {
            throw new IllegalStateException("Cannot remove from empty set");
        }
        if (this.size == 1) {
            if (base.compareTo(this.leaf) != 0) {
                throw new IllegalStateException(String.format("Element %s not found", base));
            }
            this.size = 0;
            this.count = 0;
            this.leaf = null;
        } else if (base.compareTo(this.leaf) < 0) {
            if (this.left.size > 1) {
                this.left.remove(base);
                this.count -= (long)base.count();
                --this.size;
                this.rebalance();
            } else {
                this.size = this.right.size;
                this.count = this.right.count;
                this.depth = this.right.depth;
                this.leaf = this.right.leaf;
                this.left = this.right.left;
                this.right = this.right.right;
            }
        } else if (this.right.size > 1) {
            this.right.remove(base);
            this.leaf = this.right.first();
            this.count -= (long)base.count();
            --this.size;
            this.rebalance();
        } else {
            this.size = this.left.size;
            this.count = this.left.count;
            this.depth = this.left.depth;
            this.leaf = this.left.leaf;
            this.right = this.left.right;
            this.left = this.left.left;
        }
    }

    public Centroid floor(Centroid base) {
        if (this.size == 0) {
            return null;
        }
        if (this.size == 1) {
            return base.compareTo(this.leaf) >= 0 ? this.leaf : null;
        }
        if (base.compareTo(this.leaf) < 0) {
            return this.left.floor(base);
        }
        Centroid floor = this.right.floor(base);
        if (floor == null) {
            floor = this.left.last();
        }
        return floor;
    }

    public Centroid last() {
        if (this.size <= 0) {
            throw new IllegalStateException("Cannot find last element of empty set");
        }
        if (this.size == 1) {
            return this.leaf;
        }
        return this.right.last();
    }

    public Centroid ceiling(Centroid base) {
        if (this.size == 0) {
            return null;
        }
        if (this.size == 1) {
            return base.compareTo(this.leaf) <= 0 ? this.leaf : null;
        }
        if (base.compareTo(this.leaf) < 0) {
            Centroid r = this.left.ceiling(base);
            if (r == null) {
                r = this.right.first();
            }
            return r;
        }
        return this.right.ceiling(base);
    }

    public Iterable<Centroid> tailSet(final Centroid start) {
        return new Iterable<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return GroupTree.this.iterator(start);
            }
        };
    }

    public long sum() {
        return this.count;
    }

    public void checkBalance() {
        if (this.left != null) {
            int r;
            if (Math.abs(this.left.depth() - this.right.depth()) >= 2) {
                throw new IllegalStateException("Imbalanced");
            }
            int l = this.left.depth();
            if (this.depth != Math.max(l, r = this.right.depth()) + 1) {
                throw new IllegalStateException("Depth doesn't match children");
            }
            if (this.size != this.left.size + this.right.size) {
                throw new IllegalStateException("Sizes don't match children");
            }
            if (this.count != this.left.count + this.right.count) {
                throw new IllegalStateException("Counts don't match children");
            }
            if (this.leaf.compareTo(this.right.first()) != 0) {
                throw new IllegalStateException(String.format("Split is wrong %.5f != %.5f or %d != %d", this.leaf.mean(), this.right.first().mean(), this.leaf.id(), this.right.first().id()));
            }
            this.left.checkBalance();
            this.right.checkBalance();
        }
    }

    public void print(int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.printf("| ", new Object[0]);
        }
        int imbalance = Math.abs((this.left != null ? this.left.depth : 1) - (this.right != null ? this.right.depth : 1));
        System.out.printf("%s%s, %d, %d, %d\n", (imbalance > 1 ? "* " : "") + (this.right != null && this.leaf.compareTo(this.right.first()) != 0 ? "+ " : ""), this.leaf, this.size, this.count, this.depth);
        if (this.left != null) {
            this.left.print(depth + 1);
            this.right.print(depth + 1);
        }
    }
}

