/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.File;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.AudioClip;
import tim.prune.data.MediaObject;
import tim.prune.load.AudioFileFilter;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.MediaSorter;
import tim.prune.undo.UndoLoadAudios;

public class AudioLoader
extends GenericFunction {
    private JFileChooser _fileChooser = null;
    private GenericFileFilter _fileFilter = new AudioFileFilter();
    private TreeSet<AudioClip> _fileList = null;

    public AudioLoader(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.loadaudio";
    }

    public void begin() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setMultiSelectionEnabled(true);
            this._fileChooser.setFileSelectionMode(2);
            this._fileChooser.setFileFilter(this._fileFilter);
            this._fileChooser.setDialogTitle(I18nManager.getText(this.getNameKey()));
            String string = Config.getConfigString("prune.photodirectory");
            if (string == null) {
                string = Config.getConfigString("prune.trackdirectory");
            }
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        if (this._fileChooser.showOpenDialog(this._parentFrame) == 0) {
            this._fileList = new TreeSet<MediaObject>(new MediaSorter());
            this.processFileList(this._fileChooser.getSelectedFiles());
            int n = this._fileList.size();
            if (n == 0) {
                this._app.showErrorMessage(this.getNameKey(), "error.audioload.nofilesfound");
            } else {
                UndoLoadAudios undoLoadAudios = new UndoLoadAudios(n);
                this._app.getTrackInfo().addAudios(this._fileList);
                this._app.completeFunction(undoLoadAudios, I18nManager.getText("confirm.audioload"));
                UpdateMessageBroker.informSubscribers();
            }
        }
    }

    private void processFileList(File[] fileArray) {
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (file.exists() && file.canRead()) {
                if (file.isFile()) {
                    if (this._fileFilter.accept(file)) {
                        this._fileList.add(new AudioClip(file));
                    }
                } else if (file.isDirectory()) {
                    this.processFileList(file.listFiles());
                }
            }
            ++n2;
        }
    }
}

