/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupRunner
implements StartupActivity,
DumbAware {
    public static final int DELAY_MILLIS = 200;

    public void runActivity(@NotNull Project project) {
        ProjectStartupTaskManager projectStartupTaskManager;
        if (project == null) {
            ProjectStartupRunner.$$$reportNull$$$0(0);
        }
        if ((projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project)).isEmpty()) {
            return;
        }
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                projectStartupTaskManager.delete(settings.getUniqueID());
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (existingId != null) {
                    projectStartupTaskManager.rename(existingId, settings);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(2);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/execution/startup/ProjectStartupRunner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ProjectStartupRunner.scheduleRunActivities(project);
    }

    private static void scheduleRunActivities(@NotNull Project project) {
        if (project == null) {
            ProjectStartupRunner.$$$reportNull$$$0(1);
        }
        JobScheduler.getScheduler().schedule(() -> {
            if (project == null) {
                ProjectStartupRunner.$$$reportNull$$$0(3);
            }
            if (!((StartupManagerEx)StartupManager.getInstance((Project)project)).postStartupActivityPassed()) {
                ProjectStartupRunner.scheduleRunActivities(project);
            } else {
                ProjectStartupRunner.runActivities(project);
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    private static void runActivities(Project project) {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project);
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(projectStartupTaskManager.getLocalConfigurations());
        configurations.addAll(projectStartupTaskManager.getSharedConfigurations());
        ApplicationManager.getApplication().invokeLater(() -> {
            long pause = 0L;
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            for (RunnerAndConfigurationSettings configuration : configurations) {
                if (!ProjectStartupRunner.canBeRun(configuration)) {
                    ProjectStartupRunner.showNotification(project, "Run Configuration '" + configuration.getName() + "' can not be started with 'Run' action.", MessageType.ERROR);
                    return;
                }
                try {
                    alarm.addRequest((Runnable)new MyExecutor(executor, configuration, alarm), pause);
                }
                catch (ExecutionException e) {
                    ProjectStartupRunner.showNotification(project, e.getMessage(), MessageType.ERROR);
                }
                pause = 300L;
            }
        });
    }

    private static void showNotification(Project project, String text, MessageType type) {
        ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  " + text, type).notify(project);
    }

    public static boolean canBeRun(@NotNull RunnerAndConfigurationSettings configuration) {
        if (configuration == null) {
            ProjectStartupRunner.$$$reportNull$$$0(2);
        }
        return RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, (RunProfile)configuration.getConfiguration()) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/startup/ProjectStartupRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleRunActivities";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeRun";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$scheduleRunActivities$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyExecutor
    implements Runnable {
        public static final int ATTEMPTS = 10;
        private final ExecutionEnvironment myEnvironment;
        @NotNull
        private final Alarm myAlarm;
        private final Project myProject;
        private int myCnt;
        private static final long PAUSE = 300L;
        private final String myName;

        public MyExecutor(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Alarm alarm) throws ExecutionException {
            if (executor == null) {
                MyExecutor.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                MyExecutor.$$$reportNull$$$0(1);
            }
            if (alarm == null) {
                MyExecutor.$$$reportNull$$$0(2);
            }
            this.myCnt = 10;
            this.myName = configuration.getName();
            this.myProject = configuration.getConfiguration().getProject();
            this.myAlarm = alarm;
            this.myEnvironment = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)configuration).contentToReuse(null).dataContext(null).activeTarget().build();
        }

        @Override
        public void run() {
            if (ExecutorRegistry.getInstance().isStarting(this.myEnvironment)) {
                if (this.myCnt <= 0) {
                    ProjectStartupRunner.showNotification(this.myProject, "'" + this.myName + "' not started after " + 10 + " attempts.", MessageType.ERROR);
                    return;
                }
                --this.myCnt;
                this.myAlarm.addRequest((Runnable)this, 300L);
            }
            ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  starting '" + this.myName + "'", MessageType.INFO).notify(this.myProject);
            ProgramRunnerUtil.executeConfiguration(this.myEnvironment, true, true);
            if (this.myAlarm.isEmpty()) {
                Disposer.dispose((Disposable)this.myAlarm);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "alarm";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/startup/ProjectStartupRunner$MyExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

