/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchProjectViewPane
extends ProjectViewPane {
    public static final String ID = "Scratches";

    public static boolean isScratchesMergedIntoProjectTab() {
        return (Registry.is((String)"ide.scratch.in.project.view") || PlatformUtils.isDatabaseIDE()) && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public ScratchProjectViewPane(Project project) {
        super(project);
    }

    @Override
    public String getTitle() {
        return ID;
    }

    @Override
    public Icon getIcon() {
        return super.getIcon();
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new MyTreeStructure(this.myProject);
    }

    @Override
    public int getWeight() {
        return 11;
    }

    @Override
    @NotNull
    protected BaseProjectTreeBuilder createBuilder(DefaultTreeModel treeModel) {
        ProjectTreeBuilder builder = new ProjectTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure){

            @Override
            protected ProjectViewPsiTreeChangeListener createPsiTreeChangeListener(Project project) {
                return new ProjectTreeBuilder.ProjectTreeBuilderPsiListener(project){

                    @Override
                    protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
                        VirtualFile virtualFile;
                        VirtualFile virtualFile2 = virtualFile = parent instanceof PsiFileSystemItem ? ((PsiFileSystemItem)parent).getVirtualFile() : null;
                        if (virtualFile != null && virtualFile.isValid() && ScratchFileService.getInstance().getRootType(virtualFile) != null) {
                            this.queueUpdateFrom(parent, true);
                        }
                    }
                };
            }
        };
        for (RootType rootId : RootType.getAllRootIds()) {
            if (rootId.isHidden()) continue;
            rootId.registerTreeUpdater(this.myProject, (Disposable)builder, () -> ((ProjectTreeBuilder)builder).queueUpdate());
        }
        ProjectTreeBuilder projectTreeBuilder = builder;
        if (projectTreeBuilder == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(1);
        }
        return projectTreeBuilder;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            @Override
            protected boolean canSelect(PsiFileSystemItem file2) {
                VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
                if (vFile == null || !vFile.isValid()) {
                    return false;
                }
                if (!vFile.isInLocalFileSystem()) {
                    return false;
                }
                return ScratchFileService.getInstance().getRootType(vFile) != null;
            }

            @Override
            public String toString() {
                return ScratchProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return ScratchProjectViewPane.this.getId();
            }

            public float getWeight() {
                return ScratchProjectViewPane.this.getWeight();
            }
        };
    }

    @Override
    @Nullable
    protected PsiElement getPSIElement(@Nullable Object element) {
        return element instanceof RootType ? ScratchProjectViewPane.getDirectory(this.myProject, (RootType)element) : super.getPSIElement(element);
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull Project project, @NotNull RootType rootId) {
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(2);
        }
        if (rootId == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(3);
        }
        String path = ScratchFileService.getInstance().getRootPath(rootId);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile == null ? null : PsiManager.getInstance((Project)project).findDirectory(virtualFile);
    }

    @Override
    public boolean isInitiallyVisible() {
        return !ScratchProjectViewPane.isScratchesMergedIntoProjectTab();
    }

    @NotNull
    public static AbstractTreeNode createRootNode(@NotNull Project project, @NotNull ViewSettings settings) {
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(5);
        }
        MyProjectNode myProjectNode = new MyProjectNode(project, settings);
        if (myProjectNode == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(6);
        }
        return myProjectNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRootNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPsiNode
    extends BasePsiNode<PsiFileSystemItem>
    implements NavigatableWithText {
        private final RootType myRootType;

        MyPsiNode(@NotNull Project project, RootType rootId, @NotNull PsiFileSystemItem value) {
            if (project == null) {
                MyPsiNode.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MyPsiNode.$$$reportNull$$$0(1);
            }
            super(project, value, ViewSettings.DEFAULT);
            this.myRootType = rootId;
        }

        public boolean isAlwaysLeaf() {
            PsiFileSystemItem value = (PsiFileSystemItem)this.getValue();
            return value != null && !value.isDirectory();
        }

        @Override
        @Nullable
        protected Collection<AbstractTreeNode> getChildrenImpl() {
            if (this.isAlwaysLeaf()) {
                return Collections.emptyList();
            }
            return (Collection)ReadAction.compute(() -> {
                final PsiFileSystemItem value = (PsiFileSystemItem)this.getValue();
                if (value == null || !value.isValid()) {
                    return Collections.emptyList();
                }
                final ArrayList list2 = ContainerUtil.newArrayList();
                value.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                    public boolean execute(@NotNull PsiFileSystemItem element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!myRootType.isIgnored(value.getProject(), element.getVirtualFile())) {
                            list2.add(new MyPsiNode(value.getProject(), myRootType, element));
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchProjectViewPane$MyPsiNode$1", "execute"));
                    }
                });
                return list2;
            });
        }

        @Override
        protected void updateImpl(PresentationData data) {
            VirtualFile virtualFile;
            PsiFileSystemItem value = (PsiFileSystemItem)this.getValue();
            VirtualFile virtualFile2 = virtualFile = value == null ? null : value.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                data.setIcon(value.getIcon(0));
                data.setPresentableText((String)ObjectUtils.chooseNotNull((Object)this.myRootType.substituteName(value.getProject(), virtualFile), (Object)virtualFile.getName()));
            }
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return null;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            PsiFileSystemItem value;
            if (file2 == null) {
                MyPsiNode.$$$reportNull$$$0(2);
            }
            if (!((value = (PsiFileSystemItem)this.getValue()) instanceof PsiDirectory)) {
                return super.contains(file2);
            }
            PsiDirectory dir = (PsiDirectory)value;
            return VfsUtilCore.isAncestor((VirtualFile)dir.getVirtualFile(), (VirtualFile)file2, (boolean)false) && !FileTypeRegistry.getInstance().isFileIgnored(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyPsiNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRootNode
    extends ProjectViewNode<RootType> {
        MyRootNode(Project project, RootType type, ViewSettings settings) {
            super(project, (Object)type, settings);
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            return ScratchFileService.getInstance().getRootType(file2) == this.getValue();
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            RootType rootType = (RootType)this.getValue();
            PsiDirectory directory2 = this.getDirectory();
            if (directory2 == null) {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    MyRootNode.$$$reportNull$$$0(1);
                }
                return list2;
            }
            Collection<AbstractTreeNode> collection = new MyPsiNode(directory2.getProject(), rootType, (PsiFileSystemItem)directory2).getChildren();
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            return collection;
        }

        PsiDirectory getDirectory() {
            return ScratchProjectViewPane.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(AllIcons.Nodes.Folder);
            presentation.setPresentableText(((RootType)this.getValue()).getDisplayName());
        }

        public boolean canRepresent(Object element) {
            return Comparing.equal((Object)this.getDirectory(), (Object)element);
        }

        public boolean isEmpty() {
            PsiDirectory directory2 = this.getDirectory();
            if (directory2 == null) {
                return true;
            }
            RootType rootType = (RootType)ObjectUtils.notNull((Object)this.getValue());
            Project project = directory2.getProject();
            return directory2.processChildren(element -> rootType.isIgnored(project, element.getVirtualFile()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyProjectNode
    extends ProjectViewNode<String> {
        MyProjectNode(Project project, ViewSettings settings) {
            super(project, (Object)"Scratches and Consoles", settings);
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProjectNode.$$$reportNull$$$0(0);
            }
            return file2.getFileType() == ScratchFileType.INSTANCE;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList list2 = ContainerUtil.newArrayList();
            for (RootType rootId : RootType.getAllRootIds()) {
                MyRootNode e;
                if (rootId.isHidden() || (e = new MyRootNode(this.getProject(), rootId, this.getSettings())).isEmpty()) continue;
                list2.add(e);
            }
            ArrayList arrayList = list2;
            if (arrayList == null) {
                MyProjectNode.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        protected void update(PresentationData presentation) {
            presentation.setPresentableText((String)this.getValue());
            presentation.setIcon(AllIcons.General.ProjectTab);
        }

        public boolean canRepresent(Object element) {
            VirtualFile virtualFile;
            PsiElement item = element instanceof PsiElement ? (PsiElement)element : null;
            VirtualFile virtualFile2 = virtualFile = item == null ? null : PsiUtilCore.getVirtualFile((PsiElement)item);
            if (virtualFile == null) {
                return false;
            }
            return Comparing.equal((String)virtualFile.getPath(), (String)FileUtil.toSystemIndependentName((String)PathManager.getScratchPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTreeStructure
    extends ProjectTreeStructure {
        MyTreeStructure(Project project) {
            super(project, ScratchProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
            return ScratchProjectViewPane.createRootNode(project, settings);
        }

        @Override
        @Nullable
        public List<TreeStructureProvider> getProviders() {
            return null;
        }
    }
}

