/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.util.BuildNumber;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckForUpdateResult {
    private final UpdateStrategy.State myState;
    private final BuildInfo myNewBuild;
    private final UpdateChannel myUpdatedChannel;
    private final Exception myError;

    public CheckForUpdateResult(@Nullable BuildInfo newBuild, @Nullable UpdateChannel updatedChannel) {
        this.myState = UpdateStrategy.State.LOADED;
        this.myNewBuild = newBuild;
        this.myUpdatedChannel = updatedChannel;
        this.myError = null;
    }

    public CheckForUpdateResult(@NotNull UpdateStrategy.State state2, @Nullable Exception e) {
        if (state2 == null) {
            CheckForUpdateResult.$$$reportNull$$$0(0);
        }
        this.myState = state2;
        this.myNewBuild = null;
        this.myUpdatedChannel = null;
        this.myError = e;
    }

    @NotNull
    public UpdateStrategy.State getState() {
        UpdateStrategy.State state2 = this.myState;
        if (state2 == null) {
            CheckForUpdateResult.$$$reportNull$$$0(1);
        }
        return state2;
    }

    @Nullable
    public BuildInfo getNewBuild() {
        return this.myNewBuild;
    }

    @Nullable
    public PatchInfo findPatchForBuild(@NotNull BuildNumber build) {
        if (build == null) {
            CheckForUpdateResult.$$$reportNull$$$0(2);
        }
        List patches = this.myNewBuild != null ? this.myNewBuild.getPatches() : Collections.emptyList();
        return patches.stream().filter(p -> {
            if (build == null) {
                CheckForUpdateResult.$$$reportNull$$$0(3);
            }
            return p.isAvailable() && p.getFromBuild().compareTo(build) == 0;
        }).findFirst().orElse(null);
    }

    @Nullable
    public UpdateChannel getUpdatedChannel() {
        return this.myUpdatedChannel;
    }

    @Nullable
    public Exception getError() {
        return this.myError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPatchForBuild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findPatchForBuild$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

