/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PositionUtil;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.SimpleColoredComponentLinkMouseListener;
import com.intellij.vcs.log.ui.table.Selection;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableController {
    @NotNull
    private final VcsLogGraphTable myTable;
    @NotNull
    private final AbstractVcsLogUi myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final GraphCellPainter myGraphCellPainter;
    @NotNull
    private final GraphCommitCellRenderer myCommitRenderer;

    public GraphTableController(@NotNull VcsLogGraphTable table, @NotNull AbstractVcsLogUi ui, @NotNull VcsLogData logData, @NotNull GraphCellPainter graphCellPainter, @NotNull GraphCommitCellRenderer commitRenderer) {
        if (table == null) {
            GraphTableController.$$$reportNull$$$0(0);
        }
        if (ui == null) {
            GraphTableController.$$$reportNull$$$0(1);
        }
        if (logData == null) {
            GraphTableController.$$$reportNull$$$0(2);
        }
        if (graphCellPainter == null) {
            GraphTableController.$$$reportNull$$$0(3);
        }
        if (commitRenderer == null) {
            GraphTableController.$$$reportNull$$$0(4);
        }
        this.myTable = table;
        this.myUi = ui;
        this.myLogData = logData;
        this.myGraphCellPainter = graphCellPainter;
        this.myCommitRenderer = commitRenderer;
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        table.addMouseMotionListener(mouseAdapter);
        table.addMouseListener(mouseAdapter);
    }

    @Nullable
    PrintElement findPrintElement(@NotNull MouseEvent e) {
        int row;
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(5);
        }
        if ((row = this.myTable.rowAtPoint(e.getPoint())) >= 0 && row < this.myTable.getRowCount()) {
            return this.findPrintElement(row, e);
        }
        return null;
    }

    @Nullable
    private PrintElement findPrintElement(int row, @NotNull MouseEvent e) {
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(6);
        }
        Point point = this.calcPoint4Graph(e.getPoint());
        Collection printElements = this.myTable.getVisibleGraph().getRowInfo(row).getPrintElements();
        return this.myGraphCellPainter.getElementUnderCursor(printElements, point.x, point.y);
    }

    private void performGraphAction(@Nullable PrintElement printElement, @NotNull MouseEvent e, @NotNull GraphAction.Type actionType) {
        boolean isClickOnGraphElement;
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(7);
        }
        if (actionType == null) {
            GraphTableController.$$$reportNull$$$0(8);
        }
        boolean bl = isClickOnGraphElement = actionType == GraphAction.Type.MOUSE_CLICK && printElement != null;
        if (isClickOnGraphElement) {
            GraphTableController.triggerElementClick(printElement);
        }
        Selection previousSelection = this.myTable.getSelection();
        GraphAnswer answer = this.myTable.getVisibleGraph().getActionController().performAction((GraphAction)new GraphAction.GraphActionImpl(printElement, actionType));
        this.handleGraphAnswer((GraphAnswer<Integer>)answer, isClickOnGraphElement, previousSelection, e);
    }

    public void handleGraphAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange, @Nullable Selection previousSelection, @Nullable MouseEvent e) {
        if (dataCouldChange) {
            this.myTable.getModel().fireTableDataChanged();
            if (previousSelection != null) {
                previousSelection.restore(this.myTable.getVisibleGraph(), answer == null || answer.getCommitToJump() != null && answer.doJump(), false);
            }
        }
        this.myTable.repaint();
        if (answer == null) {
            return;
        }
        if (answer.getCursorToSet() != null) {
            this.myTable.setCursor(answer.getCursorToSet());
        }
        if (answer.getCommitToJump() != null) {
            Integer row = this.myTable.getModel().getVisiblePack().getVisibleGraph().getVisibleRowIndex(answer.getCommitToJump());
            if (row != null && row >= 0 && answer.doJump()) {
                this.myTable.jumpToRow(row);
                return;
            }
            if (e != null) {
                this.showToolTip(this.getArrowTooltipText((Integer)answer.getCommitToJump(), row), e);
            }
        }
    }

    @NotNull
    private Point calcPoint4Graph(@NotNull Point clickPoint) {
        TableColumn column;
        if (clickPoint == null) {
            GraphTableController.$$$reportNull$$$0(9);
        }
        int width = 0;
        for (int i = 0; i < this.myTable.getColumnModel().getColumnCount() && (column = this.myTable.getColumnModel().getColumn(i)).getModelIndex() != 1; ++i) {
            width += column.getWidth();
        }
        Point point = new Point(clickPoint.x - width, PositionUtil.getYInsideRow(clickPoint, this.myTable.getRowHeight()));
        if (point == null) {
            GraphTableController.$$$reportNull$$$0(10);
        }
        return point;
    }

    @NotNull
    private String getArrowTooltipText(int commit, @Nullable Integer row) {
        VcsShortCommitDetails details = row != null && row >= 0 ? this.myTable.getModel().getShortDetails(row) : this.myLogData.getMiniDetailsGetter().getCommitData((Integer)commit, Collections.singleton(commit));
        String balloonText = "";
        if (details instanceof LoadingDetails) {
            CommitId commitId = this.myLogData.getCommitId(commit);
            if (commitId != null) {
                balloonText = "Jump to commit " + commitId.getHash().toShortString();
                if (this.myUi.isMultipleRoots()) {
                    balloonText = balloonText + " in " + commitId.getRoot().getName();
                }
            }
        } else {
            balloonText = "Jump to <b>\"" + StringUtil.shortenTextWithEllipsis((String)details.getSubject(), (int)50, (int)0, (String)"...") + "\"</b> by " + VcsUserUtil.getShortPresentation(details.getAuthor()) + CommitPanel.formatDateTime(details.getAuthorTime());
        }
        String string = balloonText;
        if (string == null) {
            GraphTableController.$$$reportNull$$$0(11);
        }
        return string;
    }

    private void showToolTip(@NotNull String text, @NotNull MouseEvent e) {
        if (text == null) {
            GraphTableController.$$$reportNull$$$0(12);
        }
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(13);
        }
        Point point = new Point(e.getX() + 5, e.getY());
        JEditorPane tipComponent = IdeTooltipManager.initPane(text, new HintHint((Component)((Object)this.myTable), point).setAwtTooltip(true), null);
        IdeTooltip tooltip = new IdeTooltip((Component)((Object)this.myTable), point, (JComponent)new Wrapper((JComponent)tipComponent), new Object[0]).setPreferredPosition(Balloon.Position.atRight);
        IdeTooltipManager.getInstance().show(tooltip, false);
    }

    private void showOrHideCommitTooltip(int row, int column, @NotNull MouseEvent e) {
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(14);
        }
        if (!this.showTooltip(row, column, e.getPoint(), false) && IdeTooltipManager.getInstance().hasCurrent()) {
            IdeTooltipManager.getInstance().hideCurrent(e);
        }
    }

    private boolean showTooltip(int row, int column, @NotNull Point point, boolean now) {
        JComponent tipComponent;
        if (point == null) {
            GraphTableController.$$$reportNull$$$0(15);
        }
        if ((tipComponent = this.myCommitRenderer.getTooltip(this.myTable.getValueAt(row, this.myTable.convertColumnIndexToView(column)), this.calcPoint4Graph(point), row)) != null) {
            this.myTable.getExpandableItemsHandler().setEnabled(false);
            IdeTooltip tooltip = new IdeTooltip((Component)((Object)this.myTable), point, (JComponent)new Wrapper(tipComponent), new Object[0]).setPreferredPosition(Balloon.Position.below);
            IdeTooltipManager.getInstance().show(tooltip, now);
            return true;
        }
        return false;
    }

    public void showTooltip(int row) {
        Point point = new Point(this.getColumnLeftXCoordinate(this.myTable.convertColumnIndexToView(1)) + this.myCommitRenderer.getTooltipXCoordinate(row), row * this.myTable.getRowHeight() + this.myTable.getRowHeight() / 2);
        this.showTooltip(row, 1, point, true);
    }

    private void performRootColumnAction() {
        VcsLogUiProperties properties = this.myUi.getProperties();
        if (this.myUi.isMultipleRoots() && properties.exists(MainVcsLogUiProperties.SHOW_ROOT_NAMES)) {
            VcsLogUtil.triggerUsage("RootColumnClick");
            properties.set(MainVcsLogUiProperties.SHOW_ROOT_NAMES, properties.get(MainVcsLogUiProperties.SHOW_ROOT_NAMES) == false);
        }
    }

    private static void triggerElementClick(@NotNull PrintElement printElement) {
        if (printElement == null) {
            GraphTableController.$$$reportNull$$$0(16);
        }
        if (printElement instanceof NodePrintElement) {
            VcsLogUtil.triggerUsage("GraphNodeClick");
        } else if (printElement instanceof EdgePrintElement && ((EdgePrintElement)printElement).hasArrow()) {
            VcsLogUtil.triggerUsage("GraphArrowClick");
        }
    }

    protected int getColumnLeftXCoordinate(int viewColumnIndex) {
        int x = 0;
        for (int i = 0; i < viewColumnIndex; ++i) {
            x += this.myTable.getColumnModel().getColumn(i).getWidth();
        }
        return x;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphCellPainter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitRenderer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickPoint";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/GraphTableController";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/GraphTableController";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPoint4Graph";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPrintElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performGraphAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcPoint4Graph";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showToolTip";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showOrHideCommitTooltip";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "triggerElementClick";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private static final int BORDER_THICKNESS = 3;
        @NotNull
        private final TableLinkMouseListener myLinkListener = new SimpleColoredComponentLinkMouseListener();

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row;
            if (this.myLinkListener.onClick(e, e.getClickCount())) {
                return;
            }
            int c = GraphTableController.this.myTable.columnAtPoint(e.getPoint());
            int column = GraphTableController.this.myTable.convertColumnIndexToModel(c);
            if (e.getClickCount() == 2) {
                boolean useLeftBorder;
                int commitColumnIndex = GraphTableController.this.myTable.convertColumnIndexToView(1);
                boolean bl = useLeftBorder = c > commitColumnIndex;
                if ((useLeftBorder ? this.isOnLeftBorder(e, c) : this.isOnRightBorder(e, c)) && (column == 2 || column == 3)) {
                    GraphTableController.this.myTable.resetColumnWidth(column);
                } else {
                    int c2 = GraphTableController.this.myTable.columnAtPoint(new Point(e.getPoint().x + (useLeftBorder ? 1 : -1) * JBUI.scale((int)3), e.getPoint().y));
                    int column2 = GraphTableController.this.myTable.convertColumnIndexToModel(c2);
                    if ((useLeftBorder ? this.isOnLeftBorder(e, c2) : this.isOnRightBorder(e, c2)) && (column2 == 2 || column2 == 3)) {
                        GraphTableController.this.myTable.resetColumnWidth(column2);
                    }
                }
            }
            if ((row = GraphTableController.this.myTable.rowAtPoint(e.getPoint())) >= 0 && row < GraphTableController.this.myTable.getRowCount() && e.getClickCount() == 1) {
                PrintElement printElement;
                if (column == 0) {
                    GraphTableController.this.performRootColumnAction();
                } else if (column == 1 && (printElement = GraphTableController.this.findPrintElement(row, e)) != null) {
                    GraphTableController.this.performGraphAction(printElement, e, GraphAction.Type.MOUSE_CLICK);
                }
            }
        }

        public boolean isOnLeftBorder(@NotNull MouseEvent e, int column) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(0);
            }
            return Math.abs(GraphTableController.this.getColumnLeftXCoordinate(column) - e.getPoint().x) <= JBUI.scale((int)3);
        }

        public boolean isOnRightBorder(@NotNull MouseEvent e, int column) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(1);
            }
            return Math.abs(GraphTableController.this.getColumnLeftXCoordinate(column) + GraphTableController.this.myTable.getColumnModel().getColumn(column).getWidth() - e.getPoint().x) <= JBUI.scale((int)3);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (GraphTableController.this.myTable.isResizingColumns()) {
                return;
            }
            GraphTableController.this.myTable.getExpandableItemsHandler().setEnabled(true);
            if (this.myLinkListener.getTagAt(e) != null) {
                GraphTableController.this.myTable.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            int row = GraphTableController.this.myTable.rowAtPoint(e.getPoint());
            if (row >= 0 && row < GraphTableController.this.myTable.getRowCount()) {
                int column = GraphTableController.this.myTable.convertColumnIndexToModel(GraphTableController.this.myTable.columnAtPoint(e.getPoint()));
                if (column == 0) {
                    GraphTableController.this.myTable.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                if (column == 1) {
                    PrintElement printElement = GraphTableController.this.findPrintElement(row, e);
                    GraphTableController.this.performGraphAction(printElement, e, GraphAction.Type.MOUSE_OVER);
                    if (printElement == null) {
                        GraphTableController.this.showOrHideCommitTooltip(row, column, e);
                    }
                    return;
                }
            }
            GraphTableController.this.myTable.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GraphTableController.this.myTable.getExpandableItemsHandler().setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/log/ui/table/GraphTableController$MyMouseAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnLeftBorder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnRightBorder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

