/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.InstructionBuilder;
import com.jetbrains.python.codeInsight.controlflow.PyTypeAssertionEvaluator;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionComponent;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyComprehensionIfComponent;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyConstantExpressionEvaluator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyControlFlowBuilder
extends PyRecursiveElementVisitor {
    private final ControlFlowBuilder myBuilder = new ControlFlowBuilder();

    public ControlFlow buildControlFlow(@NotNull ScopeOwner owner) {
        if (owner == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(0);
        }
        return this.myBuilder.build(this, (PsiElement)owner);
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        this.myBuilder.startNode(node);
        this.visitParameterListExpressions(node.getParameterList());
        this.visitDecorators(node.getDecoratorList());
        PyAnnotation annotation = node.getAnnotation();
        if (annotation != null) {
            annotation.accept(this);
        }
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode(instruction);
        this.myBuilder.checkPending(instruction);
    }

    @Override
    public void visitPyDecoratorList(PyDecoratorList node) {
    }

    private void visitDecorators(PyDecoratorList list2) {
        if (list2 != null) {
            for (PyDecorator decorator : list2.getDecorators()) {
                decorator.accept(this);
            }
        }
    }

    private void visitParameterListExpressions(PyParameterList parameterList) {
        ParamHelper.walkDownParamArray(parameterList.getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                PyAnnotation annotation;
                PyExpression defaultValue = param.getDefaultValue();
                if (defaultValue != null) {
                    defaultValue.accept(PyControlFlowBuilder.this);
                }
                if ((annotation = param.getAnnotation()) != null) {
                    annotation.accept(PyControlFlowBuilder.this);
                }
            }
        });
    }

    @Override
    public void visitPyClass(PyClass node) {
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression element : node.getSuperClassExpressions()) {
            element.accept(this);
        }
        this.visitDecorators(node.getDecoratorList());
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode(instruction);
        this.myBuilder.checkPending(instruction);
    }

    @Override
    public void visitPyStatement(PyStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        super.visitPyStatement(node);
    }

    @Override
    public void visitPyElement(PyElement node) {
        if (node instanceof PsiNamedElement && !(node instanceof PyKeywordArgument)) {
            this.myBuilder.startNode((PsiElement)node);
            this.myBuilder.addNode(ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getName(), ReadWriteInstruction.ACCESS.WRITE));
        }
        super.visitPyElement(node);
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        PyExpression callee = node.getCallee();
        String repr = PyUtil.getReadableRepr((PsiElement)callee, true);
        if (callee != null && ("sys.exit".equals(repr) || "self.fail".equals(repr))) {
            callee.accept(this);
            for (PyExpression expression : node.getArguments()) {
                expression.accept(this);
            }
            this.abruptFlow((PsiElement)node);
        } else {
            super.visitPyCallExpression(node);
        }
        if (node.isCalleeText("assertIsInstance")) {
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
            node.accept(assertionEvaluator);
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
        }
    }

    @Override
    public void visitPySubscriptionExpression(PySubscriptionExpression node) {
        this.myBuilder.startNode((PsiElement)node);
        node.getOperand().accept(this);
        PyExpression expression = node.getIndexExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        PyExpression qualifier = node.getQualifier();
        if (qualifier != null) {
            qualifier.accept(this);
            return;
        }
        if (PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) != null) {
            return;
        }
        ReadWriteInstruction.ACCESS access = PyAugAssignmentStatementNavigator.getStatementByTarget((PsiElement)node) != null ? ReadWriteInstruction.ACCESS.READWRITE : ReadWriteInstruction.ACCESS.READ;
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getName(), access);
        this.myBuilder.addNode(readWriteInstruction);
        this.myBuilder.checkPending(readWriteInstruction);
    }

    @Override
    public void visitPyBoolLiteralExpression(PyBoolLiteralExpression node) {
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getText(), ReadWriteInstruction.ACCESS.READ);
        this.myBuilder.addNode(readWriteInstruction);
        this.myBuilder.checkPending(readWriteInstruction);
    }

    @Override
    public void visitPyNoneLiteralExpression(PyNoneLiteralExpression node) {
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getText(), ReadWriteInstruction.ACCESS.READ);
        this.myBuilder.addNode(readWriteInstruction);
        this.myBuilder.checkPending(readWriteInstruction);
    }

    @Override
    public void visitPyTypeDeclarationStatement(PyTypeDeclarationStatement node) {
        this.myBuilder.startNode(node);
        PyAnnotation annotation = node.getAnnotation();
        if (annotation != null) {
            annotation.accept(this);
        }
        node.getTarget().accept(this);
    }

    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        PyAnnotation annotation;
        this.myBuilder.startNode(node);
        PyExpression value = node.getAssignedValue();
        if (value != null) {
            value.accept(this);
        }
        if ((annotation = node.getAnnotation()) != null) {
            annotation.accept(this);
        }
        for (PyExpression expression : node.getRawTargets()) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyExpression value = node.getValue();
        if (value != null) {
            value.accept(this);
        }
        node.getTarget().accept(this);
    }

    @Override
    public void visitPyTargetExpression(PyTargetExpression node) {
        PyExpression qualifier;
        QualifiedName qName = node.asQualifiedName();
        if (qName != null) {
            ReadWriteInstruction instruction = ReadWriteInstruction.newInstruction(this.myBuilder, node, qName.toString(), ReadWriteInstruction.ACCESS.WRITE);
            this.myBuilder.addNode(instruction);
            this.myBuilder.checkPending(instruction);
        }
        if ((qualifier = node.getQualifier()) != null) {
            qualifier.accept(this);
        }
    }

    @Override
    public void visitPyNamedParameter(PyNamedParameter node) {
        PyExpression defaultValue = node.getDefaultValue();
        if (defaultValue != null) {
            defaultValue.accept(this);
        }
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNode(instruction);
        this.myBuilder.checkPending(instruction);
    }

    @Override
    public void visitPyImportStatement(PyImportStatement node) {
        this.visitPyImportStatementBase(node);
    }

    @Override
    public void visitPyFromImportStatement(PyFromImportStatement node) {
        this.visitPyImportStatementBase(node);
        PyStarImportElement starImportElement = node.getStarImportElement();
        if (starImportElement != null) {
            starImportElement.accept(this);
        }
    }

    @Override
    public void visitPyStarImportElement(PyStarImportElement node) {
        this.myBuilder.startNode((PsiElement)node);
    }

    private void visitPyImportStatementBase(PyImportStatementBase node) {
        this.myBuilder.startNode((PsiElement)node);
        for (PyImportElement importElement : node.getImportElements()) {
            ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, importElement, importElement.getVisibleName());
            this.myBuilder.addNode(instruction);
            this.myBuilder.checkPending(instruction);
        }
    }

    private Instruction getPrevInstruction(PyElement condition) {
        Ref head = new Ref((Object)this.myBuilder.prevInstruction);
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)pendingScope, (boolean)false)) {
                head.set((Object)instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        return (Instruction)head.get();
    }

    @Override
    public void visitPyConditionalExpression(PyConditionalExpression node) {
        this.myBuilder.startNode((PsiElement)node);
        PyExpression condition = node.getCondition();
        PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
        if (condition != null) {
            condition.accept(this);
            condition.accept(assertionEvaluator);
        }
        Instruction branchingPoint = this.myBuilder.prevInstruction;
        PyExpression truePart = node.getTruePart();
        PyExpression falsePart = node.getFalsePart();
        if (truePart != null) {
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
            truePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        if (falsePart != null) {
            this.myBuilder.prevInstruction = branchingPoint;
            falsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
    }

    @Override
    public void visitPyIfStatement(PyIfStatement node) {
        PyElsePart elseBranch;
        Instruction lastBranchingPoint;
        this.myBuilder.startNode((PsiElement)node);
        PyIfPart ifPart = node.getIfPart();
        PyExpression condition = ifPart.getCondition();
        PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
        if (condition != null) {
            condition.accept(this);
            condition.accept(assertionEvaluator);
        }
        PyExpression lastCondition = condition;
        this.myBuilder.prevInstruction = lastBranchingPoint = this.getPrevInstruction(condition);
        PyStatementList thenStatements = ifPart.getStatementList();
        this.myBuilder.startConditionalNode((PsiElement)thenStatements, (PsiElement)condition, true);
        InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
        thenStatements.accept(this);
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)thenStatements, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addPendingEdge((PsiElement)node, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        for (PyIfPart part : node.getElifParts()) {
            this.myBuilder.prevInstruction = lastBranchingPoint;
            this.myBuilder.startConditionalNode((PsiElement)part, (PsiElement)lastCondition, false);
            condition = part.getCondition();
            assertionEvaluator = new PyTypeAssertionEvaluator();
            if (condition != null) {
                lastCondition = condition;
                lastBranchingPoint = this.getPrevInstruction(lastCondition);
                condition.accept(this);
                condition.accept(assertionEvaluator);
            }
            this.myBuilder.prevInstruction = this.getPrevInstruction(lastCondition);
            this.myBuilder.startConditionalNode((PsiElement)part, (PsiElement)lastCondition, true);
            PyStatementList statementList = part.getStatementList();
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
            statementList.accept(this);
            this.myBuilder.processPending((pendingScope, instruction) -> {
                if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)part, (PsiElement)pendingScope, (boolean)false)) {
                    this.myBuilder.addPendingEdge((PsiElement)node, instruction);
                } else {
                    this.myBuilder.addPendingEdge(pendingScope, instruction);
                }
            });
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyTypeAssertionEvaluator negativeAssertionEvaluator = new PyTypeAssertionEvaluator(false);
        PyExpression ifCondition = ifPart.getCondition();
        if (ifCondition != null) {
            ifCondition.accept(negativeAssertionEvaluator);
        }
        if ((elseBranch = node.getElsePart()) != null) {
            this.myBuilder.prevInstruction = lastBranchingPoint;
            this.myBuilder.startConditionalNode((PsiElement)elseBranch, (PsiElement)lastCondition, false);
            InstructionBuilder.addAssertInstructions(this.myBuilder, negativeAssertionEvaluator);
            elseBranch.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        } else {
            this.myBuilder.prevInstruction = lastBranchingPoint;
            InstructionBuilder.addAssertInstructions(this.myBuilder, negativeAssertionEvaluator);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
    }

    @Override
    public void visitPyBinaryExpression(PyBinaryExpression node) {
        PyElementType operator = node.getOperator();
        if (operator == PyTokenTypes.AND_KEYWORD || operator == PyTokenTypes.OR_KEYWORD) {
            PyExpression right;
            this.myBuilder.startNode((PsiElement)node);
            PyExpression left = node.getLeftExpression();
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator(operator == PyTokenTypes.AND_KEYWORD);
            if (left != null) {
                left.accept(this);
                left.accept(assertionEvaluator);
            }
            if ((right = node.getRightExpression()) != null) {
                InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
                right.accept(this);
                this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
            }
        } else {
            super.visitPyBinaryExpression(node);
        }
    }

    @Override
    public void visitPyWhileStatement(PyWhileStatement node) {
        Instruction instruction = this.myBuilder.startNode((PsiElement)node);
        PyWhilePart whilePart = node.getWhilePart();
        PyExpression condition = whilePart.getCondition();
        boolean isStaticallyTrue = false;
        if (condition != null) {
            condition.accept(this);
            isStaticallyTrue = PyConstantExpressionEvaluator.evaluateBoolean(condition, false);
        }
        Instruction head = this.myBuilder.prevInstruction;
        PyElsePart elsePart = node.getElsePart();
        if (elsePart == null && !isStaticallyTrue) {
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyStatementList list2 = whilePart.getStatementList();
        this.myBuilder.startConditionalNode((PsiElement)list2, (PsiElement)condition, true);
        list2.accept(this);
        if (this.myBuilder.prevInstruction != null) {
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, instruction);
        }
        this.myBuilder.checkPending(instruction);
        this.myBuilder.prevInstruction = head;
        if (elsePart != null && !isStaticallyTrue) {
            elsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyForStatement(PyForStatement node) {
        Instruction body;
        this.myBuilder.startNode(node);
        PyForPart forPart = node.getForPart();
        PyExpression source = forPart.getSource();
        if (source != null) {
            source.accept(this);
        }
        Instruction head = this.myBuilder.prevInstruction;
        PyElsePart elsePart = node.getElsePart();
        if (elsePart == null) {
            this.myBuilder.addPendingEdge(node, this.myBuilder.prevInstruction);
        }
        PyStatementList list2 = forPart.getStatementList();
        PyExpression target2 = forPart.getTarget();
        if (target2 != null) {
            body = this.myBuilder.startNode((PsiElement)target2);
            target2.accept(this);
        } else {
            body = this.myBuilder.startNode((PsiElement)list2);
        }
        list2.accept(this);
        if (this.myBuilder.prevInstruction != null) {
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, body);
            this.myBuilder.addPendingEdge((PsiElement)list2, this.myBuilder.prevInstruction);
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)list2, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addEdge(instruction, body);
                this.myBuilder.addPendingEdge((PsiElement)list2, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.prevInstruction = head;
        if (elsePart != null) {
            elsePart.accept(this);
            this.myBuilder.addPendingEdge(node, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyBreakStatement(PyBreakStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyLoopStatement loop = node.getLoopStatement();
        if (loop != null) {
            this.myBuilder.addPendingEdge((PsiElement)loop, this.myBuilder.prevInstruction);
        } else {
            this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyContinueStatement(PyContinueStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyLoopStatement loop = node.getLoopStatement();
        if (loop != null) {
            Instruction instruction = this.myBuilder.findInstructionByElement((PsiElement)loop);
            if (instruction != null) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, instruction);
            } else {
                this.myBuilder.addPendingEdge(null, null);
            }
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyYieldExpression(PyYieldExpression node) {
        this.myBuilder.startNode((PsiElement)node);
        PyExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyRaiseStatement(PyRaiseStatement node) {
        PyExpression[] expressions;
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression expression : expressions = node.getExpressions()) {
            expression.accept(this);
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            PsiElement pendingElement = instruction.getElement();
            if (pendingElement != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingElement, (boolean)false)) {
                this.myBuilder.addEdge(null, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyReturnStatement(PyReturnStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        PyExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
        this.abruptFlow((PsiElement)node);
    }

    @Override
    public void visitPyTryExceptStatement(PyTryExceptStatement node) {
        Instruction finallyFailInstruction;
        this.myBuilder.startNode((PsiElement)node);
        PyTryPart tryPart = node.getTryPart();
        this.myBuilder.startNode((PsiElement)tryPart);
        tryPart.accept(this);
        PyElsePart elsePart = node.getElsePart();
        if (elsePart != null) {
            this.myBuilder.startNode((PsiElement)elsePart);
            elsePart.accept(this);
        }
        this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        List<Instruction> exceptInstructions = PyControlFlowBuilder.emptyMutableList();
        List<Object> pendingBackup = PyControlFlowBuilder.emptyMutableList();
        for (PyExceptPart exceptPart : node.getExceptParts()) {
            pendingBackup.addAll(this.myBuilder.pending);
            this.myBuilder.pending = PyControlFlowBuilder.emptyMutableList();
            this.myBuilder.flowAbrupted();
            Instruction exceptInstruction = this.myBuilder.startNode(exceptPart);
            exceptPart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
            exceptInstructions.add(exceptInstruction);
        }
        for (Pair pair : pendingBackup) {
            this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
        }
        ArrayList normalExits = new ArrayList();
        PyFinallyPart finallyPart = node.getFinallyPart();
        if (finallyPart != null) {
            this.myBuilder.processPending((pendingScope, instruction) -> {
                PsiElement pendingElement = instruction.getElement();
                if (pendingElement != null) {
                    boolean isPending;
                    boolean bl = isPending = PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingElement, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)finallyPart, (PsiElement)pendingElement, (boolean)false);
                    if (isPending && pendingScope != null) {
                        normalExits.add(instruction);
                    } else {
                        this.myBuilder.addPendingEdge(pendingScope, instruction);
                    }
                }
            });
        }
        if (finallyPart != null) {
            this.myBuilder.flowAbrupted();
            finallyFailInstruction = this.myBuilder.startNode((PsiElement)finallyPart);
            finallyPart.accept(this);
            this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
            this.myBuilder.flowAbrupted();
        } else {
            finallyFailInstruction = null;
        }
        for (Instruction instruction2 : this.myBuilder.instructions) {
            PsiElement e = instruction2.getElement();
            if (e == null || !PyControlFlowBuilder.canRaiseExceptions(instruction2)) continue;
            if (PsiTreeUtil.getParentOfType((PsiElement)e, PyTryPart.class, (boolean)false) == tryPart) {
                for (Instruction inst : exceptInstructions) {
                    this.myBuilder.addEdge(instruction2, inst);
                }
                if (finallyPart != null) {
                    this.myBuilder.addEdge(instruction2, finallyFailInstruction);
                }
            }
            if (finallyPart == null) continue;
            for (PyExceptPart exceptPart : node.getExceptParts()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)exceptPart, (PsiElement)e, (boolean)false)) continue;
                this.myBuilder.addEdge(instruction2, finallyFailInstruction);
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)elsePart, (PsiElement)e, (boolean)false)) continue;
            this.myBuilder.addEdge(instruction2, finallyFailInstruction);
        }
        if (finallyPart != null) {
            Instruction finallyInstruction;
            this.myBuilder.processPending((pendingScope, instruction) -> {
                PsiElement e = instruction.getElement();
                if (e != null) {
                    if (PsiTreeUtil.isAncestor((PsiElement)finallyPart, (PsiElement)e, (boolean)false)) {
                        this.myBuilder.addPendingEdge(null, instruction);
                    } else if (pendingScope == null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)e, (boolean)false)) {
                        this.myBuilder.addEdge(instruction, finallyFailInstruction);
                    } else {
                        this.myBuilder.addPendingEdge(pendingScope, instruction);
                    }
                }
            });
            if (!normalExits.isEmpty()) {
                pendingBackup = PyControlFlowBuilder.emptyMutableList();
                pendingBackup.addAll(this.myBuilder.pending);
                this.myBuilder.pending = PyControlFlowBuilder.emptyMutableList();
                this.myBuilder.flowAbrupted();
                Instruction finallySuccessInstruction = this.myBuilder.startNode((PsiElement)finallyPart);
                finallyPart.accept(this);
                for (Pair pair : pendingBackup) {
                    this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
                }
                finallyInstruction = finallySuccessInstruction;
            } else {
                finallyInstruction = finallyFailInstruction;
            }
            for (Instruction instr : normalExits) {
                this.myBuilder.addEdge(instr, finallyInstruction);
            }
        }
    }

    private static <T> List<T> emptyMutableList() {
        return new ArrayList();
    }

    @Override
    public void visitPyComprehensionElement(PyComprehensionElement node) {
        PyExpression prevCondition = null;
        this.myBuilder.startNode(node);
        ArrayList<Instruction> iterators = new ArrayList<Instruction>();
        for (PyComprehensionComponent component : node.getComponents()) {
            PyExpression condition;
            PyComprehensionComponent c;
            if (component instanceof PyComprehensionForComponent) {
                c = (PyComprehensionForComponent)component;
                PyExpression iteratedList = c.getIteratedList();
                PyExpression iteratorVariable = c.getIteratorVariable();
                if (prevCondition != null) {
                    this.myBuilder.startConditionalNode((PsiElement)iteratedList, (PsiElement)prevCondition, true);
                    prevCondition = null;
                } else {
                    this.myBuilder.startNode((PsiElement)iteratedList);
                }
                iteratedList.accept(this);
                for (Instruction i : iterators) {
                    this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
                }
                this.myBuilder.addPendingEdge(node, this.myBuilder.prevInstruction);
                Instruction iterator = this.myBuilder.startNode((PsiElement)iteratorVariable);
                iteratorVariable.accept(this);
                iterators.add(iterator);
                continue;
            }
            if (!(component instanceof PyComprehensionIfComponent) || (condition = (c = (PyComprehensionIfComponent)component).getTest()) == null) continue;
            if (prevCondition != null) {
                this.myBuilder.startConditionalNode((PsiElement)condition, (PsiElement)prevCondition, true);
            } else {
                this.myBuilder.startNode((PsiElement)condition);
            }
            PyTypeAssertionEvaluator assertionEvaluator = new PyTypeAssertionEvaluator();
            condition.accept(this);
            condition.accept(assertionEvaluator);
            InstructionBuilder.addAssertInstructions(this.myBuilder, assertionEvaluator);
            prevCondition = condition;
            for (Instruction i : iterators) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
            }
            this.myBuilder.addPendingEdge(node, this.myBuilder.prevInstruction);
        }
        PyExpression result2 = node.getResultExpression();
        if (result2 != null) {
            if (prevCondition != null) {
                this.myBuilder.startConditionalNode((PsiElement)result2, (PsiElement)prevCondition, true);
            } else {
                this.myBuilder.startNode((PsiElement)result2);
            }
            result2.accept(this);
            for (Instruction i : iterators) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
            }
        }
    }

    @Override
    public void visitPyAssertStatement(PyAssertStatement node) {
        this.myBuilder.startNode((PsiElement)node);
        super.visitPyAssertStatement(node);
        PyExpression[] args = node.getArguments();
        if (args.length >= 1 && !PyConstantExpressionEvaluator.evaluateBoolean(args[0], true)) {
            this.abruptFlow((PsiElement)node);
            return;
        }
        PyTypeAssertionEvaluator evaluator = new PyTypeAssertionEvaluator();
        node.acceptChildren(evaluator);
        InstructionBuilder.addAssertInstructions(this.myBuilder, evaluator);
    }

    @Override
    public void visitPyLambdaExpression(PyLambdaExpression node) {
        this.myBuilder.startNode((PsiElement)node);
        this.visitParameterListExpressions(node.getParameterList());
    }

    @Override
    public void visitPyWithStatement(PyWithStatement node) {
        super.visitPyWithStatement(node);
        this.myBuilder.processPending((pendingScope, instruction) -> {
            PsiElement element = instruction.getElement();
            if (element != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)element, (boolean)true) && PsiTreeUtil.getParentOfType((PsiElement)element, PyRaiseStatement.class) != null) {
                this.myBuilder.addPendingEdge(node, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
    }

    private void abruptFlow(PsiElement node) {
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addPendingEdge(null, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        this.myBuilder.flowAbrupted();
    }

    private static boolean canRaiseExceptions(Instruction instruction) {
        if (instruction instanceof ReadWriteInstruction) {
            return true;
        }
        return !PsiTreeUtil.instanceOf((Object)instruction.getElement(), (Class[])new Class[]{PyStatementList.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder", "buildControlFlow"));
    }
}

