/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.EpydocString;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.NumpyDocString;
import com.jetbrains.python.documentation.docstrings.PlainDocString;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.documentation.docstrings.SphinxDocString;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import com.jetbrains.python.toolbox.Substring;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringUtil {
    private DocStringUtil() {
    }

    @Nullable
    public static String getDocStringValue(@NotNull PyDocStringOwner owner) {
        if (owner == null) {
            DocStringUtil.$$$reportNull$$$0(0);
        }
        return PyPsiUtils.strValue(owner.getDocStringExpression());
    }

    @NotNull
    public static StructuredDocString parse(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(1);
        }
        StructuredDocString structuredDocString = DocStringUtil.parse(text, null);
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(2);
        }
        return structuredDocString;
    }

    @NotNull
    public static StructuredDocString parse(@NotNull String text, @Nullable PsiElement anchor) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(3);
        }
        DocStringFormat format = DocStringUtil.guessDocStringFormat(text, anchor);
        StructuredDocString structuredDocString = DocStringUtil.parseDocStringContent(format, text);
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(4);
        }
        return structuredDocString;
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull PyStringLiteralExpression stringLiteral) {
        if (stringLiteral == null) {
            DocStringUtil.$$$reportNull$$$0(5);
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocString(DocStringUtil.guessDocStringFormat(stringLiteral.getStringValue(), stringLiteral), stringLiteral);
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(6);
        }
        return structuredDocString;
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull PyStringLiteralExpression stringLiteral) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(7);
        }
        if (stringLiteral == null) {
            DocStringUtil.$$$reportNull$$$0(8);
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocString(format, stringLiteral.getStringNodes().get(0));
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(9);
        }
        return structuredDocString;
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull ASTNode node) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(10);
        }
        if (node == null) {
            DocStringUtil.$$$reportNull$$$0(11);
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocString(format, node.getText());
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(12);
        }
        return structuredDocString;
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull String stringText) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(13);
        }
        if (stringText == null) {
            DocStringUtil.$$$reportNull$$$0(14);
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocString(format, DocStringUtil.stripPrefixAndQuotes(stringText));
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(15);
        }
        return structuredDocString;
    }

    @NotNull
    public static StructuredDocString parseDocStringContent(@NotNull DocStringFormat format, @NotNull String stringContent) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(16);
        }
        if (stringContent == null) {
            DocStringUtil.$$$reportNull$$$0(17);
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocString(format, new Substring(stringContent));
        if (structuredDocString == null) {
            DocStringUtil.$$$reportNull$$$0(18);
        }
        return structuredDocString;
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull Substring content) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(19);
        }
        if (content == null) {
            DocStringUtil.$$$reportNull$$$0(20);
        }
        switch (format) {
            case REST: {
                SphinxDocString sphinxDocString = new SphinxDocString(content);
                if (sphinxDocString == null) {
                    DocStringUtil.$$$reportNull$$$0(21);
                }
                return sphinxDocString;
            }
            case EPYTEXT: {
                EpydocString epydocString = new EpydocString(content);
                if (epydocString == null) {
                    DocStringUtil.$$$reportNull$$$0(22);
                }
                return epydocString;
            }
            case GOOGLE: {
                GoogleCodeStyleDocString googleCodeStyleDocString = new GoogleCodeStyleDocString(content);
                if (googleCodeStyleDocString == null) {
                    DocStringUtil.$$$reportNull$$$0(23);
                }
                return googleCodeStyleDocString;
            }
            case NUMPY: {
                NumpyDocString numpyDocString = new NumpyDocString(content);
                if (numpyDocString == null) {
                    DocStringUtil.$$$reportNull$$$0(24);
                }
                return numpyDocString;
            }
        }
        PlainDocString plainDocString = new PlainDocString(content);
        if (plainDocString == null) {
            DocStringUtil.$$$reportNull$$$0(25);
        }
        return plainDocString;
    }

    @NotNull
    private static Substring stripPrefixAndQuotes(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(26);
        }
        TextRange contentRange = PyStringLiteralExpressionImpl.getNodeTextRange(text);
        Substring substring = new Substring(text, contentRange.getStartOffset(), contentRange.getEndOffset());
        if (substring == null) {
            DocStringUtil.$$$reportNull$$$0(27);
        }
        return substring;
    }

    @NotNull
    public static DocStringFormat guessDocStringFormat(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(28);
        }
        if (DocStringUtil.isLikeEpydocDocString(text)) {
            DocStringFormat docStringFormat = DocStringFormat.EPYTEXT;
            if (docStringFormat == null) {
                DocStringUtil.$$$reportNull$$$0(29);
            }
            return docStringFormat;
        }
        if (DocStringUtil.isLikeSphinxDocString(text)) {
            DocStringFormat docStringFormat = DocStringFormat.REST;
            if (docStringFormat == null) {
                DocStringUtil.$$$reportNull$$$0(30);
            }
            return docStringFormat;
        }
        if (DocStringUtil.isLikeNumpyDocstring(text)) {
            DocStringFormat docStringFormat = DocStringFormat.NUMPY;
            if (docStringFormat == null) {
                DocStringUtil.$$$reportNull$$$0(31);
            }
            return docStringFormat;
        }
        if (DocStringUtil.isLikeGoogleDocString(text)) {
            DocStringFormat docStringFormat = DocStringFormat.GOOGLE;
            if (docStringFormat == null) {
                DocStringUtil.$$$reportNull$$$0(32);
            }
            return docStringFormat;
        }
        DocStringFormat docStringFormat = DocStringFormat.PLAIN;
        if (docStringFormat == null) {
            DocStringUtil.$$$reportNull$$$0(33);
        }
        return docStringFormat;
    }

    @NotNull
    public static DocStringFormat guessDocStringFormat(@NotNull String text, @Nullable PsiElement anchor) {
        DocStringFormat guessed;
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(34);
        }
        DocStringFormat docStringFormat = (guessed = DocStringUtil.guessDocStringFormat(text)) == DocStringFormat.PLAIN && anchor != null ? DocStringUtil.getConfiguredDocStringFormatOrPlain(anchor) : guessed;
        if (docStringFormat == null) {
            DocStringUtil.$$$reportNull$$$0(35);
        }
        return docStringFormat;
    }

    @Nullable
    public static DocStringFormat getConfiguredDocStringFormat(@NotNull PsiElement anchor) {
        Module module2;
        if (anchor == null) {
            DocStringUtil.$$$reportNull$$$0(36);
        }
        if ((module2 = DocStringUtil.getModuleForElement(anchor)) == null) {
            return null;
        }
        PyDocumentationSettings settings = PyDocumentationSettings.getInstance(module2);
        return settings.getFormatForFile(anchor.getContainingFile());
    }

    @NotNull
    public static DocStringFormat getConfiguredDocStringFormatOrPlain(@NotNull PsiElement anchor) {
        if (anchor == null) {
            DocStringUtil.$$$reportNull$$$0(37);
        }
        DocStringFormat docStringFormat = (DocStringFormat)((Object)ObjectUtils.chooseNotNull((Object)((Object)DocStringUtil.getConfiguredDocStringFormat(anchor)), (Object)((Object)DocStringFormat.PLAIN)));
        if (docStringFormat == null) {
            DocStringUtil.$$$reportNull$$$0(38);
        }
        return docStringFormat;
    }

    public static boolean isLikeSphinxDocString(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(39);
        }
        return text.contains(":param ") || text.contains(":return:") || text.contains(":returns:") || text.contains(":rtype") || text.contains(":type");
    }

    public static boolean isLikeEpydocDocString(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(40);
        }
        return text.contains("@param ") || text.contains("@return:") || text.contains("@rtype") || text.contains("@type");
    }

    public static boolean isLikeGoogleDocString(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(41);
        }
        for (String title : StringUtil.findMatches((String)text, (Pattern)GoogleCodeStyleDocString.SECTION_HEADER, (int)1)) {
            if (!SectionBasedDocString.isValidSectionTitle(title)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikeNumpyDocstring(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(42);
        }
        String[] lines2 = StringUtil.splitByLines((String)text, (boolean)false);
        for (int i = 0; i < lines2.length; ++i) {
            String lineBefore;
            String line = lines2[i];
            if (!NumpyDocString.SECTION_HEADER.matcher(line).matches() || i <= 0 || !SectionBasedDocString.SECTION_NAMES.contains((lineBefore = lines2[i - 1]).trim().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PyStringLiteralExpression findDocStringExpression(@Nullable PyElement parent) {
        if (parent != null) {
            PsiElement seeker = PyPsiUtils.getNextNonCommentSibling(parent.getFirstChild(), false);
            if (seeker instanceof PyExpressionStatement) {
                seeker = PyPsiUtils.getNextNonCommentSibling(seeker.getFirstChild(), false);
            }
            if (seeker instanceof PyStringLiteralExpression) {
                return (PyStringLiteralExpression)seeker;
            }
        }
        return null;
    }

    @Nullable
    public static StructuredDocString getStructuredDocString(@NotNull PyDocStringOwner owner) {
        String value;
        if (owner == null) {
            DocStringUtil.$$$reportNull$$$0(43);
        }
        return (value = owner.getDocStringValue()) == null ? null : DocStringUtil.parse(value, (PsiElement)owner);
    }

    @Nullable
    public static PyStringLiteralExpression getParentDefinitionDocString(@NotNull PsiElement element) {
        PyStringLiteralExpression docString;
        PyDocStringOwner docStringOwner;
        if (element == null) {
            DocStringUtil.$$$reportNull$$$0(44);
        }
        if ((docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class)) != null && PsiTreeUtil.isAncestor((PsiElement)(docString = docStringOwner.getDocStringExpression()), (PsiElement)element, (boolean)false)) {
            return docString;
        }
        return null;
    }

    public static boolean isDocStringExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            DocStringUtil.$$$reportNull$$$0(45);
        }
        if (DocStringUtil.getParentDefinitionDocString((PsiElement)expression) == expression) {
            return true;
        }
        if (expression instanceof PyStringLiteralExpression) {
            return DocStringUtil.isVariableDocString((PyStringLiteralExpression)expression);
        }
        return false;
    }

    @Nullable
    public static String getAttributeDocComment(@NotNull PyTargetExpression attr) {
        PyAssignmentStatement assignment;
        PsiElement prevSibling;
        if (attr == null) {
            DocStringUtil.$$$reportNull$$$0(46);
        }
        if (attr.getParent() instanceof PyAssignmentStatement && (prevSibling = PyPsiUtils.getPrevNonWhitespaceSibling(assignment = (PyAssignmentStatement)attr.getParent())) instanceof PsiComment && prevSibling.getText().startsWith("#:")) {
            return prevSibling.getText().substring(2);
        }
        return null;
    }

    public static boolean isVariableDocString(@NotNull PyStringLiteralExpression expr) {
        PsiElement parent;
        if (expr == null) {
            DocStringUtil.$$$reportNull$$$0(47);
        }
        if (!((parent = expr.getParent()) instanceof PyExpressionStatement)) {
            return false;
        }
        PsiElement prevElement = PyPsiUtils.getPrevNonCommentSibling(parent, true);
        if (prevElement instanceof PyAssignmentStatement) {
            if (expr.getText().contains("type:")) {
                return true;
            }
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)prevElement;
            ScopeOwner scope = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)prevElement, ScopeOwner.class);
            if (scope instanceof PyClass || scope instanceof PyFile) {
                return true;
            }
            if (scope instanceof PyFunction) {
                for (PyExpression target2 : assignmentStatement.getTargets()) {
                    if (!PyUtil.isInstanceAttribute(target2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean ensureNotPlainDocstringFormat(@NotNull PsiElement anchor) {
        Module module2;
        if (anchor == null) {
            DocStringUtil.$$$reportNull$$$0(48);
        }
        if ((module2 = DocStringUtil.getModuleForElement(anchor)) == null) {
            return false;
        }
        return DocStringUtil.ensureNotPlainDocstringFormatForFile(anchor.getContainingFile(), module2);
    }

    @Nullable
    private static Module getModuleForElement(@NotNull PsiElement element) {
        Module module2;
        if (element == null) {
            DocStringUtil.$$$reportNull$$$0(49);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null) {
            return module2;
        }
        return (Module)ArrayUtil.getFirstElement((Object[])ModuleManager.getInstance((Project)element.getProject()).getModules());
    }

    private static boolean ensureNotPlainDocstringFormatForFile(@NotNull PsiFile file2, @NotNull Module module2) {
        PyDocumentationSettings settings;
        if (file2 == null) {
            DocStringUtil.$$$reportNull$$$0(50);
        }
        if (module2 == null) {
            DocStringUtil.$$$reportNull$$$0(51);
        }
        if ((settings = PyDocumentationSettings.getInstance(module2)).isPlain(file2)) {
            List<String> values = DocStringFormat.ALL_NAMES_BUT_PLAIN;
            int i = Messages.showChooseDialog((String)"Docstring format:", (String)"Select Docstring Type", (String[])ArrayUtil.toStringArray(values), (String)values.get(0), null);
            if (i < 0) {
                return false;
            }
            settings.setFormat(DocStringFormat.fromNameOrPlain(values.get(i)));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 3: 
            case 26: 
            case 28: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringContent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 36: 
            case 37: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDocString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDocStringContent";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "stripPrefixAndQuotes";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDocStringFormat";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredDocStringFormatOrPlain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocStringValue";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 38: {
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseDocString";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseDocStringContent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefixAndQuotes";
                break;
            }
            case 28: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "guessDocStringFormat";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredDocStringFormat";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredDocStringFormatOrPlain";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isLikeSphinxDocString";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isLikeEpydocDocString";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isLikeGoogleDocString";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isLikeNumpyDocstring";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getStructuredDocString";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getParentDefinitionDocString";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isDocStringExpression";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDocComment";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isVariableDocString";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "ensureNotPlainDocstringFormat";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForElement";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "ensureNotPlainDocstringFormatForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

