/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamWrapper
extends OutputStream {
    private final OutputStream myOutputStream;
    private final ReadWriteStatistics myStatistics;

    public OutputStreamWrapper(OutputStream outputStream, ReadWriteStatistics statistics) {
        this.myOutputStream = outputStream;
        this.myStatistics = statistics;
    }

    @Override
    public void write(int b) throws IOException {
        this.myOutputStream.write(b);
        this.myStatistics.send(1L);
    }

    @Override
    public void close() throws IOException {
        this.myOutputStream.close();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.myOutputStream.write(b);
        this.myStatistics.send((long)b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.myOutputStream.write(b, off, len);
        this.myStatistics.send((long)len);
    }

    @Override
    public void flush() throws IOException {
        this.myOutputStream.flush();
    }
}

