/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.content;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.vcsUtil.VcsUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.content.ContentClient;
import org.jetbrains.idea.svn.content.FileTooBigRuntimeException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitContentClient
extends BaseSvnClient
implements ContentClient {
    @Override
    public byte[] getContent(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNRevision pegRevision) throws VcsException, FileTooBigRuntimeException {
        if (target == null) {
            SvnKitContentClient.$$$reportNull$$$0(0);
        }
        final int maxSize = VcsUtil.getMaxVcsLoadedFileSize();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(){

            @Override
            public synchronized void write(int b) {
                if (this.size() > maxSize) {
                    throw new FileTooBigRuntimeException();
                }
                super.write(b);
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                if (this.size() > maxSize) {
                    throw new FileTooBigRuntimeException();
                }
                super.write(b, off, len);
            }

            @Override
            public synchronized void writeTo(OutputStream out) throws IOException {
                if (this.size() > maxSize) {
                    throw new FileTooBigRuntimeException();
                }
                super.writeTo(out);
            }
        };
        SVNWCClient wcClient = this.myVcs.getSvnKitManager().createWCClient();
        try {
            if (target.isURL()) {
                wcClient.doGetFileContents(target.getURL(), pegRevision, revision, true, (OutputStream)buffer);
            } else {
                wcClient.doGetFileContents(target.getFile(), pegRevision, revision, true, (OutputStream)buffer);
            }
            ContentRevisionCache.checkContentsSize((String)target.getPathOrUrlString(), (long)buffer.size());
        }
        catch (FileTooBigRuntimeException e) {
            ContentRevisionCache.checkContentsSize((String)target.getPathOrUrlString(), (long)buffer.size());
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
        return buffer.toByteArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/content/SvnKitContentClient", "getContent"));
    }
}

