/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.KeyedExtensionCollector");
    private final Map<String, List<T>> myExplicitExtensions;
    private final ConcurrentMap<String, List<T>> myCache;
    @NonNls
    private final String lock;
    private ExtensionPoint<KeyedLazyInstance<T>> myPoint;
    private final String myEpName;
    private ExtensionPointAndAreaListener<KeyedLazyInstance<T>> myListener;
    private final List<ExtensionPointListener<T>> myListeners;

    public KeyedExtensionCollector(@NonNls @NotNull String epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(0);
        }
        this.myExplicitExtensions = new THashMap();
        this.myCache = ContainerUtil.newConcurrentMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEpName = epName;
        this.lock = "lock for KeyedExtensionCollector " + epName;
        this.resetAreaListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAreaListener() {
        String string = this.lock;
        synchronized (string) {
            this.myCache.clear();
            if (this.myPoint != null) {
                this.myPoint.removeExtensionPointListener(this.myListener);
                this.myPoint = null;
                this.myListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(1);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(2);
        }
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list == null) {
                list = new ArrayList<T>();
                this.myExplicitExtensions.put(skey, list);
            }
            list.add(t);
            this.myCache.remove(skey);
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionAdded(t, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(3);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(4);
        }
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list != null) {
                list.remove(t);
                this.myCache.remove(skey);
            }
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionRemoved(t, null);
            }
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(5);
        }
        String string = key.toString();
        if (string == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public List<T> forKey(@NotNull KeyT key) {
        List cached;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(7);
        }
        String stringKey = this.keyToString(key);
        boolean rebuild = this.myPoint == null && Extensions.getRootArea().hasExtensionPoint(this.myEpName);
        List list = cached = rebuild ? null : (List)this.myCache.get(stringKey);
        if (cached != null) {
            List list2 = cached;
            if (list2 == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(8);
            }
            return list2;
        }
        cached = this.buildExtensions(stringKey, key);
        List list3 = cached = (List)ConcurrencyUtil.cacheOrGet(this.myCache, (Object)stringKey, cached);
        if (list3 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(9);
        }
        return list3;
    }

    public T findSingle(@NotNull KeyT key) {
        List<T> list;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(10);
        }
        return (list = this.forKey(key)).isEmpty() ? null : (T)list.get(0);
    }

    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        if (stringKey == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(11);
        }
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(12);
        }
        List<T> list = this.buildExtensions(Collections.singleton(stringKey));
        if (list == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(13);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final List<T> buildExtensions(@NotNull Set<String> keys) {
        if (keys == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(14);
        }
        String string = this.lock;
        // MONITORENTER : string
        SmartList result = null;
        for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!keys.contains(key)) continue;
            List<T> list2 = entry.getValue();
            if (result == null) {
                result = new ArrayList(list2);
                continue;
            }
            result.addAll(list2);
        }
        ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            KeyedLazyInstance[] beans;
            for (KeyedLazyInstance bean : beans = (KeyedLazyInstance[])point.getExtensions()) {
                Object instance;
                if (!keys.contains(bean.getKey())) continue;
                try {
                    instance = bean.getInstance();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                catch (LinkageError e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (result == null) {
                    result = new SmartList();
                }
                result.add(instance);
            }
        }
        List<Object> list = result == null ? Collections.emptyList() : result;
        // MONITOREXIT : string
        if (list != null) return list;
        KeyedExtensionCollector.$$$reportNull$$$0(15);
        return list;
    }

    @Nullable
    private ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        ExtensionPoint point = this.myPoint;
        if (point == null && Extensions.getRootArea().hasExtensionPoint(this.myEpName)) {
            ExtensionPointName typesafe = ExtensionPointName.create((String)this.myEpName);
            this.myPoint = point = Extensions.getRootArea().getExtensionPoint(typesafe);
            this.myListener = new ExtensionPointAndAreaListener<KeyedLazyInstance<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                    if (bean == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = KeyedExtensionCollector.this.lock;
                    synchronized (string) {
                        if (bean.getKey() == null) {
                            if (pluginDescriptor != null) {
                                throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                            }
                            LOG.error("No key specified for extension of class " + bean.getInstance().getClass());
                            return;
                        }
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionAdded(bean.getInstance(), null);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                    if (bean == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    String string = KeyedExtensionCollector.this.lock;
                    synchronized (string) {
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionRemoved(bean.getInstance(), null);
                        }
                    }
                }

                public void areaReplaced(ExtensionsArea area) {
                    KeyedExtensionCollector.this.resetAreaListener();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "bean";
                    objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            point.addExtensionPointListener(this.myListener);
        }
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string = this.lock;
        synchronized (string) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.hasAnyExtensions();
        }
    }

    public void addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(16);
        }
        this.myListeners.add(listener);
    }

    public void addListener(final @NotNull ExtensionPointListener<T> listener, @NotNull Disposable parent) {
        if (listener == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(18);
        }
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                KeyedExtensionCollector.this.myListeners.remove(listener);
            }
        });
    }

    public void removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(19);
        }
        this.myListeners.remove(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forKey";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSingle";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

