#ifndef EFL_INTERFACE_EO_HH
#define EFL_INTERFACE_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_interface.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
namespace efl { 
struct Interface;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Interface> : ::std::true_type {}; } }
namespace efl { 
struct Interface;
} 

namespace eo_cxx {
namespace efl { 
struct Interface {
   static Efl_Class const* _eo_class()
   {
      return EFL_INTERFACE_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Interface() const;
   operator ::efl::Interface&();
   operator ::efl::Interface const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Interface> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Interface const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Interface : ::efl::eo::concrete
{
   explicit Interface( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Interface(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Interface(Interface const& other) = default;
   Interface(Interface&& other) = default;
   Interface& operator=(Interface const& other) = default;
   Interface& operator=(Interface&& other) = default;
   Interface()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Interface( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Interface(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   static Efl_Class const* _eo_class()
   {
      return EFL_INTERFACE_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Interface> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Interface const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Interface) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Interface>::value, "");
} 
#endif
