/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanOperationInfo
extends MBeanOperationInfo
implements DescriptorAccess {
    private static final long oldSerialVersionUID = 9087646304346171239L;
    private static final long newSerialVersionUID = 6532732096650090465L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("operationDescriptor", Descriptor.class), new ObjectStreamField("currClass", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("operationDescriptor", Descriptor.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private Descriptor operationDescriptor = this.validDescriptor(null);
    private static final String currClass = "ModelMBeanOperationInfo";

    public ModelMBeanOperationInfo(String description, Method operationMethod) {
        super(description, operationMethod);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String,Method)", "Entry");
        }
        this.operationDescriptor = this.validDescriptor(null);
    }

    public ModelMBeanOperationInfo(String description, Method operationMethod, Descriptor descriptor) {
        super(description, operationMethod);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String,Method,Descriptor)", "Entry");
        }
        this.operationDescriptor = this.validDescriptor(descriptor);
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        super(name, description, signature, type, impact);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String,String,MBeanParameterInfo[],String,int)", "Entry");
        }
        this.operationDescriptor = this.validDescriptor(null);
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact, Descriptor descriptor) {
        super(name, description, signature, type, impact);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String,String,MBeanParameterInfo[],String,int,Descriptor)", "Entry");
        }
        this.operationDescriptor = this.validDescriptor(descriptor);
    }

    public ModelMBeanOperationInfo(ModelMBeanOperationInfo inInfo) {
        super(inInfo.getName(), inInfo.getDescription(), inInfo.getSignature(), inInfo.getReturnType(), inInfo.getImpact());
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(ModelMBeanOperationInfo)", "Entry");
        }
        Descriptor newDesc = inInfo.getDescriptor();
        this.operationDescriptor = this.validDescriptor(newDesc);
    }

    @Override
    public Object clone() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "clone()", "Entry");
        }
        return new ModelMBeanOperationInfo(this);
    }

    @Override
    public Descriptor getDescriptor() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "getDescriptor()", "Entry");
        }
        if (this.operationDescriptor == null) {
            this.operationDescriptor = this.validDescriptor(null);
        }
        return (Descriptor)this.operationDescriptor.clone();
    }

    @Override
    public void setDescriptor(Descriptor inDescriptor) {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "setDescriptor(Descriptor)", "Entry");
        }
        this.operationDescriptor = this.validDescriptor(inDescriptor);
    }

    @Override
    public String toString() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "toString()", "Entry");
        }
        String retStr = "ModelMBeanOperationInfo: " + this.getName() + " ; Description: " + this.getDescription() + " ; Descriptor: " + this.getDescriptor() + " ; ReturnType: " + this.getReturnType() + " ; Signature: ";
        MBeanParameterInfo[] pTypes = this.getSignature();
        for (int i = 0; i < pTypes.length; ++i) {
            retStr = retStr.concat(pTypes[i].getType() + ", ");
        }
        return retStr;
    }

    private Descriptor validDescriptor(Descriptor in) throws RuntimeOperationsException {
        Descriptor clone;
        boolean defaulted;
        boolean bl = defaulted = in == null;
        if (defaulted) {
            clone = new DescriptorSupport();
            JmxProperties.MODELMBEAN_LOGGER.finer("Null Descriptor, creating new.");
        } else {
            clone = (Descriptor)in.clone();
        }
        if (defaulted && clone.getFieldValue("name") == null) {
            clone.setField("name", this.getName());
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor name to " + this.getName());
        }
        if (defaulted && clone.getFieldValue("descriptorType") == null) {
            clone.setField("descriptorType", "operation");
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting descriptorType to \"operation\"");
        }
        if (clone.getFieldValue("displayName") == null) {
            clone.setField("displayName", this.getName());
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor displayName to " + this.getName());
        }
        if (clone.getFieldValue("role") == null) {
            clone.setField("role", "operation");
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor role field to \"operation\"");
        }
        if (!clone.isValid()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The isValid() method of the Descriptor object itself returned false,one or more required fields are invalid. Descriptor:" + clone.toString());
        }
        if (!this.getName().equalsIgnoreCase((String)clone.getFieldValue("name"))) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The Descriptor \"name\" field does not match the object described.  Expected: " + this.getName() + " , was: " + clone.getFieldValue("name"));
        }
        if (!"operation".equalsIgnoreCase((String)clone.getFieldValue("descriptorType"))) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The Descriptor \"descriptorType\" field does not match the object described.  Expected: \"operation\" , was: " + clone.getFieldValue("descriptorType"));
        }
        String role = (String)clone.getFieldValue("role");
        if (!(role.equalsIgnoreCase("operation") || role.equalsIgnoreCase("setter") || role.equalsIgnoreCase("getter"))) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The Descriptor \"role\" field does not match the object described.  Expected: \"operation\", \"setter\", or \"getter\" , was: " + clone.getFieldValue("role"));
        }
        Object targetValue = clone.getFieldValue("targetType");
        if (targetValue != null && !(targetValue instanceof String)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The Descriptor field \"targetValue\" is invalid class.  Expected: java.lang.String,  was: " + targetValue.getClass().getName());
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("operationDescriptor", this.operationDescriptor);
            fields.put("currClass", currClass);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 9087646304346171239L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 6532732096650090465L;
        }
    }
}

