/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.CertConstraintParameters;
import sun.security.util.Debug;
import sun.security.util.KeyUtil;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    private final String[] disabledAlgorithms;
    private final Constraints algorithmConstraints;

    public DisabledAlgorithmConstraints(String propertyName) {
        this(propertyName, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String propertyName, AlgorithmDecomposer decomposer) {
        super(decomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(propertyName);
        this.algorithmConstraints = new Constraints(this.disabledAlgorithms);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        if (primitives == null || primitives.isEmpty()) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
        return DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, algorithm, this.decomposer);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        return this.checkConstraints(primitives, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(primitives, algorithm, key, parameters);
    }

    public final void permits(Set<CryptoPrimitive> primitives, CertConstraintParameters cp) throws CertPathValidatorException {
        this.checkConstraints(primitives, cp);
    }

    public final void permits(Set<CryptoPrimitive> primitives, X509Certificate cert) throws CertPathValidatorException {
        this.checkConstraints(primitives, new CertConstraintParameters(cert));
    }

    public boolean checkProperty(String param) {
        param = param.toLowerCase(Locale.ENGLISH);
        for (String block : this.disabledAlgorithms) {
            if (block.toLowerCase(Locale.ENGLISH).indexOf(param) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkConstraints(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (algorithm != null && algorithm.length() != 0 && !this.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (!this.permits(primitives, key.getAlgorithm(), null)) {
            return false;
        }
        return this.algorithmConstraints.permits(key);
    }

    private void checkConstraints(Set<CryptoPrimitive> primitives, CertConstraintParameters cp) throws CertPathValidatorException {
        X509Certificate cert = cp.getCertificate();
        String algorithm = cert.getSigAlgName();
        if (!this.permits(primitives, algorithm, null)) {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled signature algorithm: " + algorithm, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
        if (!this.permits(primitives, cert.getPublicKey().getAlgorithm(), null)) {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled public key algorithm: " + algorithm, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
        this.algorithmConstraints.permits(cp);
    }

    private static class KeySizeConstraint
    extends Constraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(String algo, Constraint.Operator operator, int length) {
            this.algorithm = algo;
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = length;
                    break;
                }
                case NE: {
                    this.minSize = length;
                    this.maxSize = length;
                    break;
                }
                case LT: {
                    this.minSize = length;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = length + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = length;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = length > 1 ? length - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        @Override
        public void permits(CertConstraintParameters cp) throws CertPathValidatorException {
            if (!this.permitsImpl(cp.getCertificate().getPublicKey())) {
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(cp);
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize limits", null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.nextConstraint != null && this.nextConstraint.permits(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("KeySizeConstraints.permits(): " + this.algorithm);
            }
            return this.permitsImpl(key);
        }

        private boolean permitsImpl(Key key) {
            if (this.algorithm.compareToIgnoreCase(key.getAlgorithm()) != 0) {
                return true;
            }
            int size = KeyUtil.getKeySize(key);
            if (size == 0) {
                return false;
            }
            if (size > 0) {
                return size >= this.minSize && size <= this.maxSize && this.prohibitedSize != size;
            }
            return true;
        }
    }

    private static class jdkCAConstraint
    extends Constraint {
        jdkCAConstraint(String algo) {
            this.algorithm = algo;
        }

        @Override
        public void permits(CertConstraintParameters cp) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("jdkCAConstraints.permits(): " + this.algorithm);
            }
            if (cp.isTrustedMatch()) {
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(cp);
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on certificate anchor limits", null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static abstract class Constraint {
        String algorithm;
        Constraint nextConstraint = null;

        private Constraint() {
        }

        public boolean permits(Key key) {
            return true;
        }

        public abstract void permits(CertConstraintParameters var1) throws CertPathValidatorException;

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String s) {
                switch (s) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException("Error in security property. " + s + " is not a legal Operator");
            }
        }
    }

    private static class Constraints {
        private Map<String, Set<Constraint>> constraintsMap = new HashMap<String, Set<Constraint>>();
        private static final Pattern keySizePattern = Pattern.compile("keySize\\s*(<=|<|==|!=|>|>=)\\s*(\\d+)");

        public Constraints(String[] constraintArray) {
            for (String constraintEntry : constraintArray) {
                int space;
                if (constraintEntry == null || constraintEntry.isEmpty()) continue;
                constraintEntry = constraintEntry.trim();
                if (debug != null) {
                    debug.println("Constraints: " + constraintEntry);
                }
                if ((space = constraintEntry.indexOf(32)) <= 0) {
                    String k = constraintEntry.toUpperCase(Locale.ENGLISH);
                    if (this.constraintsMap.containsKey(k)) continue;
                    this.constraintsMap.put(k, new HashSet());
                    continue;
                }
                String algorithm = AlgorithmDecomposer.hashName(constraintEntry.substring(0, space).toUpperCase(Locale.ENGLISH));
                String policy = constraintEntry.substring(space + 1);
                Constraint c = null;
                jdkCAConstraint lastConstraint = null;
                boolean jdkCALimit = false;
                for (String entry : policy.split("&")) {
                    Matcher matcher = keySizePattern.matcher(entry = entry.trim());
                    if (matcher.matches()) {
                        if (debug != null) {
                            debug.println("Constraints set to keySize: " + entry);
                        }
                        c = new KeySizeConstraint(algorithm, Constraint.Operator.of(matcher.group(1)), Integer.parseInt(matcher.group(2)));
                    } else if (entry.equalsIgnoreCase("jdkCA")) {
                        if (debug != null) {
                            debug.println("Constraints set to jdkCA.");
                        }
                        if (jdkCALimit) {
                            throw new IllegalArgumentException("Only one jdkCA entry allowed in property. Constraint: " + constraintEntry);
                        }
                        c = new jdkCAConstraint(algorithm);
                        jdkCALimit = true;
                    }
                    if (lastConstraint == null) {
                        if (!this.constraintsMap.containsKey(algorithm)) {
                            this.constraintsMap.put(algorithm, new HashSet());
                        }
                        if (c != null) {
                            this.constraintsMap.get(algorithm).add(c);
                        }
                    } else {
                        lastConstraint.nextConstraint = c;
                    }
                    lastConstraint = c;
                }
            }
        }

        private Set<Constraint> getConstraints(String algorithm) {
            return this.constraintsMap.get(algorithm);
        }

        public boolean permits(Key key) {
            Set<Constraint> set = this.getConstraints(key.getAlgorithm());
            if (set == null) {
                return true;
            }
            for (Constraint constraint : set) {
                if (constraint.permits(key)) continue;
                if (debug != null) {
                    debug.println("keySizeConstraint: failed key constraint check " + KeyUtil.getKeySize(key));
                }
                return false;
            }
            return true;
        }

        public void permits(CertConstraintParameters cp) throws CertPathValidatorException {
            Set<String> algorithms;
            X509Certificate cert = cp.getCertificate();
            if (debug != null) {
                debug.println("Constraints.permits(): " + cert.getSigAlgName());
            }
            if ((algorithms = AlgorithmDecomposer.decomposeOneHash(cert.getSigAlgName())) == null || algorithms.isEmpty()) {
                return;
            }
            algorithms.add(cert.getPublicKey().getAlgorithm());
            for (String algorithm : algorithms) {
                Set<Constraint> set = this.getConstraints(algorithm);
                if (set == null) continue;
                for (Constraint constraint : set) {
                    constraint.permits(cp);
                }
            }
        }
    }
}

