/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg;

import com.sun.webpane.platform.Pasteboard;
import com.sun.webpane.platform.Utilities;
import com.sun.webpane.platform.graphics.WCImageFrame;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

class PasteboardImpl
implements Pasteboard {
    private Clipboard clipboard = Clipboard.getSystemClipboard();

    @Override
    public String getPlainText() {
        return this.clipboard.getString();
    }

    @Override
    public String getHtml() {
        return this.clipboard.getHtml();
    }

    @Override
    public void writePlainText(String string) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        this.clipboard.setContent(clipboardContent);
    }

    @Override
    public void writeSelection(boolean bl, String string, String string2) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        clipboardContent.putHtml(string2);
        this.clipboard.setContent(clipboardContent);
    }

    @Override
    public void writeImage(WCImageFrame wCImageFrame) {
        Object object = Utilities.getUtilities().toPlatformImage(wCImageFrame.getFrame());
        Image image = Image.impl_fromPlatformImage(object);
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putImage(image);
        this.clipboard.setContent(clipboardContent);
    }

    @Override
    public void writeUrl(String string, String string2) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        clipboardContent.putHtml(string2);
        clipboardContent.putUrl(string);
        this.clipboard.setContent(clipboardContent);
    }
}

