/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.macos;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.macos.MacOsBrowserLaunching;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MacOs2_0BrowserLaunching
extends MacOsBrowserLaunching {
    private static final String GURL_EVENT = "GURL";
    private Class aeDescClass;
    private Constructor aeTargetConstructor;
    private Constructor appleEventConstructor;
    private Constructor aeDescConstructor;
    private Method makeOSType;
    private Method putParameter;
    private Method sendNoReply;
    private Integer keyDirectObject;
    private Integer kAutoGenerateReturnID;
    private Integer kAnyTransactionID;
    static /* synthetic */ Class class$java$lang$String;

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            Class<?> aeTargetClass = Class.forName("com.apple.MacOS.AETarget");
            Class<?> osUtilsClass = Class.forName("com.apple.MacOS.OSUtils");
            Class<?> appleEventClass = Class.forName("com.apple.MacOS.AppleEvent");
            Class<?> aeClass = Class.forName("com.apple.MacOS.ae");
            this.aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
            this.aeTargetConstructor = aeTargetClass.getDeclaredConstructor(Integer.TYPE);
            this.appleEventConstructor = appleEventClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, aeTargetClass, Integer.TYPE, Integer.TYPE);
            this.aeDescConstructor = this.aeDescClass.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = MacOs2_0BrowserLaunching.class$("java.lang.String")) : class$java$lang$String);
            this.makeOSType = osUtilsClass.getDeclaredMethod("makeOSType", class$java$lang$String == null ? (class$java$lang$String = MacOs2_0BrowserLaunching.class$("java.lang.String")) : class$java$lang$String);
            this.putParameter = appleEventClass.getDeclaredMethod("putParameter", Integer.TYPE, this.aeDescClass);
            this.sendNoReply = appleEventClass.getDeclaredMethod("sendNoReply", new Class[0]);
            Field keyDirectObjectField = aeClass.getDeclaredField("keyDirectObject");
            this.keyDirectObject = (Integer)keyDirectObjectField.get(null);
            Field autoGenerateReturnIDField = appleEventClass.getDeclaredField("kAutoGenerateReturnID");
            this.kAutoGenerateReturnID = (Integer)autoGenerateReturnIDField.get(null);
            Field anyTransactionIDField = appleEventClass.getDeclaredField("kAnyTransactionID");
            this.kAnyTransactionID = (Integer)anyTransactionIDField.get(null);
        }
        catch (Exception cnfe) {
            throw new BrowserLaunchingInitializingException(cnfe);
        }
    }

    private Object getBrowser() throws BrowserLaunchingInitializingException {
        try {
            Integer finderCreatorCode = (Integer)this.makeOSType.invoke(null, "MACS");
            Object aeTarget = this.aeTargetConstructor.newInstance(finderCreatorCode);
            Integer gurlType = (Integer)this.makeOSType.invoke(null, GURL_EVENT);
            Object appleEvent = this.appleEventConstructor.newInstance(gurlType, gurlType, aeTarget, this.kAutoGenerateReturnID, this.kAnyTransactionID);
            return appleEvent;
        }
        catch (Exception e) {
            throw new BrowserLaunchingInitializingException(e);
        }
    }

    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        Object browser = this.getBrowser();
        Object aeDesc = null;
        try {
            aeDesc = this.aeDescConstructor.newInstance(urlString);
            this.putParameter.invoke(browser, this.keyDirectObject, aeDesc);
            this.sendNoReply.invoke(browser, new Object[0]);
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
        finally {
            aeDesc = null;
            browser = null;
        }
    }

    public List getBrowserList() {
        ArrayList<String> browserList = new ArrayList<String>(1);
        browserList.add("Default");
        return browserList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

