/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.resolve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.resolve.LocalLibraryMetaDataAdapter;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJvmBinarySpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JarFile;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.WithJvmAssembly;
import org.gradle.jvm.internal.resolve.LibraryPublishArtifact;
import org.gradle.jvm.internal.resolve.UsageKind;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetadata;
import org.gradle.platform.base.Binary;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.SourceComponentSpec;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class JvmLocalLibraryMetaDataAdapter
implements LocalLibraryMetaDataAdapter {
    public DefaultLibraryLocalComponentMetadata createLocalComponentMetaData(Binary selectedBinary, String projectPath, boolean toAssembly) {
        EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage = new EnumMap<UsageKind, Iterable<DependencySpec>>(UsageKind.class);
        EnumMap<UsageKind, List<PublishArtifact>> artifacts = new EnumMap<UsageKind, List<PublishArtifact>>(UsageKind.class);
        this.initializeUsages(dependenciesPerUsage, artifacts);
        if (selectedBinary instanceof JarBinarySpecInternal) {
            JarBinarySpecInternal jarBinarySpec = (JarBinarySpecInternal)selectedBinary;
            this.createJarBinarySpecLocalComponentMetaData(artifacts, jarBinarySpec, dependenciesPerUsage, toAssembly);
        }
        if (selectedBinary instanceof WithJvmAssembly) {
            JvmAssembly assembly = ((WithJvmAssembly)selectedBinary).getAssembly();
            this.createJvmAssemblyLocalComponentMetaData(artifacts, assembly, dependenciesPerUsage, toAssembly);
        }
        return this.createResolvedMetaData((BinarySpecInternal)selectedBinary, projectPath, dependenciesPerUsage, artifacts);
    }

    private DefaultLibraryLocalComponentMetadata createResolvedMetaData(BinarySpecInternal selectedBinary, String projectPath, EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, EnumMap<UsageKind, List<PublishArtifact>> artifacts) {
        final DefaultLibraryLocalComponentMetadata metadata = DefaultLibraryLocalComponentMetadata.newResolvedLibraryMetadata((LibraryBinaryIdentifier)selectedBinary.getId(), this.toStringMap(dependenciesPerUsage), (String)projectPath);
        for (Map.Entry<UsageKind, List<PublishArtifact>> entry : artifacts.entrySet()) {
            UsageKind usage = entry.getKey();
            final List<PublishArtifact> publishArtifacts = entry.getValue();
            metadata.addArtifacts(usage.getConfigurationName(), publishArtifacts);
            metadata.addVariant(usage.getConfigurationName(), new OutgoingVariant(){

                public DisplayName asDescribable() {
                    return Describables.of((Object)metadata.getComponentId());
                }

                public AttributeContainerInternal getAttributes() {
                    return ImmutableAttributes.EMPTY;
                }

                public Set<? extends PublishArtifact> getArtifacts() {
                    return new LinkedHashSet(publishArtifacts);
                }

                public Set<? extends OutgoingVariant> getChildren() {
                    return ImmutableSet.of();
                }
            });
        }
        return metadata;
    }

    private <T> Map<String, T> toStringMap(EnumMap<? extends Enum<UsageKind>, T> enumMap) {
        HashMap<String, T> map = new HashMap<String, T>(enumMap.size());
        for (Map.Entry<Enum<UsageKind>, T> tEntry : enumMap.entrySet()) {
            UsageKind usageKind = UsageKind.valueOf(tEntry.getKey().name());
            map.put(usageKind.getConfigurationName(), tEntry.getValue());
        }
        return map;
    }

    private void initializeUsages(EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, EnumMap<UsageKind, List<PublishArtifact>> artifacts) {
        for (UsageKind usageKind : UsageKind.values()) {
            dependenciesPerUsage.put(usageKind, Collections.emptyList());
            artifacts.put(usageKind, new LinkedList());
        }
    }

    private void createJarBinarySpecLocalComponentMetaData(EnumMap<UsageKind, List<PublishArtifact>> artifacts, JarBinarySpecInternal jarBinarySpec, EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, boolean toAssembly) {
        JarFile apiJar = jarBinarySpec.getApiJar();
        JvmLocalLibraryMetaDataAdapter.configureUsageMetadata(UsageKind.API, jarBinarySpec.getApiDependencies(), dependenciesPerUsage);
        JarFile runtimeJar = jarBinarySpec.getRuntimeJar();
        JvmLibrarySpec library = jarBinarySpec.getLibrary();
        JvmLocalLibraryMetaDataAdapter.configureUsageMetadata(UsageKind.RUNTIME, library != null ? DefaultJvmBinarySpec.collectDependencies(jarBinarySpec, (SourceComponentSpec)library, library.getDependencies().getDependencies(), jarBinarySpec.getApiDependencies()) : Collections.emptyList(), dependenciesPerUsage);
        if (!toAssembly) {
            JvmLocalLibraryMetaDataAdapter.addArtifact(UsageKind.API, apiJar, artifacts);
            JvmLocalLibraryMetaDataAdapter.addArtifact(UsageKind.RUNTIME, runtimeJar, artifacts);
        }
    }

    private void createJvmAssemblyLocalComponentMetaData(EnumMap<UsageKind, List<PublishArtifact>> artifacts, JvmAssembly assembly, EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, boolean toAssembly) {
        JvmLocalLibraryMetaDataAdapter.configureUsageMetadata(UsageKind.API, Collections.<DependencySpec>emptyList(), dependenciesPerUsage);
        JvmLocalLibraryMetaDataAdapter.configureUsageMetadata(UsageKind.RUNTIME, Collections.<DependencySpec>emptyList(), dependenciesPerUsage);
        if (toAssembly) {
            JvmLocalLibraryMetaDataAdapter.addArtifact(UsageKind.API, assembly.getClassDirectories(), artifacts, assembly);
            JvmLocalLibraryMetaDataAdapter.addArtifact(UsageKind.RUNTIME, (Set<File>)Sets.union(assembly.getClassDirectories(), assembly.getResourceDirectories()), artifacts, assembly);
        }
    }

    private static void configureUsageMetadata(UsageKind usage, Iterable<DependencySpec> dependencies, EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage) {
        Iterable<DependencySpec> dependencySpecs = dependenciesPerUsage.get((Object)usage);
        dependenciesPerUsage.put(usage, Iterables.concat(dependencies, dependencySpecs));
    }

    private static void addArtifact(UsageKind usage, JarFile jarFile, EnumMap<UsageKind, List<PublishArtifact>> artifacts) {
        LibraryPublishArtifact publishArtifact = new LibraryPublishArtifact("jar", jarFile.getFile());
        publishArtifact.builtBy(new Object[]{jarFile});
        artifacts.get((Object)usage).add((PublishArtifact)publishArtifact);
    }

    private static void addArtifact(UsageKind usage, Set<File> directories, EnumMap<UsageKind, List<PublishArtifact>> artifacts, JvmAssembly assembly) {
        List<PublishArtifact> publishArtifacts = artifacts.get((Object)usage);
        for (File dir : directories) {
            DefaultPublishArtifact publishArtifact = new DefaultPublishArtifact("assembly", "", "", "", new Date(dir.lastModified()), dir, new Object[0]);
            publishArtifact.builtBy(new Object[]{assembly});
            publishArtifacts.add((PublishArtifact)publishArtifact);
        }
    }
}

