/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.RegexBackedCSourceParser;

public class DefaultInclude
implements Include {
    private static final Interner<DefaultInclude> INTERNER = Interners.newWeakInterner();
    private final String value;
    private final boolean isImport;
    private final IncludeType type;

    public static DefaultInclude create(String value, boolean isImport, IncludeType type) {
        return (DefaultInclude)INTERNER.intern((Object)new DefaultInclude(value, isImport, type));
    }

    public DefaultInclude(String value, boolean isImport, IncludeType type) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.value = value;
        this.isImport = isImport;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public IncludeType getType() {
        return this.type;
    }

    public static Include parse(String value, boolean isImport) {
        if (value.startsWith("<") && value.endsWith(">")) {
            return DefaultInclude.create(DefaultInclude.strip(value), isImport, IncludeType.SYSTEM);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return DefaultInclude.create(DefaultInclude.strip(value), isImport, IncludeType.QUOTED);
        }
        int pos = RegexBackedCSourceParser.consumeIdentifier(value, 0);
        if (pos > 0 && pos == value.length()) {
            return DefaultInclude.create(value, isImport, IncludeType.MACRO);
        }
        if (pos > 0 && pos != value.length()) {
            int endPos = pos;
            if (value.charAt(pos = RegexBackedCSourceParser.consumeWhitespace(value, pos)) == '(') {
                ++pos;
                if ((pos = RegexBackedCSourceParser.consumeWhitespace(value, pos)) == value.length() - 1 && value.charAt(pos) == ')') {
                    return DefaultInclude.create(value.substring(0, endPos), isImport, IncludeType.MACRO_FUNCTION);
                }
            }
        }
        return DefaultInclude.create(value, isImport, IncludeType.OTHER);
    }

    private static String strip(String include) {
        return include.substring(1, include.length() - 1);
    }

    public String toString() {
        return this.value.concat(":").concat(this.type.toString()).concat(":").concat(String.valueOf(this.isImport));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultInclude that = (DefaultInclude)o;
        if (this.isImport != that.isImport) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (this.isImport ? 1 : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

