/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import java.util.Collections;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.language.nativeplatform.internal.DefaultNativeComponent;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftComponent;

public abstract class DefaultSwiftComponent
extends DefaultNativeComponent
implements SwiftComponent {
    private final FileCollection swiftSource;
    private final Property<String> module;
    private final String name;
    private final Names names;
    private final Configuration implementation;

    public DefaultSwiftComponent(String name, FileOperations fileOperations, ObjectFactory objectFactory, ConfigurationContainer configurations) {
        super(fileOperations);
        this.name = name;
        this.swiftSource = this.createSourceView("src/" + name + "/swift", Collections.singletonList("swift"));
        this.module = objectFactory.property(String.class);
        this.names = Names.of(name);
        this.implementation = (Configuration)configurations.maybeCreate(this.names.withSuffix("implementation"));
        this.implementation.setCanBeConsumed(false);
        this.implementation.setCanBeResolved(false);
    }

    public String getName() {
        return this.name;
    }

    protected Names getNames() {
        return this.names;
    }

    @Override
    public Property<String> getModule() {
        return this.module;
    }

    @Override
    public FileCollection getSwiftSource() {
        return this.swiftSource;
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.implementation;
    }
}

