/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.Paths;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

public class ObjectChecker {
    public static final byte[] tree = Constants.encodeASCII("tree ");
    public static final byte[] parent = Constants.encodeASCII("parent ");
    public static final byte[] author = Constants.encodeASCII("author ");
    public static final byte[] committer = Constants.encodeASCII("committer ");
    public static final byte[] encoding = Constants.encodeASCII("encoding ");
    public static final byte[] object = Constants.encodeASCII("object ");
    public static final byte[] type = Constants.encodeASCII("type ");
    public static final byte[] tag = Constants.encodeASCII("tag ");
    public static final byte[] tagger = Constants.encodeASCII("tagger ");
    private final MutableObjectId tempId = new MutableObjectId();
    private final MutableInteger bufPtr = new MutableInteger();
    private EnumSet<ErrorType> errors = EnumSet.allOf(ErrorType.class);
    private ObjectIdSet skipList;
    private boolean allowInvalidPersonIdent;
    private boolean windows;
    private boolean macosx;

    public ObjectChecker setSkipList(@Nullable ObjectIdSet objects) {
        this.skipList = objects;
        return this;
    }

    public ObjectChecker setIgnore(@Nullable Set<ErrorType> ids) {
        this.errors = EnumSet.allOf(ErrorType.class);
        if (ids != null) {
            this.errors.removeAll(ids);
        }
        return this;
    }

    public ObjectChecker setIgnore(ErrorType id, boolean ignore) {
        if (ignore) {
            this.errors.remove((Object)id);
        } else {
            this.errors.add(id);
        }
        return this;
    }

    public ObjectChecker setAllowLeadingZeroFileMode(boolean allow) {
        return this.setIgnore(ErrorType.ZERO_PADDED_FILEMODE, allow);
    }

    public ObjectChecker setAllowInvalidPersonIdent(boolean allow) {
        this.allowInvalidPersonIdent = allow;
        return this;
    }

    public ObjectChecker setSafeForWindows(boolean win) {
        this.windows = win;
        return this;
    }

    public ObjectChecker setSafeForMacOS(boolean mac) {
        this.macosx = mac;
        return this;
    }

    public void check(int objType, byte[] raw) throws CorruptObjectException {
        this.check(this.idFor(objType, raw), objType, raw);
    }

    public void check(@Nullable AnyObjectId id, int objType, byte[] raw) throws CorruptObjectException {
        switch (objType) {
            case 1: {
                this.checkCommit(id, raw);
                break;
            }
            case 4: {
                this.checkTag(id, raw);
                break;
            }
            case 2: {
                this.checkTree(id, raw);
                break;
            }
            case 3: {
                this.checkBlob(raw);
                break;
            }
            default: {
                this.report(ErrorType.UNKNOWN_TYPE, id, MessageFormat.format(JGitText.get().corruptObjectInvalidType2, objType));
            }
        }
    }

    private boolean checkId(byte[] raw) {
        int p = this.bufPtr.value;
        try {
            this.tempId.fromString(raw, p);
        }
        catch (IllegalArgumentException e) {
            this.bufPtr.value = RawParseUtils.nextLF(raw, p);
            return false;
        }
        if (raw[p += 40] == 10) {
            this.bufPtr.value = p + 1;
            return true;
        }
        this.bufPtr.value = RawParseUtils.nextLF(raw, p);
        return false;
    }

    private void checkPersonIdent(byte[] raw, @Nullable AnyObjectId id) throws CorruptObjectException {
        if (this.allowInvalidPersonIdent) {
            this.bufPtr.value = RawParseUtils.nextLF(raw, this.bufPtr.value);
            return;
        }
        int emailB = RawParseUtils.nextLF(raw, this.bufPtr.value, '<');
        if (emailB == this.bufPtr.value || raw[emailB - 1] != 60) {
            this.report(ErrorType.MISSING_EMAIL, id, JGitText.get().corruptObjectMissingEmail);
            this.bufPtr.value = RawParseUtils.nextLF(raw, this.bufPtr.value);
            return;
        }
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailE == emailB || raw[emailE - 1] != 62) {
            this.report(ErrorType.BAD_EMAIL, id, JGitText.get().corruptObjectBadEmail);
            this.bufPtr.value = RawParseUtils.nextLF(raw, this.bufPtr.value);
            return;
        }
        if (emailE == raw.length || raw[emailE] != 32) {
            this.report(ErrorType.MISSING_SPACE_BEFORE_DATE, id, JGitText.get().corruptObjectBadDate);
            this.bufPtr.value = RawParseUtils.nextLF(raw, this.bufPtr.value);
            return;
        }
        RawParseUtils.parseBase10(raw, emailE + 1, this.bufPtr);
        if (emailE + 1 == this.bufPtr.value || this.bufPtr.value == raw.length || raw[this.bufPtr.value] != 32) {
            this.report(ErrorType.BAD_DATE, id, JGitText.get().corruptObjectBadDate);
            this.bufPtr.value = RawParseUtils.nextLF(raw, this.bufPtr.value);
            return;
        }
        int p = this.bufPtr.value + 1;
        RawParseUtils.parseBase10(raw, p, this.bufPtr);
        if (p == this.bufPtr.value) {
            this.report(ErrorType.BAD_TIMEZONE, id, JGitText.get().corruptObjectBadTimezone);
            this.bufPtr.value = RawParseUtils.nextLF(raw, this.bufPtr.value);
            return;
        }
        p = this.bufPtr.value;
        if (raw[p] == 10) {
            this.bufPtr.value = p + 1;
        } else {
            this.report(ErrorType.BAD_TIMEZONE, id, JGitText.get().corruptObjectBadTimezone);
            this.bufPtr.value = RawParseUtils.nextLF(raw, p);
        }
    }

    public void checkCommit(byte[] raw) throws CorruptObjectException {
        this.checkCommit(this.idFor(1, raw), raw);
    }

    public void checkCommit(@Nullable AnyObjectId id, byte[] raw) throws CorruptObjectException {
        this.bufPtr.value = 0;
        if (!this.match(raw, tree)) {
            this.report(ErrorType.MISSING_TREE, id, JGitText.get().corruptObjectNotreeHeader);
        } else if (!this.checkId(raw)) {
            this.report(ErrorType.BAD_TREE_SHA1, id, JGitText.get().corruptObjectInvalidTree);
        }
        while (this.match(raw, parent)) {
            if (this.checkId(raw)) continue;
            this.report(ErrorType.BAD_PARENT_SHA1, id, JGitText.get().corruptObjectInvalidParent);
        }
        if (this.match(raw, author)) {
            this.checkPersonIdent(raw, id);
        } else {
            this.report(ErrorType.MISSING_AUTHOR, id, JGitText.get().corruptObjectNoAuthor);
        }
        if (this.match(raw, committer)) {
            this.checkPersonIdent(raw, id);
        } else {
            this.report(ErrorType.MISSING_COMMITTER, id, JGitText.get().corruptObjectNoCommitter);
        }
    }

    public void checkTag(byte[] raw) throws CorruptObjectException {
        this.checkTag(this.idFor(4, raw), raw);
    }

    public void checkTag(@Nullable AnyObjectId id, byte[] raw) throws CorruptObjectException {
        this.bufPtr.value = 0;
        if (!this.match(raw, object)) {
            this.report(ErrorType.MISSING_OBJECT, id, JGitText.get().corruptObjectNoObjectHeader);
        } else if (!this.checkId(raw)) {
            this.report(ErrorType.BAD_OBJECT_SHA1, id, JGitText.get().corruptObjectInvalidObject);
        }
        if (!this.match(raw, type)) {
            this.report(ErrorType.MISSING_TYPE_ENTRY, id, JGitText.get().corruptObjectNoTypeHeader);
        }
        this.bufPtr.value = RawParseUtils.nextLF(raw, this.bufPtr.value);
        if (!this.match(raw, tag)) {
            this.report(ErrorType.MISSING_TAG_ENTRY, id, JGitText.get().corruptObjectNoTagHeader);
        }
        this.bufPtr.value = RawParseUtils.nextLF(raw, this.bufPtr.value);
        if (this.match(raw, tagger)) {
            this.checkPersonIdent(raw, id);
        }
    }

    private static boolean duplicateName(byte[] raw, int thisNamePos, int thisNameEnd) {
        int sz = raw.length;
        int nextPtr = thisNameEnd + 1 + 20;
        while (true) {
            byte c;
            int nextMode = 0;
            while (true) {
                byte c2;
                if (nextPtr >= sz) {
                    return false;
                }
                if (32 == (c2 = raw[nextPtr++])) break;
                nextMode <<= 3;
                nextMode += c2 - 48;
            }
            int nextNamePos = nextPtr;
            do {
                if (nextPtr != sz) continue;
                return false;
            } while ((c = raw[nextPtr++]) != 0);
            if (nextNamePos + 1 == nextPtr) {
                return false;
            }
            int cmp = Paths.compareSameName(raw, thisNamePos, thisNameEnd, raw, nextNamePos, nextPtr - 1, nextMode);
            if (cmp < 0) {
                return false;
            }
            if (cmp == 0) {
                return true;
            }
            nextPtr += 20;
        }
    }

    public void checkTree(byte[] raw) throws CorruptObjectException {
        this.checkTree(this.idFor(2, raw), raw);
    }

    public void checkTree(@Nullable AnyObjectId id, byte[] raw) throws CorruptObjectException {
        HashSet<String> normalized;
        int sz = raw.length;
        int ptr = 0;
        int lastNameB = 0;
        int lastNameE = 0;
        int lastMode = 0;
        HashSet<String> hashSet = normalized = this.windows || this.macosx ? new HashSet<String>() : null;
        while (ptr < sz) {
            int cmp;
            int thisMode = 0;
            while (true) {
                byte c;
                if (ptr == sz) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInMode);
                }
                if (32 == (c = raw[ptr++])) break;
                if (c < 48 || c > 55) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectInvalidModeChar);
                }
                if (thisMode == 0 && c == 48) {
                    this.report(ErrorType.ZERO_PADDED_FILEMODE, id, JGitText.get().corruptObjectInvalidModeStartsZero);
                }
                thisMode <<= 3;
                thisMode += c - 48;
            }
            if (FileMode.fromBits(thisMode).getObjectType() == -1) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode2, thisMode));
            }
            int thisNameB = ptr;
            if ((ptr = this.scanPathSegment(raw, ptr, sz, id)) == sz || raw[ptr] != 0) {
                throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInName);
            }
            this.checkPathSegment2(raw, thisNameB, ptr, id);
            if (normalized != null) {
                if (!normalized.add(this.normalize(raw, thisNameB, ptr))) {
                    this.report(ErrorType.DUPLICATE_ENTRIES, id, JGitText.get().corruptObjectDuplicateEntryNames);
                }
            } else if (ObjectChecker.duplicateName(raw, thisNameB, ptr)) {
                this.report(ErrorType.DUPLICATE_ENTRIES, id, JGitText.get().corruptObjectDuplicateEntryNames);
            }
            if (lastNameB != 0 && (cmp = Paths.compare(raw, lastNameB, lastNameE, lastMode, raw, thisNameB, ptr, thisMode)) > 0) {
                this.report(ErrorType.TREE_NOT_SORTED, id, JGitText.get().corruptObjectIncorrectSorting);
            }
            lastNameB = thisNameB;
            lastNameE = ptr;
            lastMode = thisMode;
            if ((ptr += 21) > sz) {
                throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInObjectId);
            }
            if (ObjectId.zeroId().compareTo(raw, ptr - 20) != 0) continue;
            this.report(ErrorType.NULL_SHA1, id, JGitText.get().corruptObjectZeroId);
        }
    }

    private int scanPathSegment(byte[] raw, int ptr, int end, @Nullable AnyObjectId id) throws CorruptObjectException {
        while (ptr < end) {
            byte c = raw[ptr];
            if (c == 0) {
                return ptr;
            }
            if (c == 47) {
                this.report(ErrorType.FULL_PATHNAME, id, JGitText.get().corruptObjectNameContainsSlash);
            }
            if (this.windows && ObjectChecker.isInvalidOnWindows(c)) {
                if (c > 31) {
                    throw new CorruptObjectException(String.format(JGitText.get().corruptObjectNameContainsChar, c));
                }
                throw new CorruptObjectException(String.format(JGitText.get().corruptObjectNameContainsByte, c & 0xFF));
            }
            ++ptr;
        }
        return ptr;
    }

    @Nullable
    private ObjectId idFor(int objType, byte[] raw) {
        if (this.skipList != null) {
            return new ObjectInserter.Formatter().idFor(objType, raw);
        }
        return null;
    }

    private void report(@NonNull ErrorType err, @Nullable AnyObjectId id, String why) throws CorruptObjectException {
        if (this.errors.contains((Object)err) && (id == null || this.skipList == null || !this.skipList.contains(id))) {
            if (id != null) {
                throw new CorruptObjectException(err, id, why);
            }
            throw new CorruptObjectException(why);
        }
    }

    public void checkPath(String path) throws CorruptObjectException {
        byte[] buf = Constants.encode(path);
        this.checkPath(buf, 0, buf.length);
    }

    public void checkPath(byte[] raw, int ptr, int end) throws CorruptObjectException {
        int start = ptr;
        while (ptr < end) {
            if (raw[ptr] == 47) {
                this.checkPathSegment(raw, start, ptr);
                start = ptr + 1;
            }
            ++ptr;
        }
        this.checkPathSegment(raw, start, end);
    }

    public void checkPathSegment(byte[] raw, int ptr, int end) throws CorruptObjectException {
        int e = this.scanPathSegment(raw, ptr, end, null);
        if (e < end && raw[e] == 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNameContainsNullByte);
        }
        this.checkPathSegment2(raw, ptr, end, null);
    }

    private void checkPathSegment2(byte[] raw, int ptr, int end, @Nullable AnyObjectId id) throws CorruptObjectException {
        block15: {
            block14: {
                if (ptr == end) {
                    this.report(ErrorType.EMPTY_NAME, id, JGitText.get().corruptObjectNameZeroLength);
                    return;
                }
                if (raw[ptr] != 46) break block14;
                switch (end - ptr) {
                    case 1: {
                        this.report(ErrorType.HAS_DOT, id, JGitText.get().corruptObjectNameDot);
                        break;
                    }
                    case 2: {
                        if (raw[ptr + 1] == 46) {
                            this.report(ErrorType.HAS_DOTDOT, id, JGitText.get().corruptObjectNameDotDot);
                            break;
                        }
                        break block15;
                    }
                    case 4: {
                        if (ObjectChecker.isGit(raw, ptr + 1)) {
                            this.report(ErrorType.HAS_DOTGIT, id, String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(raw, ptr, end)));
                            break;
                        }
                        break block15;
                    }
                    default: {
                        if (end - ptr > 4 && ObjectChecker.isNormalizedGit(raw, ptr + 1, end)) {
                            this.report(ErrorType.HAS_DOTGIT, id, String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(raw, ptr, end)));
                            break;
                        }
                        break block15;
                    }
                }
                break block15;
            }
            if (ObjectChecker.isGitTilde1(raw, ptr, end)) {
                this.report(ErrorType.HAS_DOTGIT, id, String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(raw, ptr, end)));
            }
        }
        if (this.macosx && this.isMacHFSGit(raw, ptr, end, id)) {
            this.report(ErrorType.HAS_DOTGIT, id, String.format(JGitText.get().corruptObjectInvalidNameIgnorableUnicode, RawParseUtils.decode(raw, ptr, end)));
        }
        if (this.windows) {
            if (raw[end - 1] == 32 || raw[end - 1] == 46) {
                this.report(ErrorType.WIN32_BAD_NAME, id, String.format(JGitText.get().corruptObjectInvalidNameEnd, Character.valueOf((char)raw[end - 1])));
            }
            if (end - ptr >= 3) {
                this.checkNotWindowsDevice(raw, ptr, end, id);
            }
        }
    }

    private boolean isMacHFSGit(byte[] raw, int ptr, int end, @Nullable AnyObjectId id) throws CorruptObjectException {
        boolean ignorable = false;
        byte[] git = new byte[]{46, 103, 105, 116};
        int g = 0;
        block14: while (ptr < end) {
            switch (raw[ptr]) {
                case -30: {
                    if (!this.checkTruncatedIgnorableUTF8(raw, ptr, end, id)) {
                        return false;
                    }
                    switch (raw[ptr + 1]) {
                        case -128: {
                            switch (raw[ptr + 2]) {
                                case -116: 
                                case -115: 
                                case -114: 
                                case -113: 
                                case -86: 
                                case -85: 
                                case -84: 
                                case -83: 
                                case -82: {
                                    ignorable = true;
                                    ptr += 3;
                                    continue block14;
                                }
                            }
                            return false;
                        }
                        case -127: {
                            switch (raw[ptr + 2]) {
                                case -86: 
                                case -85: 
                                case -84: 
                                case -83: 
                                case -82: 
                                case -81: {
                                    ignorable = true;
                                    ptr += 3;
                                    continue block14;
                                }
                            }
                            return false;
                        }
                    }
                    return false;
                }
                case -17: {
                    if (!this.checkTruncatedIgnorableUTF8(raw, ptr, end, id)) {
                        return false;
                    }
                    if (raw[ptr + 1] == -69 && raw[ptr + 2] == -65) {
                        ignorable = true;
                        ptr += 3;
                        continue block14;
                    }
                    return false;
                }
            }
            if (g == 4) {
                return false;
            }
            if (raw[ptr++] == git[g++]) continue;
            return false;
        }
        return g == 4 && ignorable;
    }

    private boolean checkTruncatedIgnorableUTF8(byte[] raw, int ptr, int end, @Nullable AnyObjectId id) throws CorruptObjectException {
        if (ptr + 2 >= end) {
            this.report(ErrorType.BAD_UTF8, id, MessageFormat.format(JGitText.get().corruptObjectInvalidNameInvalidUtf8, ObjectChecker.toHexString(raw, ptr, end)));
            return false;
        }
        return true;
    }

    private static String toHexString(byte[] raw, int ptr, int end) {
        StringBuilder b = new StringBuilder("0x");
        for (int i = ptr; i < end; ++i) {
            b.append(String.format("%02x", raw[i]));
        }
        return b.toString();
    }

    private void checkNotWindowsDevice(byte[] raw, int ptr, int end, @Nullable AnyObjectId id) throws CorruptObjectException {
        switch (ObjectChecker.toLower(raw[ptr])) {
            case 'a': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'u' || ObjectChecker.toLower(raw[ptr + 2]) != 'x' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                this.report(ErrorType.WIN32_BAD_NAME, id, JGitText.get().corruptObjectInvalidNameAux);
                break;
            }
            case 'c': {
                if (end - ptr >= 3 && ObjectChecker.toLower(raw[ptr + 2]) == 'n' && ObjectChecker.toLower(raw[ptr + 1]) == 'o' && (end - ptr == 3 || raw[ptr + 3] == 46)) {
                    this.report(ErrorType.WIN32_BAD_NAME, id, JGitText.get().corruptObjectInvalidNameCon);
                }
                if (end - ptr < 4 || ObjectChecker.toLower(raw[ptr + 2]) != 'm' || ObjectChecker.toLower(raw[ptr + 1]) != 'o' || !ObjectChecker.isPositiveDigit(raw[ptr + 3]) || end - ptr != 4 && raw[ptr + 4] != 46) break;
                this.report(ErrorType.WIN32_BAD_NAME, id, String.format(JGitText.get().corruptObjectInvalidNameCom, Character.valueOf((char)raw[ptr + 3])));
                break;
            }
            case 'l': {
                if (end - ptr < 4 || ObjectChecker.toLower(raw[ptr + 1]) != 'p' || ObjectChecker.toLower(raw[ptr + 2]) != 't' || !ObjectChecker.isPositiveDigit(raw[ptr + 3]) || end - ptr != 4 && raw[ptr + 4] != 46) break;
                this.report(ErrorType.WIN32_BAD_NAME, id, String.format(JGitText.get().corruptObjectInvalidNameLpt, Character.valueOf((char)raw[ptr + 3])));
                break;
            }
            case 'n': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'u' || ObjectChecker.toLower(raw[ptr + 2]) != 'l' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                this.report(ErrorType.WIN32_BAD_NAME, id, JGitText.get().corruptObjectInvalidNameNul);
                break;
            }
            case 'p': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'r' || ObjectChecker.toLower(raw[ptr + 2]) != 'n' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                this.report(ErrorType.WIN32_BAD_NAME, id, JGitText.get().corruptObjectInvalidNamePrn);
            }
        }
    }

    private static boolean isInvalidOnWindows(byte c) {
        switch (c) {
            case 34: 
            case 42: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 92: 
            case 124: {
                return true;
            }
        }
        return 1 <= c && c <= 31;
    }

    private static boolean isGit(byte[] buf, int p) {
        return ObjectChecker.toLower(buf[p]) == 'g' && ObjectChecker.toLower(buf[p + 1]) == 'i' && ObjectChecker.toLower(buf[p + 2]) == 't';
    }

    private static boolean isGitTilde1(byte[] buf, int p, int end) {
        if (end - p != 5) {
            return false;
        }
        return ObjectChecker.toLower(buf[p]) == 'g' && ObjectChecker.toLower(buf[p + 1]) == 'i' && ObjectChecker.toLower(buf[p + 2]) == 't' && buf[p + 3] == 126 && buf[p + 4] == 49;
    }

    private static boolean isNormalizedGit(byte[] raw, int ptr, int end) {
        if (ObjectChecker.isGit(raw, ptr)) {
            int p;
            int dots = 0;
            boolean space = false;
            for (p = end - 1; ptr + 2 < p; --p) {
                if (raw[p] == 46) {
                    ++dots;
                    continue;
                }
                if (raw[p] != 32) break;
                space = true;
            }
            return p == ptr + 2 && (dots == 1 || space);
        }
        return false;
    }

    private boolean match(byte[] b, byte[] src) {
        int r = RawParseUtils.match(b, this.bufPtr.value, src);
        if (r < 0) {
            return false;
        }
        this.bufPtr.value = r;
        return true;
    }

    private static char toLower(byte b) {
        if (65 <= b && b <= 90) {
            return (char)(b + 32);
        }
        return (char)b;
    }

    private static boolean isPositiveDigit(byte b) {
        return 49 <= b && b <= 57;
    }

    public void checkBlob(byte[] raw) throws CorruptObjectException {
    }

    private String normalize(byte[] raw, int ptr, int end) {
        String n = RawParseUtils.decode(raw, ptr, end).toLowerCase(Locale.US);
        return this.macosx ? Normalizer.normalize(n, Normalizer.Form.NFC) : n;
    }

    public static enum ErrorType {
        NULL_SHA1,
        DUPLICATE_ENTRIES,
        TREE_NOT_SORTED,
        ZERO_PADDED_FILEMODE,
        EMPTY_NAME,
        FULL_PATHNAME,
        HAS_DOT,
        HAS_DOTDOT,
        HAS_DOTGIT,
        BAD_OBJECT_SHA1,
        BAD_PARENT_SHA1,
        BAD_TREE_SHA1,
        MISSING_AUTHOR,
        MISSING_COMMITTER,
        MISSING_OBJECT,
        MISSING_TREE,
        MISSING_TYPE_ENTRY,
        MISSING_TAG_ENTRY,
        BAD_DATE,
        BAD_EMAIL,
        BAD_TIMEZONE,
        MISSING_EMAIL,
        MISSING_SPACE_BEFORE_DATE,
        UNKNOWN_TYPE,
        WIN32_BAD_NAME,
        BAD_UTF8;


        public String getMessageId() {
            String n = this.name();
            StringBuilder r = new StringBuilder(n.length());
            for (int i = 0; i < n.length(); ++i) {
                char c = n.charAt(i);
                if (c != '_') {
                    r.append(StringUtils.toLowerCase(c));
                    continue;
                }
                r.append(n.charAt(++i));
            }
            return r.toString();
        }
    }
}

