/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentMetadataBuilder;
import org.gradle.api.artifacts.ComponentMetadataSupplier;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentResolveState;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataAdapter;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;

public class MetadataProvider {
    private final ModuleComponentResolveState resolveState;
    private BuildableModuleComponentMetaDataResolveResult cachedResult;

    public MetadataProvider(ModuleComponentResolveState resolveState) {
        this.resolveState = resolveState;
    }

    public MetadataProvider(BuildableModuleComponentMetaDataResolveResult result) {
        this.resolveState = null;
        this.cachedResult = result;
    }

    public ComponentMetadata getComponentMetadata() {
        ComponentMetadataSupplier componentMetadataSupplier;
        ComponentMetadataSupplier componentMetadataSupplier2 = componentMetadataSupplier = this.resolveState == null ? null : this.resolveState.getComponentMetadataSupplier();
        if (componentMetadataSupplier != null) {
            final SimpleComponentMetadataBuilder builder = new SimpleComponentMetadataBuilder(DefaultModuleVersionIdentifier.newId(this.resolveState.getId()));
            ComponentMetadataSupplierDetails details = new ComponentMetadataSupplierDetails(){

                public ModuleComponentIdentifier getId() {
                    return MetadataProvider.this.resolveState.getId();
                }

                public ComponentMetadataBuilder getResult() {
                    return builder;
                }
            };
            componentMetadataSupplier.execute(details);
            if (builder.mutated) {
                return builder.build();
            }
        }
        if (this.resolve()) {
            return new ComponentMetadataAdapter(this.getMetaData());
        }
        return null;
    }

    @Nullable
    public IvyModuleDescriptor getIvyModuleDescriptor() {
        ModuleComponentResolveMetadata metaData = this.getMetaData();
        if (metaData instanceof IvyModuleResolveMetadata) {
            IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)metaData;
            return new DefaultIvyModuleDescriptor((Map<NamespaceId, String>)ivyMetadata.getExtraAttributes(), ivyMetadata.getBranch(), ivyMetadata.getStatus());
        }
        return null;
    }

    public boolean resolve() {
        if (this.cachedResult == null) {
            this.cachedResult = this.resolveState.resolve();
        }
        return this.cachedResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved;
    }

    public ModuleComponentResolveMetadata getMetaData() {
        this.resolve();
        return this.cachedResult.getMetaData();
    }

    public boolean isUsable() {
        return this.cachedResult == null || this.cachedResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved;
    }

    @Nullable
    public BuildableModuleComponentMetaDataResolveResult getResult() {
        return this.cachedResult;
    }

    private static class SimpleComponentMetadataBuilder
    implements ComponentMetadataBuilder {
        private final ModuleVersionIdentifier id;
        private boolean mutated;
        private String status;
        private List<String> statusScheme = ComponentResolveMetadata.DEFAULT_STATUS_SCHEME;

        private SimpleComponentMetadataBuilder(ModuleVersionIdentifier id) {
            this.id = id;
        }

        public void setStatus(String status) {
            this.status = status;
            this.mutated = true;
        }

        public void setStatusScheme(List<String> scheme) {
            this.statusScheme = scheme;
            this.mutated = true;
        }

        ComponentMetadata build() {
            return new UserProvidedMetadata(this.id, this.status, this.statusScheme);
        }

        private static class UserProvidedMetadata
        implements ComponentMetadata {
            private final ModuleVersionIdentifier id;
            private final String status;
            private final List<String> statusScheme;

            private UserProvidedMetadata(ModuleVersionIdentifier id, String status, List<String> statusScheme) {
                this.id = id;
                this.status = status;
                this.statusScheme = statusScheme;
            }

            public ModuleVersionIdentifier getId() {
                return this.id;
            }

            public boolean isChanging() {
                throw new UnsupportedOperationException();
            }

            public String getStatus() {
                return this.status;
            }

            public List<String> getStatusScheme() {
                return this.statusScheme;
            }
        }
    }
}

