/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import groovy.lang.Closure;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ComponentMetadataSupplier;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepositoryMetaDataProvider;
import org.gradle.api.artifacts.repositories.RepositoryLayout;
import org.gradle.api.artifacts.repositories.RepositoryResourceAccessor;
import org.gradle.api.internal.DefaultActionConfiguration;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.repositories.AbstractAuthenticationSupportedRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.layout.AbstractRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.DefaultIvyPatternRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.GradleRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.IvyRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.MavenRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.ResolvedPattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalRepositoryResourceAccessor;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.PatternBasedResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.util.ConfigureUtil;

public class DefaultIvyArtifactRepository
extends AbstractAuthenticationSupportedRepository
implements IvyArtifactRepository,
ResolutionAwareRepository,
PublicationAwareRepository {
    private static final Factory<ComponentMetadataSupplier> NO_METADATA_SUPPLIER = new Factory<ComponentMetadataSupplier>(){

        public ComponentMetadataSupplier create() {
            return null;
        }
    };
    private static final Object[] NO_PARAMS = new Object[0];
    private Object baseUrl;
    private AbstractRepositoryLayout layout;
    private final AdditionalPatternsRepositoryLayout additionalPatternsLayout;
    private final FileResolver fileResolver;
    private final RepositoryTransportFactory transportFactory;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final MetaDataProvider metaDataProvider;
    private final Instantiator instantiator;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final FileStore<String> externalResourcesFileStore;
    private final IvyContextManager ivyContextManager;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final InstantiatorFactory instantiatorFactory;
    private Class<? extends ComponentMetadataSupplier> componentMetadataSupplierClass;
    private Object[] componentMetadataSupplierParams;
    private final FileResourceRepository fileResourceRepository;

    public DefaultIvyArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, FileStore<String> externalResourcesFileStore, AuthenticationContainer authenticationContainer, IvyContextManager ivyContextManager, ImmutableModuleIdentifierFactory moduleIdentifierFactory, InstantiatorFactory instantiatorFactory, FileResourceRepository fileResourceRepository) {
        super(instantiatorFactory.decorate(), authenticationContainer);
        this.fileResolver = fileResolver;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.externalResourcesFileStore = externalResourcesFileStore;
        this.additionalPatternsLayout = new AdditionalPatternsRepositoryLayout(fileResolver);
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.fileResourceRepository = fileResourceRepository;
        this.layout = new GradleRepositoryLayout();
        this.metaDataProvider = new MetaDataProvider();
        this.instantiator = instantiatorFactory.decorate();
        this.ivyContextManager = ivyContextManager;
    }

    @Override
    public String getDisplayName() {
        URI url = this.getUrl();
        if (url == null) {
            return super.getDisplayName();
        }
        return super.getDisplayName() + '(' + url + ')';
    }

    @Override
    public ModuleVersionPublisher createPublisher() {
        return this.createRealResolver();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    protected IvyResolver createRealResolver() {
        URI uri = this.getUrl();
        LinkedHashSet<String> schemes = new LinkedHashSet<String>();
        this.layout.addSchemes(uri, schemes);
        this.additionalPatternsLayout.addSchemes(uri, schemes);
        IvyResolver resolver = this.createResolver(schemes);
        this.layout.apply(uri, resolver);
        this.additionalPatternsLayout.apply(uri, resolver);
        return resolver;
    }

    private IvyResolver createResolver(Set<String> schemes) {
        if (schemes.isEmpty()) {
            throw new InvalidUserDataException("You must specify a base url or at least one artifact pattern for an Ivy repository.");
        }
        return this.createResolver(this.transportFactory.createTransport(schemes, this.getName(), this.getConfiguredAuthentication()));
    }

    private IvyResolver createResolver(RepositoryTransport transport) {
        Instantiator instantiator = this.createDependencyInjectingInstantiator(transport);
        return new IvyResolver(this.getName(), transport, this.locallyAvailableResourceFinder, this.metaDataProvider.dynamicResolve, this.artifactFileStore, this.ivyContextManager, this.moduleIdentifierFactory, this.createComponentMetadataSupplierFactory(instantiator), this.fileResourceRepository);
    }

    private Instantiator createDependencyInjectingInstantiator(final RepositoryTransport transport) {
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        registry.addProvider(new Object(){

            RepositoryResourceAccessor createResourceAccessor() {
                return DefaultIvyArtifactRepository.this.createRepositoryAccessor(transport);
            }
        });
        return this.instantiatorFactory.inject((ServiceRegistry)registry);
    }

    private RepositoryResourceAccessor createRepositoryAccessor(RepositoryTransport transport) {
        return new ExternalRepositoryResourceAccessor(this.getUrl(), transport.getResourceAccessor(), this.externalResourcesFileStore);
    }

    private Factory<ComponentMetadataSupplier> createComponentMetadataSupplierFactory(final Instantiator instantiator) {
        if (this.componentMetadataSupplierClass == null) {
            return NO_METADATA_SUPPLIER;
        }
        return new Factory<ComponentMetadataSupplier>(){

            public ComponentMetadataSupplier create() {
                return (ComponentMetadataSupplier)instantiator.newInstance(DefaultIvyArtifactRepository.this.componentMetadataSupplierClass, DefaultIvyArtifactRepository.this.componentMetadataSupplierParams);
            }
        };
    }

    public URI getUrl() {
        return this.baseUrl == null ? null : this.fileResolver.resolveUri(this.baseUrl);
    }

    public void setUrl(URI url) {
        this.baseUrl = url;
    }

    public void setUrl(Object url) {
        this.baseUrl = url;
    }

    public void artifactPattern(String pattern) {
        this.additionalPatternsLayout.artifactPatterns.add(pattern);
    }

    public void ivyPattern(String pattern) {
        this.additionalPatternsLayout.ivyPatterns.add(pattern);
    }

    public void layout(String layoutName) {
        this.layout = "ivy".equals(layoutName) ? (AbstractRepositoryLayout)this.instantiator.newInstance(IvyRepositoryLayout.class, new Object[0]) : ("maven".equals(layoutName) ? (AbstractRepositoryLayout)this.instantiator.newInstance(MavenRepositoryLayout.class, new Object[0]) : ("pattern".equals(layoutName) ? (AbstractRepositoryLayout)this.instantiator.newInstance(DefaultIvyPatternRepositoryLayout.class, new Object[0]) : (AbstractRepositoryLayout)this.instantiator.newInstance(GradleRepositoryLayout.class, new Object[0])));
    }

    public void layout(String layoutName, Closure config) {
        this.layout(layoutName, (Action<? extends RepositoryLayout>)ConfigureUtil.configureUsing((Closure)config));
    }

    public void layout(String layoutName, Action<? extends RepositoryLayout> config) {
        this.layout(layoutName);
        config.execute((Object)this.layout);
    }

    public IvyArtifactRepositoryMetaDataProvider getResolve() {
        return this.metaDataProvider;
    }

    public void setMetadataSupplier(Class<? extends ComponentMetadataSupplier> ruleClass) {
        this.componentMetadataSupplierClass = ruleClass;
        this.componentMetadataSupplierParams = NO_PARAMS;
    }

    public void setMetadataSupplier(Class<? extends ComponentMetadataSupplier> rule, Action<? super ActionConfiguration> configureAction) {
        DefaultActionConfiguration configuration = new DefaultActionConfiguration();
        configureAction.execute((Object)configuration);
        this.componentMetadataSupplierClass = rule;
        this.componentMetadataSupplierParams = configuration.getParams();
    }

    private static class MetaDataProvider
    implements IvyArtifactRepositoryMetaDataProvider {
        boolean dynamicResolve;

        private MetaDataProvider() {
        }

        public boolean isDynamicMode() {
            return this.dynamicResolve;
        }

        public void setDynamicMode(boolean mode) {
            this.dynamicResolve = mode;
        }
    }

    private static class AdditionalPatternsRepositoryLayout
    extends AbstractRepositoryLayout {
        private final FileResolver fileResolver;
        private final Set<String> artifactPatterns = new LinkedHashSet<String>();
        private final Set<String> ivyPatterns = new LinkedHashSet<String>();

        public AdditionalPatternsRepositoryLayout(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        @Override
        public void apply(URI baseUri, PatternBasedResolver resolver) {
            for (String artifactPattern : this.artifactPatterns) {
                ResolvedPattern resolvedPattern = new ResolvedPattern(artifactPattern, this.fileResolver);
                resolver.addArtifactLocation(resolvedPattern.baseUri, resolvedPattern.pattern);
            }
            Set<String> usedIvyPatterns = this.ivyPatterns.isEmpty() ? this.artifactPatterns : this.ivyPatterns;
            for (String ivyPattern : usedIvyPatterns) {
                ResolvedPattern resolvedPattern = new ResolvedPattern(ivyPattern, this.fileResolver);
                resolver.addDescriptorLocation(resolvedPattern.baseUri, resolvedPattern.pattern);
            }
        }

        @Override
        public void addSchemes(URI baseUri, Set<String> schemes) {
            for (String pattern : this.artifactPatterns) {
                schemes.add(new ResolvedPattern((String)pattern, (FileResolver)this.fileResolver).scheme);
            }
            for (String pattern : this.ivyPatterns) {
                schemes.add(new ResolvedPattern((String)pattern, (FileResolver)this.fileResolver).scheme);
            }
        }
    }
}

