/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.DefaultCompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileNormaliser;
import org.gradle.api.internal.file.FileOrUriNotationConverter;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.resources.internal.LocalResourceAdapter;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.resource.LocalBinaryResource;
import org.gradle.internal.resource.local.LocalFileStandInExternalResource;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.CollectionUtils;
import org.gradle.util.DeferredUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileResolver
implements FileResolver {
    private final FileSystem fileSystem;
    private final NotationParser<Object, Object> fileNotationParser;
    private final Factory<PatternSet> patternSetFactory;
    private final FileNormaliser fileNormaliser;

    protected AbstractFileResolver(FileSystem fileSystem, Factory<PatternSet> patternSetFactory) {
        this.fileSystem = fileSystem;
        this.fileNormaliser = new FileNormaliser(fileSystem);
        this.fileNotationParser = FileOrUriNotationConverter.parser(fileSystem);
        this.patternSetFactory = patternSetFactory;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public FileResolver withBaseDir(Object path) {
        return new BaseDirFileResolver(this.fileSystem, this.resolve(path), this.patternSetFactory);
    }

    @Override
    public FileResolver newResolver(File baseDir) {
        return new BaseDirFileResolver(this.fileSystem, baseDir, this.patternSetFactory);
    }

    public File resolve(Object path) {
        return this.resolve(path, PathValidation.NONE);
    }

    @Override
    public NotationParser<Object, File> asNotationParser() {
        return new NotationParser<Object, File>(){

            public File parseNotation(Object notation) throws UnsupportedNotationException {
                return AbstractFileResolver.this.resolve(notation, PathValidation.NONE);
            }

            public void describe(DiagnosticsVisitor visitor) {
                visitor.candidate("Anything that can be converted to a file, as per Project.file()");
            }
        };
    }

    @Override
    public File resolve(Object path, PathValidation validation) {
        File file = this.doResolve(path);
        file = this.fileNormaliser.normalise(file);
        this.validate(file, validation);
        return file;
    }

    public Factory<File> resolveLater(final Object path) {
        return new Factory<File>(){

            public File create() {
                return AbstractFileResolver.this.resolve(path);
            }
        };
    }

    @Override
    @Nullable
    public URI resolveUri(Object path) {
        return this.convertObjectToURI(path);
    }

    protected abstract File doResolve(Object var1);

    protected URI convertObjectToURI(Object path) {
        Object object = DeferredUtil.unpack(path);
        Object converted = this.fileNotationParser.parseNotation(object);
        if (converted instanceof File) {
            return this.resolve(converted).toURI();
        }
        return (URI)converted;
    }

    @Nullable
    protected File convertObjectToFile(Object path) {
        Object object = DeferredUtil.unpack(path);
        if (object == null) {
            return null;
        }
        Object converted = this.fileNotationParser.parseNotation(object);
        if (converted instanceof File) {
            return (File)converted;
        }
        throw new InvalidUserDataException(String.format("Cannot convert URL '%s' to a file.", converted));
    }

    protected void validate(File file, PathValidation validation) {
        switch (validation) {
            case NONE: {
                break;
            }
            case EXISTS: {
                if (file.exists()) break;
                throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
            }
            case FILE: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
                }
                if (file.isFile()) break;
                throw new InvalidUserDataException(String.format("File '%s' is not a file.", file));
            }
            case DIRECTORY: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("Directory '%s' does not exist.", file));
                }
                if (file.isDirectory()) break;
                throw new InvalidUserDataException(String.format("Directory '%s' is not a directory.", file));
            }
        }
    }

    @Override
    public FileCollectionInternal resolveFiles(Object ... paths) {
        if (paths.length == 1 && paths[0] instanceof FileCollection) {
            return (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)paths[0]);
        }
        return new DefaultConfigurableFileCollection(this, null, paths);
    }

    @Override
    public FileTreeInternal resolveFilesAsTree(Object ... paths) {
        return (FileTreeInternal)Cast.cast(FileTreeInternal.class, (Object)this.resolveFiles(paths).getAsFileTree());
    }

    @Override
    public FileTreeInternal compositeFileTree(List<? extends FileTree> fileTrees) {
        return new DefaultCompositeFileTree(CollectionUtils.checkedCast(FileTreeInternal.class, fileTrees));
    }

    @Override
    public ReadableResourceInternal resolveResource(Object path) {
        if (path instanceof ReadableResourceInternal) {
            return (ReadableResourceInternal)path;
        }
        return new LocalResourceAdapter((LocalBinaryResource)new LocalFileStandInExternalResource(this.resolve(path), this.fileSystem));
    }

    @Override
    public Factory<PatternSet> getPatternSetFactory() {
        return this.patternSetFactory;
    }
}

