/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.load.kotlin.PackageParts;
import kotlin.reflect.jvm.internal.impl.protobuf.ProtocolStringList;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationConfiguration;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmPackageTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, debugName);
    }

    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] bytes, @NotNull String debugName, @NotNull DeserializationConfiguration configuration) {
            int[] size$iv22;
            Object object;
            Intrinsics.checkParameterIsNotNull(debugName, "debugName");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream2 = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream2.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var9_14 = i$iv;
                    void var10_16 = i$iv++;
                    object = result$iv;
                    object[var10_16] = n3 = stream2.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion version = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (configuration.getSkipMetadataVersionCheck() || version.isCompatible()) {
                PackageParts packageParts;
                PackageParts answer$iv;
                Object value$iv;
                Object $receiver$iv;
                Object key$iv;
                JvmPackageTable.PackageTable packageTable = JvmPackageTable.PackageTable.parseFrom(stream2);
                if (packageTable == null) {
                    return EMPTY;
                }
                JvmPackageTable.PackageTable table = packageTable;
                LinkedHashMap result2 = new LinkedHashMap();
                for (JvmPackageTable.PackageParts proto : table.getPackagePartsList()) {
                    Object object2;
                    Map $i$f$IntArray = result2;
                    String string = proto.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "proto.packageFqName");
                    key$iv = string;
                    value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string2 = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull(string2, "proto.packageFqName");
                        answer$iv = new PackageParts(string2);
                        $receiver$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    packageParts = (PackageParts)object2;
                    key$iv = CollectionsKt.withIndex(proto.getClassNameList()).iterator();
                    while (key$iv.hasNext()) {
                        String string3;
                        $receiver$iv = (IndexedValue)key$iv.next();
                        int index2 = ((IndexedValue)$receiver$iv).component1();
                        String partShortName = (String)((IndexedValue)$receiver$iv).component2();
                        Integer n = CollectionsKt.getOrNull(proto.getMultifileFacadeIdList(), index2);
                        Integer multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                        Object object3 = packageParts;
                        String string4 = partShortName;
                        String string5 = string4;
                        Intrinsics.checkExpressionValueIsNotNull(string4, "partShortName");
                        if (multifileFacadeId != null) {
                            Integer n4;
                            ProtocolStringList protocolStringList = proto.getMultifileFacadeNameList();
                            String string6 = string5;
                            object = object3;
                            int p1 = ((Number)n4).intValue();
                            String string7 = (String)CollectionsKt.getOrNull(protocolStringList, p1);
                            object3 = object;
                            string5 = string6;
                            string3 = string7;
                        } else {
                            string3 = null;
                        }
                        ((PackageParts)object3).addPart(string5, string3);
                    }
                }
                for (JvmPackageTable.PackageParts proto : table.getMetadataPartsList()) {
                    Object object4;
                    $receiver$iv = result2;
                    Intrinsics.checkExpressionValueIsNotNull(proto.getPackageFqName(), "proto.packageFqName");
                    value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull(string, "proto.packageFqName");
                        answer$iv = new PackageParts(string);
                        $receiver$iv.put(key$iv, answer$iv);
                        object4 = answer$iv;
                    } else {
                        object4 = value$iv;
                    }
                    packageParts = (PackageParts)object4;
                    $receiver$iv = proto.getClassNameList();
                    Iterator iterator2 = $receiver$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        String p1 = (String)element$iv;
                        packageParts.addMetadataPart(p1);
                    }
                }
                return new ModuleMapping(result2, debugName, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

