/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl.providers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;

public class FileReferenceUtil {
    private FileReferenceUtil() {
    }

    @Nullable
    public static PsiFile findFile(@Nullable PsiElement element) {
        return element == null ? null : FileReferenceUtil.findFile(element.getReferences());
    }

    @Nullable
    public static PsiFile findFile(PsiReference ... references) {
        for (int i = references.length - 1; i >= 0; --i) {
            PsiReference ref = references[i];
            if (ref instanceof FileReferenceOwner && !(ref instanceof PsiFileReference)) {
                ref = ((FileReferenceOwner)((Object)ref)).getLastFileReference();
            }
            if (!(ref instanceof PsiFileReference)) continue;
            PsiElement file = references[i].resolve();
            return file instanceof PsiFile ? (PsiFile)file : null;
        }
        return null;
    }

    @Nullable
    public static PsiFileReference findFileReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceUtil", "findFileReference"));
        }
        PsiReference[] references = element.getReferences();
        for (int i = references.length - 1; i >= 0; --i) {
            PsiReference ref = references[i];
            if (ref instanceof FileReferenceOwner && !(ref instanceof PsiFileReference)) {
                ref = ((FileReferenceOwner)((Object)ref)).getLastFileReference();
            }
            if (!(ref instanceof PsiFileReference)) continue;
            return (PsiFileReference)references[i];
        }
        return null;
    }
}

