/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.AbstractNode;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineMetadataPropertiesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001*\u00020\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u001a\u0018\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0006*\u00020\u0002H\u0002\u001a$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0001\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003*\u00020\u0002H\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u0011\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003\u001a\u0012\u0010\u0015\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0016"}, d2={"buildGraph", "", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "", "globalCatchBlock", "collectFinallyPaths", "", "collectNodesToSplit", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "breakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectTargetBlocks", "replaceCoroutineFlowStatements", "", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "replaceLocalVariables", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "localVariables", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "replaceSpecialReferences", "kotlin-compiler"})
public final class CoroutinePassesKt {
    @NotNull
    public static final Set<JsNode> collectNodesToSplit(@NotNull JsNode $receiver, @NotNull Map<JsContinue, ? extends JsStatement> breakContinueTargets) {
        int countBefore;
        int countAfter;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(breakContinueTargets, "breakContinueTargets");
        JsNode root2 = $receiver;
        Set nodes = new LinkedHashSet();
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(nodes, root2, breakContinueTargets){
            private boolean childrenInSet;
            private int finallyLevel;
            final /* synthetic */ Set $nodes;
            final /* synthetic */ JsNode $root;
            final /* synthetic */ Map $breakContinueTargets;

            public final boolean getChildrenInSet() {
                return this.childrenInSet;
            }

            public final void setChildrenInSet(boolean bl) {
                this.childrenInSet = bl;
            }

            public final int getFinallyLevel() {
                return this.finallyLevel;
            }

            public final void setFinallyLevel(int n) {
                this.finallyLevel = n;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitExpressionStatement(x);
                if (MetadataProperties.isSuspend(x.getExpression())) {
                    Collection collection = this.$nodes;
                    JsExpression jsExpression = x.getExpression();
                    collection.add(jsExpression);
                    this.childrenInSet = true;
                } else {
                    Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x.getExpression());
                    if (assignment != null && MetadataProperties.isSuspend(assignment.getSecond())) {
                        Collection collection = this.$nodes;
                        JsExpression jsExpression = assignment.getSecond();
                        collection.add(jsExpression);
                        this.childrenInSet = true;
                    }
                }
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitReturn(x);
                if (this.$nodes.contains(this.$root) || this.finallyLevel > 0) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitBreak(@NotNull JsBreak x) {
                JsStatement breakTarget;
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitBreak(x);
                V v = this.$breakContinueTargets.get(x);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                if (this.$nodes.contains(breakTarget = (JsStatement)v)) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitContinue(@NotNull JsContinue x) {
                JsStatement continueTarget;
                Intrinsics.checkParameterIsNotNull(x, "x");
                super.visitContinue(x);
                V v = this.$breakContinueTargets.get(x);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                if (this.$nodes.contains(continueTarget = (JsStatement)v)) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitTry(@NotNull JsTry x) {
                int n;
                Intrinsics.checkParameterIsNotNull(x, "x");
                if (x.getFinallyBlock() != null) {
                    n = this.finallyLevel;
                    this.finallyLevel = n + 1;
                }
                super.visitTry(x);
                if (x.getFinallyBlock() != null) {
                    n = this.finallyLevel;
                    this.finallyLevel = n + -1;
                }
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                boolean oldChildrenInSet = this.childrenInSet;
                this.childrenInSet = false;
                node.acceptChildren(this);
                if (this.childrenInSet) {
                    Collection collection = this.$nodes;
                    collection.add(node);
                } else {
                    this.childrenInSet = oldChildrenInSet;
                }
            }
            {
                this.$nodes = $captured_local_variable$0;
                this.$root = $captured_local_variable$1;
                this.$breakContinueTargets = $captured_local_variable$2;
            }
        };
        do {
            countBefore = nodes.size();
            visitor2.accept($receiver);
        } while ((countAfter = nodes.size()) != countBefore);
        return nodes;
    }

    /*
     * WARNING - void declaration
     */
    public static final void replaceCoroutineFlowStatements(@NotNull List<CoroutineBlock> $receiver, @NotNull CoroutineTransformationContext context) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)$receiver);
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv;
            IndexedValue $index_block = (IndexedValue)element$iv$iv;
            int index2 = $index_block.component1();
            CoroutineBlock block = (CoroutineBlock)$index_block.component2();
            Pair<CoroutineBlock, Integer> pair = new Pair<CoroutineBlock, Integer>(block, index2);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map blockIndexes = destination$iv$iv;
        JsVisitorWithContextImpl blockReplacementVisitor2 = new JsVisitorWithContextImpl(context, blockIndexes){
            final /* synthetic */ CoroutineTransformationContext $context;
            final /* synthetic */ Map $blockIndexes;

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsDebugger x, @NotNull JsContext<? super JsStatement> ctx) {
                List<CoroutineBlock> finallyPath;
                Object $receiver;
                Object rhs;
                CoroutineBlock exceptionTarget;
                AbstractNode abstractNode;
                JsExpressionStatement $receiver2;
                JsContext<? super JsStatement> jsContext;
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                CoroutineBlock target = CoroutineMetadataPropertiesKt.getTargetBlock(x);
                if (target != null) {
                    JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getStateName(), JsAstUtils.stateMachineReceiver());
                    V v = this.$blockIndexes.get(target);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    JsIntLiteral rhs2 = new JsIntLiteral(((Number)v).intValue());
                    JsExpressionStatement jsExpressionStatement = new JsExpressionStatement(JsAstUtils.assignment(lhs, rhs2).source(x.getSource()));
                    jsContext = ctx;
                    $receiver2 = jsExpressionStatement;
                    CoroutineMetadataPropertiesKt.setTargetBlock($receiver2, true);
                    abstractNode = jsExpressionStatement;
                    jsContext.replaceMe((JsNode)abstractNode);
                }
                if ((exceptionTarget = CoroutineMetadataPropertiesKt.getTargetExceptionBlock(x)) != null) {
                    JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getExceptionStateName(), JsAstUtils.stateMachineReceiver());
                    V v = this.$blockIndexes.get(exceptionTarget);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    rhs = new JsIntLiteral(((Number)v).intValue());
                    $receiver2 = new JsExpressionStatement(JsAstUtils.assignment(lhs, (JsExpression)rhs).source(x.getSource()));
                    jsContext = ctx;
                    $receiver = $receiver2;
                    CoroutineMetadataPropertiesKt.setTargetExceptionBlock((JsExpressionStatement)$receiver, true);
                    abstractNode = $receiver2;
                    jsContext.replaceMe((JsNode)abstractNode);
                }
                if ((finallyPath = CoroutineMetadataPropertiesKt.getFinallyPath(x)) != null) {
                    rhs = finallyPath;
                    if (!rhs.isEmpty()) {
                        Collection<JsIntLiteral> collection;
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        JsArrayLiteral jsArrayLiteral;
                        JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getFinallyPathName(), JsAstUtils.stateMachineReceiver());
                        $receiver = finallyPath;
                        abstractNode = jsArrayLiteral;
                        jsContext = jsArrayLiteral;
                        void $i$a$2$apply = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            CoroutineBlock coroutineBlock = (CoroutineBlock)item$iv$iv;
                            collection = destination$iv$iv;
                            V v = this.$blockIndexes.get(it);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            JsIntLiteral jsIntLiteral = new JsIntLiteral(((Number)v).intValue());
                            collection.add(jsIntLiteral);
                        }
                        collection = (List)destination$iv$iv;
                        abstractNode((List<JsExpression>)collection);
                        JsContext<? super JsStatement> rhs3 = jsContext;
                        JsExpressionStatement jsExpressionStatement = new JsExpressionStatement(JsAstUtils.assignment(lhs, (JsExpression)((Object)rhs3)).source(x.getSource()));
                        jsContext = ctx;
                        JsExpressionStatement $receiver3 = jsExpressionStatement;
                        CoroutineMetadataPropertiesKt.setFinallyPath($receiver3, true);
                        abstractNode = jsExpressionStatement;
                        jsContext.replaceMe((JsNode)abstractNode);
                    } else {
                        ctx.removeMe();
                    }
                }
            }
            {
                this.$context = $captured_local_variable$0;
                this.$blockIndexes = $captured_local_variable$1;
            }
        };
        Iterable $receiver$iv2 = $receiver;
        for (Object element$iv : $receiver$iv2) {
            CoroutineBlock it = (CoroutineBlock)element$iv;
            blockReplacementVisitor2.accept((JsNode)it.getJsBlock());
        }
    }

    @NotNull
    public static final Map<CoroutineBlock, Set<CoroutineBlock>> buildGraph(@NotNull CoroutineBlock $receiver, @Nullable CoroutineBlock globalCatchBlock) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Set visitedBlocks = new LinkedHashSet();
        Map graph2 = new LinkedHashMap();
        Function1<CoroutineBlock, Unit> visitBlock$ = new Function1<CoroutineBlock, Unit>($receiver, visitedBlocks, graph2, globalCatchBlock){
            final /* synthetic */ CoroutineBlock receiver$0;
            final /* synthetic */ Set $visitedBlocks;
            final /* synthetic */ Map $graph;
            final /* synthetic */ CoroutineBlock $globalCatchBlock;

            public final void invoke(@NotNull CoroutineBlock block) {
                Object object;
                Collection<CoroutineBlock> finallyPath22;
                Intrinsics.checkParameterIsNotNull(block, "block");
                if (this.$visitedBlocks.contains(block)) {
                    return;
                }
                for (Collection<CoroutineBlock> finallyPath22 : CoroutinePassesKt.access$collectFinallyPaths(block)) {
                    for (Pair<T, R> object22 : CollectionsKt.zip((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf(block), (Iterable)finallyPath22), (Iterable)finallyPath22)) {
                        Object object2;
                        CoroutineBlock finallySource = (CoroutineBlock)object22.component1();
                        CoroutineBlock finallyTarget = (CoroutineBlock)object22.component2();
                        Object $receiver$iv = this.$graph;
                        V value$iv = $receiver$iv.get(finallySource);
                        if (value$iv == null) {
                            Set answer$iv = new LinkedHashSet<E>();
                            $receiver$iv.put(finallySource, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        if (!((Set)object2).add(finallyTarget)) continue;
                        $receiver$iv = this.$visitedBlocks;
                        $receiver$iv.remove(finallySource);
                    }
                }
                finallyPath22 = this.$visitedBlocks;
                finallyPath22.add(block);
                Object $receiver$iv = this.$graph;
                V v = $receiver$iv.get(block);
                if (v == null) {
                    Set answer$iv = new LinkedHashSet<E>();
                    $receiver$iv.put(block, answer$iv);
                    object = answer$iv;
                } else {
                    object = v;
                }
                Set successors = (Set)object;
                $receiver$iv = successors;
                Iterable iterable = CoroutinePassesKt.access$collectTargetBlocks(block);
                CollectionsKt.addAll($receiver$iv, iterable);
                if (Intrinsics.areEqual(block, this.receiver$0) && this.$globalCatchBlock != null) {
                    $receiver$iv = successors;
                    CoroutineBlock coroutineBlock = this.$globalCatchBlock;
                    $receiver$iv.add(coroutineBlock);
                }
                $receiver$iv = successors;
                Iterator<T> iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    T element$iv = iterator2.next();
                    CoroutineBlock p1 = (CoroutineBlock)element$iv;
                    this.invoke(p1);
                }
            }
            {
                this.receiver$0 = coroutineBlock;
                this.$visitedBlocks = set;
                this.$graph = map2;
                this.$globalCatchBlock = coroutineBlock2;
                super(1);
            }
        };
        visitBlock$.invoke($receiver);
        return graph2;
    }

    private static final Set<CoroutineBlock> collectTargetBlocks(@NotNull CoroutineBlock $receiver) {
        Set targetBlocks = new LinkedHashSet();
        $receiver.getJsBlock().accept(new RecursiveJsVisitor(targetBlocks){
            final /* synthetic */ Set $targetBlocks;

            public void visitDebugger(@NotNull JsDebugger x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Collection collection = this.$targetBlocks;
                Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(CoroutineMetadataPropertiesKt.getTargetExceptionBlock(x)), (Iterable)CollectionsKt.listOfNotNull(CoroutineMetadataPropertiesKt.getTargetBlock(x)));
                CollectionsKt.addAll(collection, iterable);
            }
            {
                this.$targetBlocks = $captured_local_variable$0;
            }
        });
        return targetBlocks;
    }

    private static final List<List<CoroutineBlock>> collectFinallyPaths(@NotNull CoroutineBlock $receiver) {
        List finallyPaths = new ArrayList();
        $receiver.getJsBlock().accept(new RecursiveJsVisitor(finallyPaths){
            final /* synthetic */ List $finallyPaths;

            public void visitDebugger(@NotNull JsDebugger x) {
                block0: {
                    List<CoroutineBlock> list2;
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    List<CoroutineBlock> list3 = CoroutineMetadataPropertiesKt.getFinallyPath(x);
                    if (list3 == null) break block0;
                    List<CoroutineBlock> it = list2 = list3;
                    Collection collection = this.$finallyPaths;
                    collection.add(it);
                }
            }
            {
                this.$finallyPaths = $captured_local_variable$0;
            }
        });
        return finallyPaths;
    }

    public static final void replaceSpecialReferences(@NotNull JsBlock $receiver, @NotNull CoroutineTransformationContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(context){
            final /* synthetic */ CoroutineTransformationContext $context;

            public void endVisit(@NotNull JsThisRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                ctx.replaceMe((JsNode)new JsNameRef(this.$context.getReceiverFieldName(), (JsExpression)new JsThisRef()));
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (MetadataProperties.getCoroutineReceiver(x)) {
                    ctx.replaceMe((JsNode)new JsThisRef());
                } else if (MetadataProperties.getCoroutineController(x)) {
                    JsNameRef jsNameRef = new JsNameRef(this.$context.getControllerFieldName(), x.getQualifier());
                    JsContext<? super JsNode> jsContext = ctx;
                    JsNameRef $receiver = jsNameRef;
                    $receiver.setSource(x.getSource());
                    MetadataProperties.setSideEffects($receiver, SideEffectKind.PURE);
                    JsNameRef jsNameRef2 = jsNameRef;
                    jsContext.replaceMe((JsNode)jsNameRef2);
                } else if (MetadataProperties.getCoroutineResult(x)) {
                    JsNameRef jsNameRef = new JsNameRef(this.$context.getMetadata().getResultName(), x.getQualifier());
                    JsContext<? super JsNode> jsContext = ctx;
                    JsNameRef $receiver = jsNameRef;
                    $receiver.setSource(x.getSource());
                    MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                    JsNameRef jsNameRef3 = jsNameRef;
                    jsContext.replaceMe((JsNode)jsNameRef3);
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        };
        visitor2.accept((JsNode)$receiver);
    }

    public static final void replaceLocalVariables(@NotNull JsBlock $receiver, @NotNull CoroutineTransformationContext context, @NotNull Set<? extends JsName> localVariables) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(localVariables, "localVariables");
        CoroutinePassesKt.replaceSpecialReferences($receiver, context);
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(localVariables, context){
            final /* synthetic */ Set $localVariables;
            final /* synthetic */ CoroutineTransformationContext $context;

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsFunction x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                Set<Object> freeVars = CollectionsKt.intersect((Iterable)CollectUtilsKt.collectFreeVariables(x), this.$localVariables);
                Collection collection = freeVars;
                if (!collection.isEmpty()) {
                    Map map2;
                    void $receiver$iv$iv;
                    Object freeVar22;
                    Object object;
                    Object object2;
                    Collection $receiver$iv$iv2;
                    JsFunction wrapperFunction = new JsFunction(x.getScope().getParent(), new JsBlock(), "");
                    JsInvocation wrapperInvocation = new JsInvocation((JsExpression)wrapperFunction, new JsExpression[0]);
                    Collection collection2 = wrapperFunction.getBody().getStatements();
                    JsReturn jsReturn = new JsReturn(x);
                    collection2.add(jsReturn);
                    Iterable $receiver$iv = freeVars;
                    int capacity$iv232 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
                    Iterable iterable = $receiver$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv232);
                    for (T element$iv$iv : $receiver$iv$iv2) {
                        object2 = destination$iv$iv;
                        JsName it = (JsName)element$iv$iv;
                        object = TuplesKt.to(it, JsScope.declareTemporaryName(it.getIdent()));
                        object2.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
                    }
                    Map nameMap = destination$iv$iv;
                    for (Object freeVar22 : freeVars) {
                        $receiver$iv$iv2 = wrapperFunction.getParameters();
                        V v = nameMap.get(freeVar22);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        destination$iv$iv = new JsParameter((JsName)v);
                        $receiver$iv$iv2.add(destination$iv$iv);
                        $receiver$iv$iv2 = wrapperInvocation.getArguments();
                        destination$iv$iv = new JsNameRef(this.$context.getFieldName((JsName)freeVar22), (JsExpression)new JsThisRef());
                        $receiver$iv$iv2.add(destination$iv$iv);
                    }
                    freeVar22 = nameMap;
                    JsNode jsNode = x.getBody();
                    JsFunction jsFunction = x;
                    Iterable capacity$iv232 = $receiver$iv;
                    Map destination$iv$iv2 = new LinkedHashMap<K, V>(MapsKt.mapCapacity($receiver$iv.size()));
                    Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        void it;
                        void it$iv$iv;
                        object2 = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv2;
                        K k = it$iv$iv.getKey();
                        object = (Map.Entry)element$iv$iv$iv;
                        K k2 = k;
                        map2 = map3;
                        JsNameRef jsNameRef = ((JsName)it.getValue()).makeRef();
                        map2.put(k2, jsNameRef);
                    }
                    map2 = destination$iv$iv2;
                    jsFunction.setBody((JsBlock)RewriteUtilsKt.replaceNames(jsNode, map2));
                    ctx.replaceMe((JsNode)wrapperInvocation);
                }
            }

            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (x.getQualifier() == null && CollectionsKt.contains(this.$localVariables, x.getName())) {
                    JsName jsName = x.getName();
                    if (jsName == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "x.name!!");
                    JsName fieldName = this.$context.getFieldName(jsName);
                    ctx.replaceMe((JsNode)new JsNameRef(fieldName, (JsExpression)new JsThisRef()).source(x.getSource()));
                }
            }

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsVars x, @NotNull JsContext<? super JsStatement> ctx) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                Iterable iterable = $receiver$iv = (Iterable)x.getVars();
                Collection destination$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator<T> iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    JsBinaryOperation jsBinaryOperation;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    JsVars.JsVar it = (JsVars.JsVar)element$iv$iv;
                    JsName jsName = it.getName();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "it.name");
                    JsName fieldName = this.$context.getFieldName(jsName);
                    JsExpression initExpression = it.getInitExpression();
                    JsBinaryOperation jsBinaryOperation2 = initExpression != null ? JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), it.getInitExpression()) : null;
                    if (jsBinaryOperation2 == null) continue;
                    JsBinaryOperation it$iv$iv = jsBinaryOperation = jsBinaryOperation2;
                    destination$iv$iv.add(it$iv$iv);
                }
                List assignments = (List)destination$iv$iv;
                Collection collection = assignments;
                if (!collection.isEmpty()) {
                    ctx.replaceMe((JsNode)new JsExpressionStatement(JsAstUtils.newSequence(assignments)));
                } else {
                    ctx.removeMe();
                }
            }
            {
                this.$localVariables = $captured_local_variable$0;
                this.$context = $captured_local_variable$1;
            }
        };
        visitor2.accept((JsNode)$receiver);
    }

    @NotNull
    public static final /* synthetic */ List access$collectFinallyPaths(@NotNull CoroutineBlock $receiver) {
        return CoroutinePassesKt.collectFinallyPaths($receiver);
    }

    @NotNull
    public static final /* synthetic */ Set access$collectTargetBlocks(@NotNull CoroutineBlock $receiver) {
        return CoroutinePassesKt.collectTargetBlocks($receiver);
    }
}

