/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableBiMap;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

public final class OperatorTable {
    private static final Map<KtToken, JsBinaryOperator> binaryOperatorsMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.PLUS, JsBinaryOperator.ADD)).put(KtTokens.MINUS, JsBinaryOperator.SUB)).put(KtTokens.MUL, JsBinaryOperator.MUL)).put(KtTokens.DIV, JsBinaryOperator.DIV)).put(KtTokens.EQ, JsBinaryOperator.ASG)).put(KtTokens.GT, JsBinaryOperator.GT)).put(KtTokens.GTEQ, JsBinaryOperator.GTE)).put(KtTokens.LT, JsBinaryOperator.LT)).put(KtTokens.LTEQ, JsBinaryOperator.LTE)).put(KtTokens.ANDAND, JsBinaryOperator.AND)).put(KtTokens.OROR, JsBinaryOperator.OR)).put(KtTokens.PERC, JsBinaryOperator.MOD)).put(KtTokens.PLUSEQ, JsBinaryOperator.ASG_ADD)).put(KtTokens.MINUSEQ, JsBinaryOperator.ASG_SUB)).put(KtTokens.DIVEQ, JsBinaryOperator.ASG_DIV)).put(KtTokens.MULTEQ, JsBinaryOperator.ASG_MUL)).put(KtTokens.PERCEQ, JsBinaryOperator.ASG_MOD)).put(KtTokens.IN_KEYWORD, JsBinaryOperator.INOP)).put(KtTokens.EQEQEQ, JsBinaryOperator.REF_EQ)).put(KtTokens.EXCLEQEQEQ, JsBinaryOperator.REF_NEQ)).build();
    private static final ImmutableBiMap<KtToken, JsUnaryOperator> unaryOperatorsMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.PLUSPLUS, JsUnaryOperator.INC)).put(KtTokens.MINUSMINUS, JsUnaryOperator.DEC)).put(KtTokens.EXCL, JsUnaryOperator.NOT)).put(KtTokens.MINUS, JsUnaryOperator.NEG)).put(KtTokens.PLUS, JsUnaryOperator.POS)).build();

    private OperatorTable() {
    }

    public static boolean hasCorrespondingOperator(@NotNull KtToken token) {
        if (token == null) {
            OperatorTable.$$$reportNull$$$0(0);
        }
        return binaryOperatorsMap.containsKey(token) || unaryOperatorsMap.containsKey(token);
    }

    public static boolean hasCorrespondingBinaryOperator(@NotNull KtToken token) {
        if (token == null) {
            OperatorTable.$$$reportNull$$$0(1);
        }
        return binaryOperatorsMap.containsKey(token);
    }

    @NotNull
    public static JsBinaryOperator getBinaryOperator(@NotNull KtToken token) {
        if (token == null) {
            OperatorTable.$$$reportNull$$$0(2);
        }
        assert (KtTokens.OPERATIONS.contains(token)) : "Token should represent an operation!";
        JsBinaryOperator jsBinaryOperator = binaryOperatorsMap.get(token);
        if (jsBinaryOperator == null) {
            OperatorTable.$$$reportNull$$$0(3);
        }
        return jsBinaryOperator;
    }

    @NotNull
    public static JsUnaryOperator getUnaryOperator(@NotNull KtToken token) {
        if (token == null) {
            OperatorTable.$$$reportNull$$$0(4);
        }
        assert (KtTokens.OPERATIONS.contains(token)) : "Token should represent an operation!";
        JsUnaryOperator jsUnaryOperator = (JsUnaryOperator)unaryOperatorsMap.get(token);
        if (jsUnaryOperator == null) {
            OperatorTable.$$$reportNull$$$0(5);
        }
        return jsUnaryOperator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/OperatorTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/OperatorTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryOperator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnaryOperator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasCorrespondingOperator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasCorrespondingBinaryOperator";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryOperator";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnaryOperator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

