/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Variable;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.eclipse.model.internal.ProjectDependencyBuilder;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.UnresolvedIdeRepoFileDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseDependenciesCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseDependenciesCreator.class);
    private final IdeDependenciesExtractor dependenciesExtractor = new IdeDependenciesExtractor();
    private final EclipseClasspath classpath;
    private final ProjectDependencyBuilder projectDependencyBuilder;

    public EclipseDependenciesCreator(EclipseClasspath classpath) {
        this.classpath = classpath;
        ServiceRegistry serviceRegistry = ((ProjectInternal)classpath.getProject()).getServices();
        this.projectDependencyBuilder = new ProjectDependencyBuilder((LocalComponentRegistry)serviceRegistry.get(LocalComponentRegistry.class));
    }

    public List<AbstractClasspathEntry> createDependencyEntries() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.createProjectDependencies());
        if (!this.classpath.isProjectDependenciesOnly()) {
            result.addAll(this.createLibraryDependencies());
        }
        return result;
    }

    public Collection<UnresolvedIdeRepoFileDependency> unresolvedExternalDependencies() {
        return this.dependenciesExtractor.unresolvedExternalDependencies(this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations());
    }

    private List<AbstractClasspathEntry> createProjectDependencies() {
        ArrayList projects = Lists.newArrayList();
        Collection<IdeProjectDependency> projectDependencies = this.dependenciesExtractor.extractProjectDependencies(this.classpath.getProject(), this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations());
        for (IdeProjectDependency projectDependency : projectDependencies) {
            projects.add(this.projectDependencyBuilder.build(projectDependency));
        }
        return projects;
    }

    private List<AbstractClasspathEntry> createLibraryDependencies() {
        ArrayList libraries = Lists.newArrayList();
        boolean downloadSources = this.classpath.isDownloadSources();
        boolean downloadJavadoc = this.classpath.isDownloadJavadoc();
        Multimap<String, String> pathToSourceSets = this.collectLibraryToSourceSetMapping();
        Collection<IdeExtendedRepoFileDependency> repoFileDependencies = this.dependenciesExtractor.extractRepoFileDependencies(this.classpath.getProject().getDependencies(), this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations(), downloadSources, downloadJavadoc);
        for (IdeExtendedRepoFileDependency dependency : repoFileDependencies) {
            libraries.add(EclipseDependenciesCreator.createLibraryEntry(dependency.getFile(), dependency.getSourceFile(), dependency.getJavadocFile(), this.classpath, dependency.getId(), pathToSourceSets));
        }
        Collection<IdeLocalFileDependency> localFileDependencies = this.dependenciesExtractor.extractLocalFileDependencies(this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations());
        for (IdeLocalFileDependency it : localFileDependencies) {
            libraries.add(EclipseDependenciesCreator.createLibraryEntry(it.getFile(), null, null, this.classpath, null, pathToSourceSets));
        }
        return libraries;
    }

    private Multimap<String, String> collectLibraryToSourceSetMapping() {
        LinkedHashMultimap pathToSourceSetNames = LinkedHashMultimap.create();
        Iterable<SourceSet> sourceSets = this.classpath.getSourceSets();
        if (sourceSets == null) {
            return pathToSourceSetNames;
        }
        for (SourceSet sourceSet : sourceSets) {
            for (File f : this.collectClasspathFiles(sourceSet)) {
                pathToSourceSetNames.put((Object)f.getAbsolutePath(), (Object)sourceSet.getName().replace(",", ""));
            }
        }
        return pathToSourceSetNames;
    }

    private Collection<File> collectClasspathFiles(SourceSet sourceSet) {
        ImmutableList.Builder result = ImmutableList.builder();
        try {
            result.addAll((Iterable)sourceSet.getRuntimeClasspath());
        }
        catch (Exception e) {
            LOGGER.debug("Failed to collect source sets for Eclipse dependencies", (Throwable)e);
        }
        return result.build();
    }

    private static AbstractLibrary createLibraryEntry(File binary, File source, File javadoc, EclipseClasspath classpath, ModuleVersionIdentifier id, Multimap<String, String> pathToSourceSets) {
        FileReferenceFactory referenceFactory = classpath.getFileReferenceFactory();
        FileReference binaryRef = referenceFactory.fromFile(binary);
        FileReference sourceRef = referenceFactory.fromFile(source);
        FileReference javadocRef = referenceFactory.fromFile(javadoc);
        AbstractLibrary out = binaryRef.isRelativeToPathVariable() ? new Variable(binaryRef) : new Library(binaryRef);
        out.setJavadocPath(javadocRef);
        out.setSourcePath(sourceRef);
        out.setExported(false);
        out.setModuleVersion(id);
        Collection sourceSets = pathToSourceSets.get((Object)binary.getAbsolutePath());
        if (sourceSets != null) {
            out.getEntryAttributes().put("gradle_used_by_scope", Joiner.on((char)',').join((Iterable)sourceSets));
        }
        return out;
    }
}

