
/*
 Copyright 2013, Kovid Goyal <kovid at kovidgoyal.net>
 Released under the GPLv3 License
*/


(function() {
  var AnchorLocator, calibre_anchor_locator, log,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  if (typeof window !== "undefined" && window !== null ? window.calibre_utils : void 0) {
    log = window.calibre_utils.log;
  }

  AnchorLocator = (function() {

    AnchorLocator.name = 'AnchorLocator';

    /*
        # Allow the user to click on any block level element to choose it as the
        # location for an anchor.
    */


    function AnchorLocator() {
      this.find_blocks = __bind(this.find_blocks, this);
      if (!this instanceof arguments.callee) {
        throw new Error('AnchorLocator constructor called as function');
      }
    }

    AnchorLocator.prototype.find_blocks = function() {
      var elem, style, _i, _len, _ref, _ref1, _results;
      _ref = document.body.getElementsByTagName('*');
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        elem = _ref[_i];
        style = window.getComputedStyle(elem);
        if ((_ref1 = style.display) === 'block' || _ref1 === 'flex-box' || _ref1 === 'box') {
          elem.className += " calibre_toc_hover";
          _results.push(elem.onclick = this.onclick);
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    AnchorLocator.prototype.onclick = function(event) {
      var frac, loc, num, parent, sibling, totals;
      event.stopPropagation();
      frac = window.pageYOffset / document.body.scrollHeight;
      loc = [];
      totals = [];
      parent = this;
      while (parent && parent.tagName.toLowerCase() !== 'body') {
        totals.push(parent.parentNode.children.length);
        num = 0;
        sibling = parent.previousElementSibling;
        while (sibling) {
          num += 1;
          sibling = sibling.previousElementSibling;
        }
        loc.push(num);
        parent = parent.parentNode;
      }
      loc.reverse();
      totals.reverse();
      window.py_bridge.onclick(this, JSON.stringify(loc), JSON.stringify(totals), frac);
      return false;
    };

    return AnchorLocator;

  })();

  calibre_anchor_locator = new AnchorLocator();

  calibre_anchor_locator.find_blocks();

}).call(this);

