/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmDecimalFormatSymbolsProvider;
import org.openstreetmap.josm.tools.Logging;

public class ImageryAdjustAction
extends MapMode
implements AWTEventListener {
    private static volatile ImageryOffsetDialog offsetDialog;
    private static Cursor cursor;
    private OffsetBookmark old;
    private OffsetBookmark tempOffset;
    private EastNorth prevEastNorth;
    private transient AbstractTileSourceLayer<?> layer;
    private MapMode oldMapMode;

    public ImageryAdjustAction(AbstractTileSourceLayer<?> layer) {
        super(I18n.tr("New offset", new Object[0]), "adjustimg", I18n.tr("Adjust the position of this imagery layer", new Object[0]), cursor);
        this.putValue("toolbar", Boolean.FALSE);
        this.layer = layer;
    }

    @Override
    public void enterMode() {
        super.enterMode();
        if (this.layer == null) {
            return;
        }
        if (!this.layer.isVisible()) {
            this.layer.setVisible(true);
        }
        this.old = this.layer.getDisplaySettings().getOffsetBookmark();
        EastNorth curOff = this.old == null ? EastNorth.ZERO : this.old.getDisplacement(Main.getProjection());
        LatLon center = MainApplication.isDisplayingMapView() ? Main.getProjection().eastNorth2latlon(MainApplication.getMap().mapView.getCenter()) : LatLon.ZERO;
        this.tempOffset = new OffsetBookmark(Main.getProjection().toCode(), this.layer.getInfo().getName(), null, curOff, center);
        this.layer.getDisplaySettings().setOffsetBookmark(this.tempOffset);
        this.addListeners();
        ImageryAdjustAction.showOffsetDialog(new ImageryOffsetDialog());
    }

    private static void showOffsetDialog(ImageryOffsetDialog dlg) {
        offsetDialog = dlg;
        offsetDialog.setVisible(true);
    }

    private static void hideOffsetDialog() {
        offsetDialog.setVisible(false);
        offsetDialog = null;
    }

    protected void addListeners() {
        MapView mapView = MainApplication.getMap().mapView;
        mapView.addMouseListener(this);
        mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Logging.error(ex);
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        if (offsetDialog != null) {
            if (this.layer != null) {
                this.layer.getDisplaySettings().setOffsetBookmark(this.old);
            }
            ImageryAdjustAction.hideOffsetDialog();
        }
        this.removeListeners();
    }

    protected void removeListeners() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Logging.error(ex);
        }
        if (MainApplication.isDisplayingMapView()) {
            MapFrame map = MainApplication.getMap();
            map.mapView.removeMouseMotionListener(this);
            map.mapView.removeMouseListener(this);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (!(event instanceof KeyEvent) || event.getID() != 401 || this.layer == null || offsetDialog != null && ImageryAdjustAction.offsetDialog.areFieldsInFocus()) {
            return;
        }
        KeyEvent kev = (KeyEvent)event;
        int dx = 0;
        int dy = 0;
        switch (kev.getKeyCode()) {
            case 38: {
                dy = 1;
                break;
            }
            case 40: {
                dy = -1;
                break;
            }
            case 37: {
                dx = -1;
                break;
            }
            case 39: {
                dx = 1;
                break;
            }
        }
        if (dx != 0 || dy != 0) {
            double ppd = this.layer.getPPD();
            EastNorth d = this.tempOffset.getDisplacement().add(new EastNorth((double)dx / ppd, (double)dy / ppd));
            this.tempOffset.setDisplacement(d);
            this.layer.getDisplaySettings().setOffsetBookmark(this.tempOffset);
            if (offsetDialog != null) {
                ImageryAdjustAction.offsetDialog.updateOffset();
            }
            if (Logging.isDebugEnabled()) {
                Logging.debug("{0} consuming event {1}", this.getClass().getName(), kev);
            }
            kev.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.layer.isVisible()) {
            this.requestFocusInMapView();
            MapView mapView = MainApplication.getMap().mapView;
            this.prevEastNorth = mapView.getEastNorth(e.getX(), e.getY());
            mapView.setNewCursor(13, (Object)this);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.layer == null || this.prevEastNorth == null) {
            return;
        }
        EastNorth eastNorth = MainApplication.getMap().mapView.getEastNorth(e.getX(), e.getY());
        EastNorth d = this.tempOffset.getDisplacement().add(eastNorth).subtract(this.prevEastNorth);
        this.tempOffset.setDisplacement(d);
        this.layer.getDisplaySettings().setOffsetBookmark(this.tempOffset);
        if (offsetDialog != null) {
            ImageryAdjustAction.offsetDialog.updateOffset();
        }
        this.prevEastNorth = eastNorth;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MapView mapView = MainApplication.getMap().mapView;
        mapView.repaint();
        mapView.resetCursor(this);
        this.prevEastNorth = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MapFrame map = MainApplication.getMap();
        if (offsetDialog != null || this.layer == null || map == null) {
            return;
        }
        this.oldMapMode = map.mapMode;
        super.actionPerformed(e);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.removeListeners();
        this.layer = null;
        this.oldMapMode = null;
    }

    static {
        cursor = ImageProvider.getCursor("normal", "move");
    }

    private class ImageryOffsetDialog
    extends ExtendedDialog
    implements FocusListener {
        private final JosmTextField tOffset;
        private final JosmTextField tBookmarkName;
        private boolean ignoreListener;

        ImageryOffsetDialog() {
            super(Main.parent, I18n.tr("Adjust imagery offset", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
            this.tOffset = new JosmTextField();
            this.tBookmarkName = new JosmTextField();
            this.setButtonIcons("ok", "cancel");
            this.contentInsets = new Insets(10, 15, 5, 15);
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)new JMultilineLabel(I18n.tr("Use arrow keys or drag the imagery layer with mouse to adjust the imagery offset.\nYou can also enter east and north offset in the {0} coordinates.\nIf you want to save the offset as bookmark, enter the bookmark name below", Main.getProjection().toString())), GBC.eop());
            pnl.add((Component)new JLabel(I18n.tr("Offset: ", new Object[0])), GBC.std());
            pnl.add((Component)this.tOffset, GBC.eol().fill(2).insets(0, 0, 0, 5));
            pnl.add((Component)new JLabel(I18n.tr("Bookmark name: ", new Object[0])), GBC.std());
            pnl.add((Component)this.tBookmarkName, GBC.eol().fill(2));
            this.tOffset.setColumns(16);
            this.updateOffsetIntl();
            this.tOffset.addFocusListener(this);
            this.setContent(pnl);
            this.setupDialog();
            this.addWindowListener(new WindowEventHandler());
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, this.getSize()));
        }

        private boolean areFieldsInFocus() {
            return this.tOffset.hasFocus();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.ignoreListener) {
                return;
            }
            String ostr = this.tOffset.getText();
            int semicolon = ostr.indexOf(59);
            if (ImageryAdjustAction.this.layer != null && semicolon >= 0 && semicolon + 1 < ostr.length()) {
                try {
                    String easting = ostr.substring(0, semicolon).trim();
                    String northing = ostr.substring(semicolon + 1).trim();
                    double dx = JosmDecimalFormatSymbolsProvider.parseDouble(easting);
                    double dy = JosmDecimalFormatSymbolsProvider.parseDouble(northing);
                    ImageryAdjustAction.this.tempOffset.setDisplacement(new EastNorth(dx, dy));
                    ImageryAdjustAction.this.layer.getDisplaySettings().setOffsetBookmark(ImageryAdjustAction.this.tempOffset);
                }
                catch (NumberFormatException nfe) {
                    Logging.trace(nfe);
                }
            }
            this.updateOffsetIntl();
            if (MainApplication.isDisplayingMapView()) {
                MainApplication.getMap().repaint();
            }
        }

        private void updateOffset() {
            this.ignoreListener = true;
            this.updateOffsetIntl();
            this.ignoreListener = false;
        }

        private void updateOffsetIntl() {
            if (ImageryAdjustAction.this.layer != null) {
                int precision = Main.getProjection().getDefaultZoomInPPD() >= 1.0 ? 2 : 7;
                try (Formatter us = new Formatter(Locale.US);){
                    EastNorth displacement = ImageryAdjustAction.this.layer.getDisplaySettings().getDisplacement();
                    this.tOffset.setText(us.format("%1." + precision + "f; %1." + precision + 'f', displacement.east(), displacement.north()).toString());
                }
            }
        }

        private boolean confirmOverwriteBookmark() {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite", new Object[0]), new String[]{I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])}){
                {
                    this.contentInsets = new Insets(10, 15, 10, 15);
                }
            };
            dialog.setContent(I18n.tr("Offset bookmark already exists. Overwrite?", new Object[0]));
            dialog.setButtonIcons("ok", "cancel");
            dialog.setupDialog();
            dialog.setVisible(true);
            return dialog.getValue() == 1;
        }

        @Override
        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            if (buttonIndex == 0 && this.tBookmarkName.getText() != null && !this.tBookmarkName.getText().isEmpty() && OffsetBookmark.getBookmarkByName(ImageryAdjustAction.this.layer, this.tBookmarkName.getText()) != null && !this.confirmOverwriteBookmark()) {
                return;
            }
            super.buttonAction(buttonIndex, evt);
            this.restoreMapModeState();
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                return;
            }
            offsetDialog = null;
            if (ImageryAdjustAction.this.layer != null) {
                if (this.getValue() != 1) {
                    ImageryAdjustAction.this.layer.getDisplaySettings().setOffsetBookmark(ImageryAdjustAction.this.old);
                } else if (this.tBookmarkName.getText() != null && !this.tBookmarkName.getText().isEmpty()) {
                    OffsetBookmark.bookmarkOffset(this.tBookmarkName.getText(), ImageryAdjustAction.this.layer);
                }
            }
            MainApplication.getMenu().imageryMenu.refreshOffsetMenu();
        }

        private void restoreMapModeState() {
            MapFrame map = MainApplication.getMap();
            if (map == null) {
                return;
            }
            if (ImageryAdjustAction.this.oldMapMode != null) {
                map.selectMapMode(ImageryAdjustAction.this.oldMapMode);
                ImageryAdjustAction.this.oldMapMode = null;
            } else {
                map.selectSelectTool(false);
            }
        }

        class WindowEventHandler
        extends WindowAdapter {
            WindowEventHandler() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ImageryOffsetDialog.this.setVisible(false);
                ImageryOffsetDialog.this.restoreMapModeState();
            }
        }
    }
}

