/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;

public class RegexValidator
extends AbstractValidator {
    private final Pattern[] patterns;

    public RegexValidator(String regex) {
        this(regex, true);
    }

    public RegexValidator(String regex, boolean caseSensitive) {
        this(new String[]{regex}, caseSensitive);
    }

    public RegexValidator(String ... regexs) {
        this(regexs, true);
    }

    public RegexValidator(String[] regexs, boolean caseSensitive) {
        if (regexs == null || regexs.length == 0) {
            throw new IllegalArgumentException("Regular expressions are missing");
        }
        this.patterns = new Pattern[regexs.length];
        int flags = caseSensitive ? 0 : 2;
        for (int i = 0; i < regexs.length; ++i) {
            if (regexs[i] == null || regexs[i].isEmpty()) {
                throw new IllegalArgumentException("Regular expression[" + i + "] is missing");
            }
            this.patterns[i] = Pattern.compile(regexs[i], flags);
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(value).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getValidatorName() {
        return null;
    }

    public String[] match(String value) {
        if (value == null) {
            return null;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            Matcher matcher = this.patterns[i].matcher(value);
            if (!matcher.matches()) continue;
            int count = matcher.groupCount();
            String[] groups = new String[count];
            for (int j = 0; j < count; ++j) {
                groups[j] = matcher.group(j + 1);
            }
            return groups;
        }
        return null;
    }

    public String validate(String value) {
        if (value == null) {
            return null;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            Matcher matcher = this.patterns[i].matcher(value);
            if (!matcher.matches()) continue;
            int count = matcher.groupCount();
            if (count == 1) {
                return matcher.group(1);
            }
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < count; ++j) {
                String component = matcher.group(j + 1);
                if (component == null) continue;
                buffer.append(component);
            }
            return buffer.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("RegexValidator{");
        for (int i = 0; i < this.patterns.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this.patterns[i].pattern());
        }
        buffer.append('}');
        return buffer.toString();
    }
}

