/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class BoundingBoxDownloader
extends OsmServerReader {
    protected final double lat1;
    protected final double lon1;
    protected final double lat2;
    protected final double lon2;
    protected final boolean crosses180th;

    public BoundingBoxDownloader(Bounds downloadArea) {
        CheckParameterUtil.ensureParameterNotNull(downloadArea, "downloadArea");
        this.lat1 = downloadArea.getMinLat();
        this.lon1 = downloadArea.getMinLon();
        this.lat2 = downloadArea.getMaxLat();
        this.lon2 = downloadArea.getMaxLon();
        this.crosses180th = downloadArea.crosses180thMeridian();
    }

    private GpxData downloadRawGps(Bounds b, ProgressMonitor progressMonitor) throws IOException, OsmTransferException, SAXException {
        boolean done = false;
        GpxData result = null;
        String url = "trackpoints?bbox=" + b.getMinLon() + ',' + b.getMinLat() + ',' + b.getMaxLon() + ',' + b.getMaxLat() + "&page=";
        int i = 0;
        while (!done && !this.isCanceled()) {
            block16: {
                progressMonitor.subTask(I18n.tr("Downloading points {0} to {1}...", i * 5000, (i + 1) * 5000));
                try (InputStream in = this.getInputStream(url + i, progressMonitor.createSubTaskMonitor(1, true));){
                    if (in == null) break;
                    progressMonitor.setTicks(0);
                    GpxReader reader = new GpxReader(in);
                    this.gpxParsedProperly = reader.parse(false);
                    GpxData currentGpx = reader.getGpxData();
                    if (result == null) {
                        result = currentGpx;
                    } else if (currentGpx.hasTrackPoints()) {
                        result.mergeFrom(currentGpx);
                    } else {
                        done = true;
                    }
                }
                catch (OsmApiException ex) {
                    throw ex;
                }
                catch (SocketException | OsmTransferException ex) {
                    if (!this.isCanceled()) break block16;
                    OsmTransferCanceledException canceledException = new OsmTransferCanceledException("Operation canceled");
                    canceledException.initCause(ex);
                    Logging.warn(canceledException);
                }
            }
            this.activeConnection = null;
            ++i;
        }
        if (result != null) {
            result.fromServer = true;
            result.dataSources.add(new DataSource(b, "OpenStreetMap server"));
        }
        return result;
    }

    @Override
    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        try {
            progressMonitor.indeterminateSubTask(this.getTaskName());
            if (this.crosses180th) {
                GpxData result = this.downloadRawGps(new Bounds(this.lat1, this.lon1, this.lat2, 180.0), progressMonitor);
                if (result != null) {
                    result.mergeFrom(this.downloadRawGps(new Bounds(this.lat1, -180.0, this.lat2, this.lon2), progressMonitor));
                }
                GpxData gpxData = result;
                return gpxData;
            }
            GpxData result = this.downloadRawGps(new Bounds(this.lat1, this.lon1, this.lat2, this.lon2), progressMonitor);
            return result;
        }
        catch (IllegalArgumentException e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException("Illegal characters within the HTTP-header response.", e);
        }
        catch (IOException e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException(e);
        }
        catch (SAXException e) {
            throw new OsmTransferException(e);
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalStateException | JosmRuntimeException e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw e;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected String getTaskName() {
        return I18n.tr("Contacting OSM Server...", new Object[0]);
    }

    protected String getRequestForBbox(double lon1, double lat1, double lon2, double lat2) {
        return "map?bbox=" + lon1 + ',' + lat1 + ',' + lon2 + ',' + lat2;
    }

    protected DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return OsmReader.parseDataSet(source, progressMonitor);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(this.getTaskName(), 10);
        try {
            DataSet ds = null;
            progressMonitor.indeterminateSubTask(null);
            if (this.crosses180th) {
                DataSet ds2 = null;
                try (InputStream in = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, 180.0, this.lat2), progressMonitor.createSubTaskMonitor(9, false));){
                    if (in == null) {
                        DataSet dataSet = null;
                        return dataSet;
                    }
                    ds = this.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
                }
                in = this.getInputStream(this.getRequestForBbox(-180.0, this.lat1, this.lon2, this.lat2), progressMonitor.createSubTaskMonitor(9, false));
                var5_8 = null;
                try {
                    if (in == null) {
                        DataSet dataSet = null;
                        return dataSet;
                    }
                    ds2 = this.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (Throwable throwable) {
                    var5_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        BoundingBoxDownloader.$closeResource(var5_8, in);
                    }
                }
                if (ds2 == null) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                ds.mergeFrom(ds2);
            } else {
                try (InputStream in = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, this.lon2, this.lat2), progressMonitor.createSubTaskMonitor(9, false));){
                    if (in == null) {
                        DataSet dataSet = null;
                        return dataSet;
                    }
                    ds = this.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
                }
            }
            DataSet dataSet = ds;
            return dataSet;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IOException | IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }

    @Override
    public List<Note> parseNotes(int noteLimit, int daysClosed, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(I18n.tr("Downloading notes", new Object[0]));
        CheckParameterUtil.ensureThat(noteLimit > 0, "Requested note limit is less than 1.");
        CheckParameterUtil.ensureThat(noteLimit <= 10000, "Requested note limit is over API hard limit of 10000.");
        CheckParameterUtil.ensureThat(daysClosed >= -1, "Requested note limit is less than -1.");
        String url = "notes?limit=" + noteLimit + "&closed=" + daysClosed + "&bbox=" + this.lon1 + ',' + this.lat1 + ',' + this.lon2 + ',' + this.lat2;
        try {
            InputStream is = this.getInputStream(url, progressMonitor.createSubTaskMonitor(1, false));
            NoteReader reader = new NoteReader(is);
            List<Note> notes = reader.parse();
            if (notes.size() == noteLimit) {
                throw new MoreNotesException(notes, noteLimit);
            }
            List<Note> list = notes;
            return list;
        }
        catch (IOException | SAXException e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public static class MoreNotesException
    extends RuntimeException {
        public final transient List<Note> notes;
        public final int limit;

        public MoreNotesException(List<Note> notes, int limit) {
            this.notes = notes;
            this.limit = limit;
        }
    }
}

